/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sale.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleTargetPayload;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetCustomerQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.vo.ExamInformationVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetCountResultVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetCountVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetVO;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetUserCustomerFieldEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetUserLeadsFieldEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetUserOppoFieldEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetUserVisitFieldEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SearchScopeEnum;
import com.elitesland.tw.tw5crm.server.sale.entity.QSaleGoalDO;
import com.elitesland.tw.tw5crm.server.sale.entity.QSaleTargetDO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleTargetDO;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleTargetRepo;
import com.elitesland.tw.tw5crm.server.visit.entity.QVisitTaskDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class SaleTargetDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final SaleTargetRepo repo;
    private final QSaleTargetDO qdo = QSaleTargetDO.saleTargetDO;
    private final QSaleTargetDO qSaleTargetDO = new QSaleTargetDO("qSaleTargetDO");
    private final QSaleGoalDO qSaleGoalDO = QSaleGoalDO.saleGoalDO;
    private final QVisitTaskDO qVisitTaskDO = QVisitTaskDO.visitTaskDO;
    private final QCrmCustomerDO qCrmCustomerDO = QCrmCustomerDO.crmCustomerDO;
    private final QPrdAbDO qdoAb = QPrdAbDO.prdAbDO;
    private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdOrgEmployeeRefDO qPrdOrgEmployeeRefDO = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgOrganizationDO qPrdOrgOrganizationDO = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QCrmLeadsDO qCrmLeadsDO = QCrmLeadsDO.crmLeadsDO;
    private final QPrdOrgEmployeeDO qPrdOrgEmployeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrjProjectDO qPrjProjectDO = QPrjProjectDO.prjProjectDO;
    private final QCrmOpportunityDO qCrmOpportunityDO = QCrmOpportunityDO.crmOpportunityDO;

    private JPAQuery<SaleTargetVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetVO.class, (Expression[])new Expression[]{this.qdo.id, this.qSaleGoalDO.id, this.qSaleGoalDO.goalName, this.qSaleGoalDO.goalType, this.qdo.goalId, this.qdo.parentId, this.qdo.goalName, this.qdo.fiscalYear, this.qdo.firstQuarter, this.qdo.secondQuarter, this.qdo.thirdQuarter, this.qdo.forthQuarter, this.qdo.january, this.qdo.february, this.qdo.march, this.qdo.april, this.qdo.may, this.qdo.june, this.qdo.july, this.qdo.august, this.qdo.september, this.qdo.october, this.qdo.november, this.qdo.december, this.qdo.targetCount, this.qdo.goalType, this.qdo.dutyId, this.qdo.dutyName, this.qdo.skuId, this.qdo.skuName, this.qdo.spuId, this.qdo.spuName, this.qdo.customerId, this.qdo.customerName, this.qdo.objId, this.qdo.objName, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qSaleTargetDO)).on((Predicate)this.qdo.parentId.eq(this.qSaleTargetDO.parentId))).leftJoin((EntityPath)this.qSaleGoalDO)).on((Predicate)this.qdo.goalId.eq(this.qSaleGoalDO.id));
    }

    private JPAQuery<SaleTargetVO> getJpaQueryWhere(SaleTargetQuery query) {
        JPAQuery<SaleTargetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public List<SaleTargetVO> queryByTargetIds(List<Long> targetIds) {
        JPAQuery<SaleTargetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(targetIds));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long count(SaleTargetQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(SaleTargetQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoalId())) {
            list.add(this.qdo.goalId.eq((Object)query.getGoalId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentId())) {
            list.add(this.qdo.parentId.eq((Object)query.getParentId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoalName())) {
            list.add(this.qdo.goalName.like(SqlUtil.toSqlLikeString(query.getGoalName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFiscalYear())) {
            list.add(this.qdo.fiscalYear.eq((Object)query.getFiscalYear()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFirstQuarter())) {
            list.add(this.qdo.firstQuarter.eq((Object)query.getFirstQuarter()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSecondQuarter())) {
            list.add(this.qdo.secondQuarter.eq((Object)query.getSecondQuarter()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getThirdQuarter())) {
            list.add(this.qdo.thirdQuarter.eq((Object)query.getThirdQuarter()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getForthQuarter())) {
            list.add(this.qdo.forthQuarter.eq((Object)query.getForthQuarter()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getJanuary())) {
            list.add(this.qdo.january.eq((Object)query.getJanuary()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFebruary())) {
            list.add(this.qdo.february.eq((Object)query.getFebruary()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMarch())) {
            list.add(this.qdo.march.eq((Object)query.getMarch()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApril())) {
            list.add(this.qdo.april.eq((Object)query.getApril()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMay())) {
            list.add(this.qdo.may.eq((Object)query.getMay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getJune())) {
            list.add(this.qdo.june.eq((Object)query.getJune()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getJuly())) {
            list.add(this.qdo.july.eq((Object)query.getJuly()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAugust())) {
            list.add(this.qdo.august.eq((Object)query.getAugust()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSeptember())) {
            list.add(this.qdo.september.eq((Object)query.getSeptember()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOctober())) {
            list.add(this.qdo.october.eq((Object)query.getOctober()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNovember())) {
            list.add(this.qdo.november.eq((Object)query.getNovember()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDecember())) {
            list.add(this.qdo.december.eq((Object)query.getDecember()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTargetCount())) {
            list.add(this.qdo.targetCount.eq((Object)query.getTargetCount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoalType())) {
            list.add(this.qdo.goalType.eq((Object)query.getGoalType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDutyId())) {
            list.add(this.qdo.dutyId.eq((Object)query.getDutyId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDutyName())) {
            list.add(this.qdo.dutyName.eq((Object)query.getDutyName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSkuId())) {
            list.add(this.qdo.skuId.eq((Object)query.getSkuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSkuName())) {
            list.add(this.qdo.skuName.eq((Object)query.getSkuName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerId())) {
            list.add(this.qdo.customerId.eq((Object)query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
            list.add(this.qdo.customerName.eq((Object)query.getCustomerName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjId())) {
            list.add(this.qdo.objId.eq((Object)query.getObjId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjName())) {
            list.add(this.qdo.objName.eq((Object)query.getObjName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    public SaleTargetVO queryByKey(Long id) {
        JPAQuery<SaleTargetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (SaleTargetVO)jpaQuery.fetchFirst();
    }

    public List<SaleTargetVO> queryListDynamic(SaleTargetQuery query) {
        JPAQuery<SaleTargetVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<SaleTargetVO> queryPaging(SaleTargetQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<SaleTargetVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public SaleTargetDO save(SaleTargetDO ado) {
        return (SaleTargetDO)this.repo.save(ado);
    }

    public List<SaleTargetDO> saveAll(List<SaleTargetDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(SaleTargetPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getGoalId() != null) {
            update.set(this.qdo.goalId, (Object)payload.getGoalId());
        }
        if (payload.getParentId() != null) {
            update.set(this.qdo.parentId, (Object)payload.getParentId());
        }
        if (payload.getGoalName() != null) {
            update.set((Path)this.qdo.goalName, (Object)payload.getGoalName());
        }
        if (payload.getFiscalYear() != null) {
            update.set(this.qdo.fiscalYear, (Object)payload.getFiscalYear());
        }
        if (payload.getFirstQuarter() != null) {
            update.set(this.qdo.firstQuarter, (Object)payload.getFirstQuarter());
        }
        if (payload.getSecondQuarter() != null) {
            update.set(this.qdo.secondQuarter, (Object)payload.getSecondQuarter());
        }
        if (payload.getThirdQuarter() != null) {
            update.set(this.qdo.thirdQuarter, (Object)payload.getThirdQuarter());
        }
        if (payload.getForthQuarter() != null) {
            update.set(this.qdo.forthQuarter, (Object)payload.getForthQuarter());
        }
        if (payload.getJanuary() != null) {
            update.set(this.qdo.january, (Object)payload.getJanuary());
        }
        if (payload.getFebruary() != null) {
            update.set(this.qdo.february, (Object)payload.getFebruary());
        }
        if (payload.getMarch() != null) {
            update.set(this.qdo.march, (Object)payload.getMarch());
        }
        if (payload.getApril() != null) {
            update.set(this.qdo.april, (Object)payload.getApril());
        }
        if (payload.getMay() != null) {
            update.set(this.qdo.may, (Object)payload.getMay());
        }
        if (payload.getJune() != null) {
            update.set(this.qdo.june, (Object)payload.getJune());
        }
        if (payload.getJuly() != null) {
            update.set(this.qdo.july, (Object)payload.getJuly());
        }
        if (payload.getAugust() != null) {
            update.set(this.qdo.august, (Object)payload.getAugust());
        }
        if (payload.getSeptember() != null) {
            update.set(this.qdo.september, (Object)payload.getSeptember());
        }
        if (payload.getOctober() != null) {
            update.set(this.qdo.october, (Object)payload.getOctober());
        }
        if (payload.getNovember() != null) {
            update.set(this.qdo.november, (Object)payload.getNovember());
        }
        if (payload.getDecember() != null) {
            update.set(this.qdo.december, (Object)payload.getDecember());
        }
        if (payload.getTargetCount() != null) {
            update.set(this.qdo.targetCount, (Object)payload.getTargetCount());
        }
        if (payload.getGoalType() != null) {
            update.set((Path)this.qdo.goalType, (Object)payload.getGoalType());
        }
        if (payload.getDutyId() != null) {
            update.set(this.qdo.dutyId, (Object)payload.getDutyId());
        }
        if (payload.getDutyName() != null) {
            update.set((Path)this.qdo.dutyName, (Object)payload.getDutyName());
        }
        if (payload.getSkuId() != null) {
            update.set(this.qdo.skuId, (Object)payload.getSkuId());
        }
        if (payload.getSkuName() != null) {
            update.set((Path)this.qdo.skuName, (Object)payload.getSkuName());
        }
        if (payload.getCustomerId() != null) {
            update.set(this.qdo.customerId, (Object)payload.getCustomerId());
        }
        if (payload.getCustomerName() != null) {
            update.set((Path)this.qdo.customerName, (Object)payload.getCustomerName());
        }
        if (payload.getObjId() != null) {
            update.set(this.qdo.objId, (Object)payload.getObjId());
        }
        if (payload.getObjName() != null) {
            update.set((Path)this.qdo.objName, (Object)payload.getObjName());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("goalId")) {
                update.setNull(this.qdo.goalId);
            }
            if (nullFields.contains("parentId")) {
                update.setNull(this.qdo.parentId);
            }
            if (nullFields.contains("targetName")) {
                update.setNull((Path)this.qdo.goalName);
            }
            if (nullFields.contains("fiscalYear")) {
                update.setNull(this.qdo.fiscalYear);
            }
            if (nullFields.contains("firstQuarter")) {
                update.setNull(this.qdo.firstQuarter);
            }
            if (nullFields.contains("secondQuarter")) {
                update.setNull(this.qdo.secondQuarter);
            }
            if (nullFields.contains("thirdQuarter")) {
                update.setNull(this.qdo.thirdQuarter);
            }
            if (nullFields.contains("forthQuarter")) {
                update.setNull(this.qdo.forthQuarter);
            }
            if (nullFields.contains("january")) {
                update.setNull(this.qdo.january);
            }
            if (nullFields.contains("february")) {
                update.setNull(this.qdo.february);
            }
            if (nullFields.contains("march")) {
                update.setNull(this.qdo.march);
            }
            if (nullFields.contains("april")) {
                update.setNull(this.qdo.april);
            }
            if (nullFields.contains("may")) {
                update.setNull(this.qdo.may);
            }
            if (nullFields.contains("june")) {
                update.setNull(this.qdo.june);
            }
            if (nullFields.contains("july")) {
                update.setNull(this.qdo.july);
            }
            if (nullFields.contains("august")) {
                update.setNull(this.qdo.august);
            }
            if (nullFields.contains("september")) {
                update.setNull(this.qdo.september);
            }
            if (nullFields.contains("october")) {
                update.setNull(this.qdo.october);
            }
            if (nullFields.contains("november")) {
                update.setNull(this.qdo.november);
            }
            if (nullFields.contains("december")) {
                update.setNull(this.qdo.december);
            }
            if (nullFields.contains("targetCount")) {
                update.setNull(this.qdo.targetCount);
            }
            if (nullFields.contains("goalType")) {
                update.setNull((Path)this.qdo.goalType);
            }
            if (nullFields.contains("dutyId")) {
                update.setNull(this.qdo.dutyId);
            }
            if (nullFields.contains("dutyName")) {
                update.setNull((Path)this.qdo.dutyName);
            }
            if (nullFields.contains("spuId")) {
                update.setNull(this.qdo.skuId);
            }
            if (nullFields.contains("skuName")) {
                update.setNull((Path)this.qdo.skuName);
            }
            if (nullFields.contains("customerId")) {
                update.setNull(this.qdo.customerId);
            }
            if (nullFields.contains("customerName")) {
                update.setNull((Path)this.qdo.customerName);
            }
            if (nullFields.contains("objId")) {
                update.setNull(this.qdo.objId);
            }
            if (nullFields.contains("objName")) {
                update.setNull((Path)this.qdo.objName);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByGoalId(Long goalId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.goalId.eq((Object)goalId)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<SaleTargetCountResultVO> countCustomerVisitActual(SaleTargetStatisticalQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != query.getCustomerId()) {
            list.add(this.qVisitTaskDO.customerId.in(query.getCustomerIds()));
        }
        if (null != query.getStartTime()) {
            list.add(this.qVisitTaskDO.modifyTime.goe((Comparable)query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(this.qVisitTaskDO.modifyTime.loe((Comparable)query.getEndTime()));
        }
        query.getExamInformationVOList().forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)query.getUserIds())) {
                            list.add(this.qVisitTaskDO.visitMemberId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        // empty if block
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qVisitTaskDO.status.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.AREA.getCode())) {
                    // empty if block
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountResultVO.class, (Expression[])new Expression[]{this.qVisitTaskDO.customerId, this.qVisitTaskDO.customerName, this.qVisitTaskDO.count().as("actualCountLong")})).from((EntityPath)this.qVisitTaskDO)).leftJoin((EntityPath)this.qCrmCustomerDO)).on((Predicate)this.qVisitTaskDO.customerId.eq(this.qCrmCustomerDO.id))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate)).groupBy(this.qVisitTaskDO.customerId);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetCountResultVO> countUserVisitActual(SaleTargetStatisticalQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != query.getStartTime()) {
            list.add(this.qVisitTaskDO.modifyTime.goe((Comparable)query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(this.qVisitTaskDO.modifyTime.loe((Comparable)query.getEndTime()));
        }
        query.getExamInformationVOList().forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)query.getUserIds())) {
                            list.add(this.qVisitTaskDO.visitMemberId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        // empty if block
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qVisitTaskDO.status.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.AREA.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qVisitTaskDO.customerName.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountResultVO.class, (Expression[])new Expression[]{this.qVisitTaskDO.visitMemberId.as("userId"), this.qVisitTaskDO.count().as("actualCountLong")})).from((EntityPath)this.qVisitTaskDO)).leftJoin((EntityPath)this.qCrmCustomerDO)).on((Predicate)this.qVisitTaskDO.customerId.eq(this.qCrmCustomerDO.id))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate)).groupBy(this.qVisitTaskDO.visitMemberId);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetCountResultVO> countClueByExamInformation(SaleTargetStatisticalQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != query.getUserId()) {
            list.add(this.qCrmLeadsDO.sourceUserId.eq((Object)query.getUserId()));
        }
        if (null != query.getStartTime()) {
            list.add(this.qCrmLeadsDO.modifyTime.goe((Comparable)query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(this.qCrmLeadsDO.modifyTime.loe((Comparable)query.getEndTime()));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        query.getExamInformationVOList().forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.SOURCE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)query.getUserIds())) {
                            list.add(this.qCrmLeadsDO.sourceUserId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmLeadsDO.sourceUserId.eq((Object)query.getUserId()));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmLeadsDO.leadsStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmLeadsDO.leadsStatus.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmLeadsDO.leadsStage.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmLeadsDO.leadsStage.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_GRADE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountResultVO.class, (Expression[])new Expression[]{this.qCrmLeadsDO.sourceUserId.as("userId"), this.qCrmLeadsDO.count().as("actualCountLong")})).from((EntityPath)this.qCrmLeadsDO)).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qCrmLeadsDO.sourceUserId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgOrganizationDO.id.eq(this.qPrdOrgEmployeeRefDO.orgId))).leftJoin((EntityPath)this.qCrmCustomerDO)).on((Predicate)this.qCrmLeadsDO.customer.id.eq(this.qCrmCustomerDO.id))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate)).groupBy(this.qCrmLeadsDO.sourceUserId);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetCountResultVO> countOppoByExamInformation(SaleTargetStatisticalQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != query.getOrgId()) {
            list.add(this.qPrdOrgOrganizationDO.id.eq((Object)query.getOrgId()));
        }
        if (null != query.getUserId()) {
            list.add(this.qPrjProjectDO.manageUserId.eq((Object)query.getUserId()));
        }
        if (null != query.getStartTime()) {
            list.add(this.qCrmOpportunityDO.modifyTime.goe((Comparable)query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(this.qCrmOpportunityDO.modifyTime.loe((Comparable)query.getEndTime()));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrjProjectDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        query.getExamInformationVOList().forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)query.getUserIds())) {
                            list.add(this.qPrjProjectDO.manageUserId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qPrjProjectDO.manageUserId.eq((Object)query.getUserId()));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROJECT_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qPrjProjectDO.projectStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qPrjProjectDO.projectStatus.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.OPPO_LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmOpportunityDO.oppoLevel.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmOpportunityDO.oppoLevel.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.SALE_PHASE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmOpportunityDO.salePhase.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmOpportunityDO.salePhase.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROBABILITY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmOpportunityDO.probability.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmOpportunityDO.probability.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountResultVO.class, (Expression[])new Expression[]{this.qPrjProjectDO.manageUserId.as("userId"), this.qCrmOpportunityDO.count().as("actualCountLong")})).from((EntityPath)this.qCrmOpportunityDO)).leftJoin((EntityPath)this.qPrjProjectDO)).on((Predicate)this.qPrjProjectDO.id.eq(this.qCrmOpportunityDO.projectId))).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qPrjProjectDO.manageUserId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgOrganizationDO.id.eq(this.qPrdOrgEmployeeRefDO.orgId))).where(predicate)).groupBy(this.qPrjProjectDO.manageUserId);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetCountResultVO> countCustomerByExam(SaleTargetStatisticalQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != query.getOrgId()) {
            list.add(this.qPrdOrgOrganizationDO.id.eq((Object)query.getOrgId()));
        }
        if (null != query.getUserId()) {
            list.add(this.qCrmCustomerDO.businessUserId.eq((Object)query.getUserId()));
        }
        if (null != query.getStartTime()) {
            list.add(this.qCrmCustomerDO.modifyTime.goe((Comparable)query.getStartTime()));
        }
        if (null != query.getEndTime()) {
            list.add(this.qCrmCustomerDO.modifyTime.loe((Comparable)query.getEndTime()));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        list.add(this.qdoAb.deleteFlag.eq((Object)0));
        list.add(this.qdoCompany.deleteFlag.eq((Object)0));
        list.add(this.qCrmCustomerDO.businessUserId.isNotNull());
        query.getExamInformationVOList().forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)query.getUserIds())) {
                            list.add(this.qCrmCustomerDO.businessUserId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.businessUserId.eq((Object)query.getUserId()));
                    }
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.CUSTOMER_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerStatus.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.AREA.getCode())) {
                    // empty if block
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountResultVO.class, (Expression[])new Expression[]{this.qCrmCustomerDO.businessUserId.as("userId"), this.qCrmCustomerDO.count().as("actualCountLong")})).from((EntityPath)this.qCrmCustomerDO)).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qCrmCustomerDO.businessUserId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgOrganizationDO.id.eq(this.qPrdOrgEmployeeRefDO.orgId))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate)).groupBy(this.qCrmCustomerDO.businessUserId);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetCountVO> countOrgVisitByExamInformation(Long goalId, List<ExamInformationVO> examInformationVOS, Long orgId, Long userId, Set<Long> userIds) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != orgId) {
            list.add(this.qPrdOrgOrganizationDO.id.eq((Object)orgId));
        }
        if (null != userId) {
            list.add(this.qVisitTaskDO.visitMemberId.eq((Object)userId));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.isCopy.eq((Object)0));
        examInformationVOS.forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode()) && searchScope.equals(SearchScopeEnum.BELONG.getCode()) && !CollectionUtils.isEmpty((Collection)userIds)) {
                    list.add(this.qVisitTaskDO.visitMemberId.in((Collection)userIds));
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qVisitTaskDO.status.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountVO.class, (Expression[])new Expression[]{this.qVisitTaskDO.count().as("sumCountLong")})).from((EntityPath)this.qVisitTaskDO)).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qVisitTaskDO.visitMemberId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.orgId.eq(this.qPrdOrgOrganizationDO.id))).leftJoin((EntityPath)this.qCrmCustomerDO)).on((Predicate)this.qVisitTaskDO.customerId.eq(this.qCrmCustomerDO.id))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetCountVO> countOrgClueByExamInformation(Long goalId, List<ExamInformationVO> examInformationVOS, Long orgId, Long userId, Set<Long> userIds) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != orgId) {
            list.add(this.qPrdOrgOrganizationDO.id.eq((Object)orgId));
        }
        if (null != userId) {
            list.add(this.qCrmLeadsDO.sourceUserId.eq((Object)userId));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        examInformationVOS.forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)userIds)) {
                            list.add(this.qCrmLeadsDO.sourceUserId.in((Collection)userIds));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmLeadsDO.sourceUserId.eq((Object)userId));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmLeadsDO.leadsStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmLeadsDO.leadsStatus.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.LEADS_STAGE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmLeadsDO.leadsStage.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmLeadsDO.leadsStage.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_GRADE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserLeadsFieldEnum.CUSTOMER_INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountVO.class, (Expression[])new Expression[]{this.qCrmLeadsDO.count().as("sumCountLong")})).from((EntityPath)this.qCrmLeadsDO)).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qCrmLeadsDO.sourceUserId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgOrganizationDO.id.eq(this.qPrdOrgEmployeeRefDO.orgId))).leftJoin((EntityPath)this.qCrmCustomerDO)).on((Predicate)this.qCrmLeadsDO.customer.id.eq(this.qCrmCustomerDO.id))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetCountVO> countOrgOppoByExamInformation(Long goalId, List<ExamInformationVO> examInformationVOS, Long orgId, Long userId, Set<Long> userIds) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != orgId) {
            list.add(this.qPrdOrgOrganizationDO.id.eq((Object)orgId));
        }
        if (null != userId) {
            list.add(this.qPrjProjectDO.manageUserId.eq((Object)userId));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrjProjectDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        examInformationVOS.forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode()) && searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                    if (!CollectionUtils.isEmpty((Collection)userIds)) {
                        list.add(this.qPrjProjectDO.manageUserId.in((Collection)userIds));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qPrjProjectDO.manageUserId.eq((Object)userId));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROJECT_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qPrjProjectDO.projectStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qPrjProjectDO.projectStatus.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.OPPO_LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmOpportunityDO.oppoLevel.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmOpportunityDO.oppoLevel.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.SALE_PHASE.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmOpportunityDO.salePhase.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmOpportunityDO.salePhase.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.PROBABILITY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmOpportunityDO.probability.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmOpportunityDO.probability.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountVO.class, (Expression[])new Expression[]{this.qCrmOpportunityDO.count().as("sumCountLong")})).from((EntityPath)this.qCrmOpportunityDO)).leftJoin((EntityPath)this.qPrjProjectDO)).on((Predicate)this.qPrjProjectDO.id.eq(this.qCrmOpportunityDO.projectId))).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qPrjProjectDO.manageUserId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgOrganizationDO.id.eq(this.qPrdOrgEmployeeRefDO.orgId))).where(predicate);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetCountVO> countOrgCustomerByExamInformation(Long goalId, List<ExamInformationVO> examInformationVOS, Long orgId, Long userId, Set<Long> userIds) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != orgId) {
            list.add(this.qPrdOrgOrganizationDO.id.eq((Object)orgId));
        }
        if (null != userId) {
            list.add(this.qCrmCustomerDO.businessUserId.eq((Object)userId));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        list.add(this.qdoAb.deleteFlag.eq((Object)0));
        list.add(this.qdoCompany.deleteFlag.eq((Object)0));
        list.add(this.qCrmCustomerDO.businessUserId.isNotNull());
        examInformationVOS.forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserOppoFieldEnum.MANAGE_USER_ID.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)userIds)) {
                            list.add(this.qCrmCustomerDO.businessUserId.in((Collection)userIds));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.businessUserId.eq((Object)userId));
                    }
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.CUSTOMER_STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerStatus.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerStatus.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.AREA.getCode())) {
                    // empty if block
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserCustomerFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountVO.class, (Expression[])new Expression[]{this.qCrmCustomerDO.count().as("sumCountLong")})).from((EntityPath)this.qCrmCustomerDO)).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qCrmCustomerDO.businessUserId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgOrganizationDO.id.eq(this.qPrdOrgEmployeeRefDO.orgId))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetCountVO> countCustomerByExamInformation(List<ExamInformationVO> examInformationVOS, SaleTargetCustomerQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getCustomerGrade())) {
            list.add(this.qCrmCustomerDO.customerGrade.eq((Object)query.getCustomerGrade()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerIndustry())) {
            list.add(this.qdoCompany.companyIndustry.eq((Object)query.getCustomerIndustry()));
        }
        if (null != query.getCustomerId()) {
            list.add(this.qVisitTaskDO.customerId.in(query.getCustomerIds()));
        }
        list.add(this.qCrmCustomerDO.deleteFlag.eq((Object)0));
        examInformationVOS.forEach(examInformationVO -> {
            String fieldKey = examInformationVO.getFieldKey();
            String searchScope = examInformationVO.getSearchScope();
            String searchCondition = examInformationVO.getSearchCondition();
            if (!ObjectUtils.isEmpty((Object)fieldKey) && !ObjectUtils.isEmpty((Object)searchCondition)) {
                List<String> searchConditionList = Arrays.asList(searchCondition.split(","));
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.DUTY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        if (!CollectionUtils.isEmpty((Collection)query.getUserIds())) {
                            list.add(this.qVisitTaskDO.visitMemberId.in(query.getUserIds()));
                        }
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        // empty if block
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.STATUS.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qVisitTaskDO.status.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qVisitTaskDO.status.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.AREA.getCode())) {
                    // empty if block
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.LEVEL.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qCrmCustomerDO.customerGrade.eq((Object)searchCondition));
                    }
                }
                if (fieldKey.equals(SaleTargetUserVisitFieldEnum.INDUSTRY.getCode())) {
                    if (searchScope.equals(SearchScopeEnum.BELONG.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.in(searchConditionList));
                    } else if (searchScope.equals(SearchScopeEnum.EQ.getCode())) {
                        list.add(this.qdoCompany.companyIndustry.eq((Object)searchCondition));
                    }
                }
            }
        });
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetCountVO.class, (Expression[])new Expression[]{this.qVisitTaskDO.count().as("sumCountLong")})).from((EntityPath)this.qVisitTaskDO)).leftJoin((EntityPath)this.qCrmCustomerDO)).on((Predicate)this.qVisitTaskDO.customerId.eq(this.qCrmCustomerDO.id))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate);
        List resultList = jpaQuery.fetch();
        return resultList;
    }

    public List<SaleTargetVO> countUserSaleTarget(Long goalId, String ext1, Long userId, Long orgId) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != goalId) {
            list.add(this.qSaleTargetDO.goalId.eq((Object)goalId));
        }
        if (!ObjectUtils.isEmpty((Object)ext1)) {
            list.add(this.qSaleTargetDO.ext1.eq((Object)ext1));
        }
        if (null != userId) {
            list.add(this.qSaleTargetDO.dutyId.eq((Object)userId));
        }
        if (null != orgId) {
            list.add(this.qPrdOrgOrganizationDO.id.eq((Object)orgId));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetVO.class, (Expression[])new Expression[]{this.qSaleTargetDO.targetCount.sum().as("targetCount"), this.qSaleTargetDO.dutyId})).from((EntityPath)this.qSaleTargetDO)).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qSaleTargetDO.dutyId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgOrganizationDO.id.eq(this.qPrdOrgEmployeeRefDO.orgId))).groupBy(this.qSaleTargetDO.dutyId)).where(predicate);
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    public List<SaleTargetVO> countCustomerSaleTarget(SaleTargetCustomerQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != query.getGoalId()) {
            list.add(this.qSaleTargetDO.goalId.eq((Object)query.getGoalId()));
        }
        if (null != query.getCustomerId()) {
            list.add(this.qSaleTargetDO.customerId.eq((Object)query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qSaleTargetDO.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerGrade())) {
            list.add(this.qCrmCustomerDO.customerGrade.eq((Object)query.getCustomerGrade()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerIndustry())) {
            list.add(this.qdoCompany.companyIndustry.eq((Object)query.getCustomerIndustry()));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetVO.class, (Expression[])new Expression[]{this.qSaleTargetDO.targetCount.sum().as("targetCount")})).from((EntityPath)this.qSaleTargetDO)).leftJoin((EntityPath)this.qCrmCustomerDO)).on((Predicate)this.qSaleTargetDO.customerId.eq(this.qCrmCustomerDO.id))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate);
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    public List<SaleTargetVO> countCustomerIdAndUserId(SaleTargetCustomerQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != query.getGoalId()) {
            list.add(this.qSaleTargetDO.goalId.eq((Object)query.getGoalId()));
        }
        if (null != query.getCustomerId()) {
            list.add(this.qSaleTargetDO.customerId.eq((Object)query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qSaleTargetDO.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerGrade())) {
            list.add(this.qCrmCustomerDO.customerGrade.eq((Object)query.getCustomerGrade()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerIndustry())) {
            list.add(this.qdoCompany.companyIndustry.eq((Object)query.getCustomerIndustry()));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetVO.class, (Expression[])new Expression[]{this.qSaleTargetDO.dutyId, this.qSaleTargetDO.customerId})).from((EntityPath)this.qSaleTargetDO)).leftJoin((EntityPath)this.qCrmCustomerDO)).on((Predicate)this.qSaleTargetDO.customerId.eq(this.qCrmCustomerDO.id))).leftJoin((EntityPath)this.qdoAb)).on((Predicate)this.qdoAb.id.eq(this.qCrmCustomerDO.bookId))).leftJoin((EntityPath)this.qdoCompany)).on((Predicate)this.qdoAb.id.eq(this.qdoCompany.bookId))).where(predicate)).groupBy(this.qSaleTargetDO.dutyId);
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    public List<SaleTargetVO> countCustomerSaleTarget(Long goalId, String ext1) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != goalId) {
            list.add(this.qSaleTargetDO.goalId.eq((Object)goalId));
        }
        if (!ObjectUtils.isEmpty((Object)ext1)) {
            list.add(this.qSaleTargetDO.ext1.eq((Object)ext1));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetVO.class, (Expression[])new Expression[]{this.qSaleTargetDO.targetCount.sum().as("targetCount"), this.qSaleTargetDO.dutyId, this.qSaleTargetDO.customerId, this.qSaleTargetDO.customerName})).from((EntityPath)this.qSaleTargetDO)).groupBy(this.qSaleTargetDO.customerId)).where(predicate);
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    public List<SaleTargetVO> countProductSaleTarget(Long goalId, String ext1) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != goalId) {
            list.add(this.qSaleTargetDO.goalId.eq((Object)goalId));
        }
        if (!ObjectUtils.isEmpty((Object)ext1)) {
            list.add(this.qSaleTargetDO.ext1.eq((Object)ext1));
        }
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetVO.class, (Expression[])new Expression[]{this.qSaleTargetDO.targetCount.sum().as("targetCount"), this.qSaleTargetDO.dutyId, this.qSaleTargetDO.skuId, this.qSaleTargetDO.skuName})).from((EntityPath)this.qSaleTargetDO)).groupBy(this.qSaleTargetDO.skuId)).where(predicate);
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    public List<SaleTargetVO> countUserOrgSaleTarget(Long goalId, String ext1, Long orgId, Long userId) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != goalId) {
            list.add(this.qSaleTargetDO.goalId.eq((Object)goalId));
        }
        if (!ObjectUtils.isEmpty((Object)ext1)) {
            list.add(this.qSaleTargetDO.ext1.eq((Object)ext1));
        }
        if (!ObjectUtils.isEmpty((Object)userId)) {
            list.add(this.qSaleTargetDO.dutyId.eq((Object)userId));
        }
        if (!ObjectUtils.isEmpty((Object)orgId)) {
            list.add(this.qPrdOrgEmployeeRefDO.orgId.eq((Object)orgId));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetVO.class, (Expression[])new Expression[]{this.qSaleTargetDO.targetCount.sum().as("targetCount")})).from((EntityPath)this.qSaleTargetDO)).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qSaleTargetDO.dutyId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgOrganizationDO.id.eq(this.qPrdOrgEmployeeRefDO.orgId))).where(predicate);
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    public List<SaleTargetVO> countUserIds(Long goalId, String ext1, Long orgId, Long userId) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (null != goalId) {
            list.add(this.qSaleTargetDO.goalId.eq((Object)goalId));
        }
        if (!ObjectUtils.isEmpty((Object)ext1)) {
            list.add(this.qSaleTargetDO.ext1.eq((Object)ext1));
        }
        if (!ObjectUtils.isEmpty((Object)userId)) {
            list.add(this.qSaleTargetDO.dutyId.eq((Object)userId));
        }
        if (!ObjectUtils.isEmpty((Object)orgId)) {
            list.add(this.qPrdOrgEmployeeRefDO.orgId.eq((Object)orgId));
        }
        list.add(this.qPrdOrgEmployeeRefDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgOrganizationDO.deleteFlag.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isCopy.eq((Object)0));
        list.add(this.qPrdOrgEmployeeRefDO.isDefault.eq((Object)0));
        Predicate predicate = ExpressionUtils.allOf(list);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleTargetVO.class, (Expression[])new Expression[]{this.qSaleTargetDO.dutyId})).from((EntityPath)this.qSaleTargetDO)).leftJoin((EntityPath)this.qPrdOrgEmployeeRefDO)).on((Predicate)this.qPrdOrgEmployeeRefDO.userId.eq(this.qSaleTargetDO.dutyId))).leftJoin((EntityPath)this.qPrdOrgOrganizationDO)).on((Predicate)this.qPrdOrgOrganizationDO.id.eq(this.qPrdOrgEmployeeRefDO.orgId))).groupBy(this.qSaleTargetDO.dutyId)).where(predicate);
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    public SaleTargetDAO(JPAQueryFactory jpaQueryFactory, SaleTargetRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

