/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5crm.api.sale.payload.ExamInformationPayload;
import com.elitesland.tw.tw5crm.api.sale.query.ExamInformationQuery;
import com.elitesland.tw.tw5crm.api.sale.service.ExamInformationService;
import com.elitesland.tw.tw5crm.api.sale.vo.ExamInformationVO;
import com.elitesland.tw.tw5crm.server.sale.convert.ExamInformationConvert;
import com.elitesland.tw.tw5crm.server.sale.dao.ExamInformationDAO;
import com.elitesland.tw.tw5crm.server.sale.entity.ExamInformationDO;
import com.elitesland.tw.tw5crm.server.sale.repo.ExamInformationRepo;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ExamInformationServiceImpl
extends BaseServiceImpl
implements ExamInformationService {
    private static final Logger log = LoggerFactory.getLogger(ExamInformationServiceImpl.class);
    private final ExamInformationRepo examInformationRepo;
    private final ExamInformationDAO examInformationDAO;

    public PagingVO<ExamInformationVO> paging(ExamInformationQuery query) {
        Page page = this.examInformationRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(ExamInformationConvert.INSTANCE::toVo));
    }

    public PagingVO<ExamInformationVO> queryPaging(ExamInformationQuery query) {
        return this.examInformationDAO.queryPaging(query);
    }

    public List<ExamInformationVO> queryList(ExamInformationQuery query) {
        return ExamInformationConvert.INSTANCE.toVoList(this.examInformationRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<ExamInformationVO> queryListDynamic(ExamInformationQuery query) {
        if (query.getGoalId() == null) {
            throw TwException.error("", "goalId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.examInformationDAO.queryListDynamic(query);
    }

    public ExamInformationVO queryByKey(Long key) {
        ExamInformationDO entity = this.examInformationRepo.findById(key).orElseGet(ExamInformationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ExamInformationVO vo = ExamInformationConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ExamInformationVO insert(ExamInformationPayload payload) {
        ExamInformationDO entityDo = ExamInformationConvert.INSTANCE.toDo(payload);
        return ExamInformationConvert.INSTANCE.toVo((ExamInformationDO)this.examInformationRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ExamInformationVO update(ExamInformationPayload payload) {
        ExamInformationDO entity = this.examInformationRepo.findById(payload.getId()).orElseGet(ExamInformationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ExamInformationDO entityDo = ExamInformationConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ExamInformationConvert.INSTANCE.toVo((ExamInformationDO)this.examInformationRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.examInformationRepo.findById(id);
                if (!optional.isEmpty()) {
                    ExamInformationDO entity = (ExamInformationDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.examInformationRepo.save(entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByGoalId(Long goalId) {
        this.examInformationDAO.deleteSoftByGoalId(goalId);
    }

    public ExamInformationServiceImpl(ExamInformationRepo examInformationRepo, ExamInformationDAO examInformationDAO) {
        this.examInformationRepo = examInformationRepo;
        this.examInformationDAO = examInformationDAO;
    }
}

