/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5crm.api.sale.payload.SaleTargetPayload;
import com.elitesland.tw.tw5crm.api.sale.query.ExamInformationQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetCustomerQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetStatisticalQuery;
import com.elitesland.tw.tw5crm.api.sale.query.SaleTargetUserOrgQuery;
import com.elitesland.tw.tw5crm.api.sale.service.ExamInformationService;
import com.elitesland.tw.tw5crm.api.sale.service.SaleTargetService;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleGoalVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetCountResultVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetCountVO;
import com.elitesland.tw.tw5crm.api.sale.vo.SaleTargetVO;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetExamTargetEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SaleTargetSaleGoalTypeEnum;
import com.elitesland.tw.tw5crm.server.sale.convert.SaleTargetConvert;
import com.elitesland.tw.tw5crm.server.sale.dao.SaleGoalDAO;
import com.elitesland.tw.tw5crm.server.sale.dao.SaleTargetDAO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleGoalDO;
import com.elitesland.tw.tw5crm.server.sale.entity.SaleTargetDO;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleGoalRepo;
import com.elitesland.tw.tw5crm.server.sale.repo.SaleTargetRepo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SaleTargetServiceImpl
extends BaseServiceImpl
implements SaleTargetService {
    private static final Logger log = LoggerFactory.getLogger(SaleTargetServiceImpl.class);
    private final SaleTargetRepo saleTargetRepo;
    private final SaleTargetDAO saleTargetDAO;
    private final ExamInformationService examInformationService;
    private final SaleGoalDAO saleGoalDAO;
    private final SaleGoalRepo saleGoalRepo;

    public PagingVO<SaleTargetVO> paging(SaleTargetQuery query) {
        Page page = this.saleTargetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(SaleTargetConvert.INSTANCE::toVo));
    }

    public PagingVO<SaleTargetVO> queryPaging(SaleTargetQuery query) {
        return this.saleTargetDAO.queryPaging(query);
    }

    public List<SaleTargetVO> queryList(SaleTargetQuery query) {
        return SaleTargetConvert.INSTANCE.toVoList(this.saleTargetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<SaleTargetVO> queryListDynamic(SaleTargetQuery query) {
        return this.saleTargetDAO.queryListDynamic(query);
    }

    public SaleTargetVO queryByKey(Long key) {
        SaleTargetDO entity = this.saleTargetRepo.findById(key).orElseGet(SaleTargetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SaleTargetVO vo = SaleTargetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public SaleTargetVO insert(SaleTargetPayload payload) {
        SaleTargetDO entityDo = SaleTargetConvert.INSTANCE.toDo(payload);
        return SaleTargetConvert.INSTANCE.toVo((SaleTargetDO)this.saleTargetRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public SaleTargetVO update(SaleTargetPayload payload) {
        SaleTargetDO entity = this.saleTargetRepo.findById(payload.getId()).orElseGet(SaleTargetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SaleTargetDO entityDo = SaleTargetConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SaleTargetConvert.INSTANCE.toVo((SaleTargetDO)this.saleTargetRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.saleTargetRepo.findById(id);
                if (!optional.isEmpty()) {
                    SaleTargetDO entity = (SaleTargetDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.saleTargetRepo.save(entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByGoalId(Long goalId) {
        this.saleTargetDAO.deleteSoftByGoalId(goalId);
    }

    public List<SaleTargetCountResultVO> queryCountUserOrder(SaleTargetStatisticalQuery query) {
        ArrayList<SaleTargetCountResultVO> resultList = new ArrayList<SaleTargetCountResultVO>();
        Long goalId = query.getGoalId();
        Long userId = query.getUserId();
        if (goalId == null) {
            throw TwException.error("", "goalId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleGoalDO entity = this.saleGoalRepo.findById(goalId).orElseGet(SaleGoalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728");
        Integer fiscalYear = entity.getFiscalYear();
        if (query.getStartTime() == null) {
            query.setStartTime(LocalDateTime.of((int)fiscalYear, 1, 1, 0, 0, 0));
        }
        if (query.getEndTime() == null) {
            query.setEndTime(LocalDateTime.of((int)fiscalYear, 12, 31, 23, 59, 59));
        }
        List<SaleTargetVO> saleTargetVOList = this.saleTargetDAO.countUserSaleTarget(goalId, "true", userId, null);
        SaleGoalVO saleGoalVO = this.saleGoalDAO.queryByKey(goalId);
        String goalType = saleGoalVO.getGoalType();
        String examTarget = saleGoalVO.getExamTarget();
        Set userIds = saleTargetVOList.stream().map(SaleTargetVO::getDutyId).collect(Collectors.toSet());
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        examInformationQuery.setGoalId(goalId);
        List examInformationVOList = this.examInformationService.queryListDynamic(examInformationQuery);
        query.setExamInformationVOList(examInformationVOList);
        query.setUserIds(userIds);
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_VISIT.getCode())) {
                List<SaleTargetCountResultVO> visitList = this.saleTargetDAO.countUserVisitActual(query);
                saleTargetVOList.forEach(saleTargetVOS -> {
                    SaleTargetCountResultVO countResultVO = new SaleTargetCountResultVO();
                    countResultVO.setUserId(saleTargetVOS.getDutyId());
                    countResultVO.setProportion(BigDecimal.ZERO);
                    if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                        saleTargetVOS.setTargetCount(new BigDecimal(1));
                    }
                    visitList.forEach(saleTargetVO -> {
                        if (saleTargetVOS.getDutyId().equals(saleTargetVO.getUserId())) {
                            countResultVO.setProportion(saleTargetVO.getActualCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                        }
                    });
                    resultList.add(countResultVO);
                });
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CLUE.getCode())) {
                List<SaleTargetCountResultVO> clueList = this.saleTargetDAO.countClueByExamInformation(query);
                saleTargetVOList.forEach(saleTargetVOS -> {
                    SaleTargetCountResultVO countResultVO = new SaleTargetCountResultVO();
                    countResultVO.setUserId(saleTargetVOS.getDutyId());
                    countResultVO.setProportion(BigDecimal.ZERO);
                    if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                        saleTargetVOS.setTargetCount(new BigDecimal(1));
                    }
                    clueList.forEach(saleTargetVO -> {
                        if (saleTargetVOS.getDutyId().equals(saleTargetVO.getUserId())) {
                            countResultVO.setProportion(saleTargetVO.getActualCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                        }
                    });
                    resultList.add(countResultVO);
                });
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_BUSINESS.getCode())) {
                List<SaleTargetCountResultVO> oppoList = this.saleTargetDAO.countOppoByExamInformation(query);
                saleTargetVOList.forEach(saleTargetVOS -> {
                    SaleTargetCountResultVO countResultVO = new SaleTargetCountResultVO();
                    countResultVO.setUserId(saleTargetVOS.getDutyId());
                    countResultVO.setProportion(BigDecimal.ZERO);
                    if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                        saleTargetVOS.setTargetCount(new BigDecimal(1));
                    }
                    oppoList.forEach(saleTargetVO -> {
                        if (saleTargetVOS.getDutyId().equals(saleTargetVO.getUserId())) {
                            countResultVO.setProportion(saleTargetVO.getActualCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                        }
                    });
                    resultList.add(countResultVO);
                });
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CONTRACT.getCode())) {
                // empty if block
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CUSTOMER.getCode())) {
                List<SaleTargetCountResultVO> customerList = this.saleTargetDAO.countCustomerByExam(query);
                saleTargetVOList.forEach(saleTargetVOS -> {
                    SaleTargetCountResultVO countResultVO = new SaleTargetCountResultVO();
                    countResultVO.setUserId(saleTargetVOS.getDutyId());
                    countResultVO.setProportion(BigDecimal.ZERO);
                    if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                        saleTargetVOS.setTargetCount(new BigDecimal(1));
                    }
                    customerList.forEach(saleTargetVO -> {
                        if (saleTargetVOS.getDutyId().equals(saleTargetVO.getUserId())) {
                            countResultVO.setProportion(saleTargetVO.getActualCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                        }
                    });
                    resultList.add(countResultVO);
                });
            }
        } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
            // empty if block
        }
        return resultList;
    }

    public List<SaleTargetCountResultVO> countCustomerOrder(SaleTargetStatisticalQuery query) {
        ArrayList<SaleTargetCountResultVO> resultList = new ArrayList<SaleTargetCountResultVO>();
        Long goalId = query.getGoalId();
        if (goalId == null) {
            throw TwException.error("", "goalId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleGoalDO entity = this.saleGoalRepo.findById(goalId).orElseGet(SaleGoalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728");
        Integer fiscalYear = entity.getFiscalYear();
        if (query.getStartTime() == null) {
            query.setStartTime(LocalDateTime.of((int)fiscalYear, 1, 1, 0, 0, 0));
        }
        if (query.getEndTime() == null) {
            query.setEndTime(LocalDateTime.of((int)fiscalYear, 12, 31, 23, 59, 59));
        }
        List<SaleTargetVO> saleTargetVOList = this.saleTargetDAO.countCustomerSaleTarget(goalId, "true");
        SaleGoalVO saleGoalVO = this.saleGoalDAO.queryByKey(goalId);
        String goalType = saleGoalVO.getGoalType();
        String examTarget = saleGoalVO.getExamTarget();
        Set customerIds = saleTargetVOList.stream().map(SaleTargetVO::getCustomerId).collect(Collectors.toSet());
        Set userIds = saleTargetVOList.stream().map(SaleTargetVO::getDutyId).collect(Collectors.toSet());
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        examInformationQuery.setGoalId(goalId);
        List examInformationVOList = this.examInformationService.queryListDynamic(examInformationQuery);
        query.setExamInformationVOList(examInformationVOList);
        query.setCustomerIds(customerIds);
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode()) && examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_VISIT.getCode())) {
            List<SaleTargetCountResultVO> visitList = this.saleTargetDAO.countCustomerVisitActual(query);
            saleTargetVOList.forEach(saleTargetVOS -> {
                SaleTargetCountResultVO countResultVO = new SaleTargetCountResultVO();
                countResultVO.setCustomerId(saleTargetVOS.getCustomerId());
                countResultVO.setCustomerName(saleTargetVOS.getCustomerName());
                countResultVO.setProportion(BigDecimal.ZERO);
                if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                    saleTargetVOS.setTargetCount(new BigDecimal(1));
                }
                visitList.forEach(saleTargetVO -> {
                    if (saleTargetVOS.getCustomerId().equals(saleTargetVO.getCustomerId())) {
                        countResultVO.setProportion(saleTargetVO.getActualCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                    }
                });
                resultList.add(countResultVO);
            });
        }
        return resultList;
    }

    public List<SaleTargetCountResultVO> countProductOrder(SaleTargetStatisticalQuery query) {
        ArrayList<SaleTargetCountResultVO> resultList = new ArrayList<SaleTargetCountResultVO>();
        Long goalId = query.getGoalId();
        if (goalId == null) {
            throw TwException.error("", "goalId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleGoalDO entity = this.saleGoalRepo.findById(goalId).orElseGet(SaleGoalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728");
        Integer fiscalYear = entity.getFiscalYear();
        if (query.getStartTime() == null) {
            query.setStartTime(LocalDateTime.of((int)fiscalYear, 1, 1, 0, 0, 0));
        }
        if (query.getEndTime() == null) {
            query.setEndTime(LocalDateTime.of((int)fiscalYear, 12, 31, 23, 59, 59));
        }
        List<SaleTargetVO> saleTargetVOList = this.saleTargetDAO.countProductSaleTarget(goalId, "true");
        SaleGoalVO saleGoalVO = this.saleGoalDAO.queryByKey(goalId);
        String goalType = saleGoalVO.getGoalType();
        String examTarget = saleGoalVO.getExamTarget();
        Set skuIds = saleTargetVOList.stream().map(SaleTargetVO::getSkuId).collect(Collectors.toSet());
        Set userIds = saleTargetVOList.stream().map(SaleTargetVO::getDutyId).collect(Collectors.toSet());
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        examInformationQuery.setGoalId(goalId);
        List examInformationVOList = this.examInformationService.queryListDynamic(examInformationQuery);
        query.setExamInformationVOList(examInformationVOList);
        query.setSkuIds(skuIds);
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.PRODUCT.getCode())) {
            saleTargetVOList.forEach(saleTargetVOS -> {
                SaleTargetCountResultVO countResultVO = new SaleTargetCountResultVO();
                countResultVO.setSkuId(saleTargetVOS.getSkuId());
                countResultVO.setSkuName(saleTargetVOS.getSkuName());
                saleTargetVOS.setTargetCount(saleTargetVOS.getTargetCount());
                countResultVO.setProportion(BigDecimal.ZERO);
                resultList.add(countResultVO);
            });
        }
        return resultList;
    }

    public List<SaleTargetCountVO> queryUserOrgCount(SaleTargetUserOrgQuery query) {
        ArrayList<SaleTargetCountVO> resultList = new ArrayList<SaleTargetCountVO>();
        Long goalId = query.getGoalId();
        Long orgId = query.getOrgId();
        Long userId = query.getUserId();
        if (null == goalId) {
            throw TwException.error("", "goalId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleGoalDO entity = this.saleGoalRepo.findById(goalId).orElseGet(SaleGoalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728");
        Integer fiscalYear = entity.getFiscalYear();
        if (query.getStartTime() == null) {
            query.setStartTime(LocalDateTime.of((int)fiscalYear, 1, 1, 0, 0, 0));
        }
        if (query.getEndTime() == null) {
            query.setEndTime(LocalDateTime.of((int)fiscalYear, 12, 31, 23, 59, 59));
        }
        SaleGoalVO saleGoalVO = this.saleGoalDAO.queryByKey(goalId);
        String goalType = saleGoalVO.getGoalType();
        String examTarget = saleGoalVO.getExamTarget();
        List<SaleTargetVO> saleTargetVOLists = this.saleTargetDAO.countUserIds(goalId, "true", orgId, userId);
        if (saleTargetVOLists.size() == 0) {
            SaleTargetCountVO countResultVO = new SaleTargetCountVO();
            return null;
        }
        Set<Long> userIds = saleTargetVOLists.stream().map(SaleTargetVO::getDutyId).collect(Collectors.toSet());
        List<SaleTargetVO> saleTargetVOList = this.saleTargetDAO.countUserOrgSaleTarget(goalId, "true", orgId, userId);
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        examInformationQuery.setGoalId(goalId);
        List examInformationVOS = this.examInformationService.queryListDynamic(examInformationQuery);
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
            SaleTargetCountVO countResultVO;
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_VISIT.getCode())) {
                List<SaleTargetCountVO> visitList = this.saleTargetDAO.countOrgVisitByExamInformation(goalId, examInformationVOS, orgId, userId, userIds);
                countResultVO = new SaleTargetCountVO();
                saleTargetVOList.forEach(saleTargetVOS -> {
                    countResultVO.setTargetCount(saleTargetVOS.getTargetCount());
                    countResultVO.setProportion(BigDecimal.ZERO);
                    if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                        saleTargetVOS.setTargetCount(new BigDecimal(1));
                    }
                    visitList.forEach(saleTargetVO -> {
                        countResultVO.setSumCountLong(saleTargetVO.getSumCountLong());
                        countResultVO.setSumCount(saleTargetVO.getSumCount());
                        countResultVO.setProportion(saleTargetVO.getSumCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                    });
                });
                resultList.add(countResultVO);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CLUE.getCode())) {
                List<SaleTargetCountVO> clueList = this.saleTargetDAO.countOrgClueByExamInformation(goalId, examInformationVOS, orgId, userId, userIds);
                countResultVO = new SaleTargetCountVO();
                saleTargetVOList.forEach(saleTargetVOS -> {
                    countResultVO.setTargetCount(saleTargetVOS.getTargetCount());
                    countResultVO.setProportion(BigDecimal.ZERO);
                    if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                        saleTargetVOS.setTargetCount(new BigDecimal(1));
                    }
                    clueList.forEach(saleTargetVO -> {
                        countResultVO.setSumCountLong(saleTargetVO.getSumCountLong());
                        countResultVO.setSumCount(saleTargetVO.getSumCount());
                        countResultVO.setProportion(saleTargetVO.getSumCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                    });
                });
                resultList.add(countResultVO);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_BUSINESS.getCode())) {
                List<SaleTargetCountVO> oppoList = this.saleTargetDAO.countOrgOppoByExamInformation(goalId, examInformationVOS, orgId, userId, userIds);
                countResultVO = new SaleTargetCountVO();
                saleTargetVOList.forEach(saleTargetVOS -> {
                    countResultVO.setTargetCount(saleTargetVOS.getTargetCount());
                    countResultVO.setProportion(BigDecimal.ZERO);
                    if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                        saleTargetVOS.setTargetCount(new BigDecimal(1));
                    }
                    oppoList.forEach(saleTargetVO -> {
                        countResultVO.setSumCountLong(saleTargetVO.getSumCountLong());
                        countResultVO.setSumCount(saleTargetVO.getSumCount());
                        countResultVO.setProportion(saleTargetVO.getSumCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                    });
                });
                resultList.add(countResultVO);
            }
            if (examTarget.equals(SaleTargetExamTargetEnum.USER_CUSTOMER.getCode())) {
                List<SaleTargetCountVO> customerList = this.saleTargetDAO.countOrgCustomerByExamInformation(goalId, examInformationVOS, orgId, userId, userIds);
                countResultVO = new SaleTargetCountVO();
                saleTargetVOList.forEach(saleTargetVOS -> {
                    countResultVO.setTargetCount(saleTargetVOS.getTargetCount());
                    countResultVO.setProportion(BigDecimal.ZERO);
                    if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                        saleTargetVOS.setTargetCount(new BigDecimal(1));
                    }
                    customerList.forEach(saleTargetVO -> {
                        countResultVO.setSumCountLong(saleTargetVO.getSumCountLong());
                        countResultVO.setSumCount(saleTargetVO.getSumCount());
                        countResultVO.setProportion(saleTargetVO.getSumCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                    });
                });
                resultList.add(countResultVO);
            }
        }
        return resultList;
    }

    public List<SaleTargetCountVO> queryCustomerCount(SaleTargetCustomerQuery query) {
        ArrayList<SaleTargetCountVO> resultList = new ArrayList<SaleTargetCountVO>();
        Long goalId = query.getGoalId();
        if (null == goalId) {
            throw TwException.error("", "goalId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleGoalDO entity = this.saleGoalRepo.findById(goalId).orElseGet(SaleGoalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728");
        Integer fiscalYear = entity.getFiscalYear();
        if (query.getStartTime() == null) {
            query.setStartTime(LocalDateTime.of((int)fiscalYear, 1, 1, 0, 0, 0));
        }
        if (query.getEndTime() == null) {
            query.setEndTime(LocalDateTime.of((int)fiscalYear, 12, 31, 23, 59, 59));
        }
        SaleGoalVO saleGoalVO = this.saleGoalDAO.queryByKey(goalId);
        String goalType = saleGoalVO.getGoalType();
        String examTarget = saleGoalVO.getExamTarget();
        query.setExt1("true");
        List<SaleTargetVO> saleTargetVOList = this.saleTargetDAO.countCustomerSaleTarget(query);
        List<SaleTargetVO> saleTargetVOLists = this.saleTargetDAO.countCustomerIdAndUserId(query);
        if (saleTargetVOLists.size() == 0) {
            SaleTargetCountVO countResultVO = new SaleTargetCountVO();
            return null;
        }
        Set userIds = saleTargetVOLists.stream().map(SaleTargetVO::getDutyId).collect(Collectors.toSet());
        Set customerIds = saleTargetVOLists.stream().map(SaleTargetVO::getCustomerId).collect(Collectors.toSet());
        query.setCustomerIds(customerIds);
        query.setUserIds(userIds);
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        examInformationQuery.setGoalId(goalId);
        List examInformationVOS = this.examInformationService.queryListDynamic(examInformationQuery);
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode())) {
            if (examTarget.equals(SaleTargetExamTargetEnum.CUSTOMER_VISIT.getCode())) {
                List<SaleTargetCountVO> visitList = this.saleTargetDAO.countCustomerByExamInformation(examInformationVOS, query);
                SaleTargetCountVO countResultVO = new SaleTargetCountVO();
                saleTargetVOList.forEach(saleTargetVOS -> {
                    countResultVO.setTargetCount(saleTargetVOS.getTargetCount());
                    countResultVO.setProportion(BigDecimal.ZERO);
                    if (saleTargetVOS.getTargetCount().compareTo(BigDecimal.ZERO) == 0) {
                        saleTargetVOS.setTargetCount(new BigDecimal(1));
                    }
                    visitList.forEach(saleTargetVO -> {
                        countResultVO.setSumCountLong(saleTargetVO.getSumCountLong());
                        countResultVO.setSumCount(saleTargetVO.getSumCount());
                        countResultVO.setProportion(saleTargetVO.getSumCount().divide(saleTargetVOS.getTargetCount(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(1, RoundingMode.HALF_UP));
                    });
                });
                resultList.add(countResultVO);
            }
        } else if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode())) {
            // empty if block
        }
        return resultList;
    }

    private void getExamInformationList(SaleTargetVO saleTargetVO) {
        ExamInformationQuery examInformationQuery = new ExamInformationQuery();
        Long goalId = saleTargetVO.getGoalId();
        examInformationQuery.setGoalId(goalId);
        List examInformationVOS = this.examInformationService.queryListDynamic(examInformationQuery);
        String goalType = saleTargetVO.getGoalType();
        if (goalType.equals(SaleTargetSaleGoalTypeEnum.USER.getCode()) ? saleTargetVO.getExt2().equals(SaleTargetExamTargetEnum.USER_VISIT.getCode()) : !goalType.equals(SaleTargetSaleGoalTypeEnum.CUSTOMER.getCode()) || saleTargetVO.getExt2().equals(SaleTargetExamTargetEnum.CUSTOMER_VISIT.getCode())) {
            // empty if block
        }
    }

    public SaleTargetServiceImpl(SaleTargetRepo saleTargetRepo, SaleTargetDAO saleTargetDAO, ExamInformationService examInformationService, SaleGoalDAO saleGoalDAO, SaleGoalRepo saleGoalRepo) {
        this.saleTargetRepo = saleTargetRepo;
        this.saleTargetDAO = saleTargetDAO;
        this.examInformationService = examInformationService;
        this.saleGoalDAO = saleGoalDAO;
        this.saleGoalRepo = saleGoalRepo;
    }
}

