/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.visit.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.ab.query.PrdAbContactsQuery;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbContactsService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbContactsVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdMessageConfigConvert;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitPlanPayload;
import com.elitesland.tw.tw5crm.api.visit.query.VisitPlanQuery;
import com.elitesland.tw.tw5crm.api.visit.service.VisitPlanService;
import com.elitesland.tw.tw5crm.api.visit.service.VisitTaskService;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitPlanVO;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanObjTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanPersonTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanStatusEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanTypeEnum;
import com.elitesland.tw.tw5crm.server.visit.convert.VisitPlanConvert;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitPlanDAO;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitPlanDetailDAO;
import com.elitesland.tw.tw5crm.server.visit.entity.VisitPlanDO;
import com.elitesland.tw.tw5crm.server.visit.entity.VisitPlanDetailDO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class VisitPlanServiceImpl
extends BaseServiceImpl
implements VisitPlanService {
    private static final Logger log = LoggerFactory.getLogger(VisitPlanServiceImpl.class);
    private final VisitPlanDAO visitPlanDAO;
    private final VisitPlanDetailDAO visitPlanDetailDAO;
    private final VisitTaskService visitTaskService;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final CrmCustomerService customerService;
    private final PrdAbContactsService prdAbContactsService;
    private final CrmLeadsService leadsService;
    private final CrmOpportunityService opportunityService;
    private final PrdMessageConfigService messageConfigService;
    private final PrdMessageConfigRepo repoMessage;

    public PagingVO<VisitPlanVO> queryPaging(VisitPlanQuery query) {
        this.dataPermissionFlag(query);
        if (query.getVisitPerson() != null) {
            query.setVisitPersonNameStr(query.getVisitPerson() + ",");
        }
        if (query.getAccompanyPerson() != null) {
            query.setAccompanyPersonNameStr(query.getAccompanyPerson() + ",");
        }
        PagingVO<VisitPlanVO> visitPlanVOPagingVO = this.visitPlanDAO.queryPaging(query);
        List records = visitPlanVOPagingVO.getRecords();
        records.forEach(this::tranVisitPlanVo);
        return visitPlanVOPagingVO;
    }

    private void dataPermissionFlag(VisitPlanQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long userId = GlobalUtil.getLoginUserId();
            if (userId == null) {
                throw TwException.error("1", "\u83b7\u53d6\u5f53\u524d\u767b\u9646\u7528\u6237\u5931\u8d25");
            }
            query.setLoginUserId(userId);
            Set subordinatesIdsByUserId = this.prdOrgEmployeeService.queryOneSubordinatesIdsByUserId(userId);
            query.setSubordinatesIds(subordinatesIdsByUserId);
        }
    }

    public VisitPlanVO queryByKey(Long key) {
        VisitPlanVO vo = this.visitPlanDAO.findByKey(key);
        this.tranVisitPlanVo(vo);
        return vo;
    }

    private void tranVisitPlanVo(VisitPlanVO vo) {
        if (StringUtils.hasText((String)vo.getVisitPlanType())) {
            vo.setVisitPlanTypeDesc(this.cacheUtil.transferSystemSelection("crm:visit:task_plan:type", vo.getVisitPlanType()));
            if (VisitTaskPlanTypeEnum.general_plan.getCode().equals(vo.getVisitPlanType())) {
                vo.setVisitDate(vo.getVisitDateFrom() == null ? "" : vo.getVisitDateFrom().toString());
            } else {
                String dateFrom = vo.getVisitDateFrom() == null ? "" : vo.getVisitDateFrom().toString();
                String dateTo = vo.getVisitDateTo() == null ? "" : vo.getVisitDateTo().toString();
                vo.setVisitDate(dateFrom + "~" + dateTo);
            }
        }
        if (StringUtils.hasText((String)vo.getVisitPlanStatus())) {
            vo.setVisitPlanStatus(this.cacheUtil.transferSystemSelection("crm:visit:task_plan:status", vo.getVisitPlanStatus()));
        }
        if (StringUtils.hasText((String)vo.getExtString1())) {
            String visitPersonStr = vo.getExtString1().substring(0, vo.getExtString1().length() - 1);
            String visitPersonNameStr = this.getPersonNameStr(visitPersonStr);
            List<Long> visitPersonList = Stream.of(visitPersonStr.split(",")).map(Long::valueOf).toList();
            vo.setVisitPersonNameStr(visitPersonNameStr);
            vo.setVisitPersonList(visitPersonList);
        }
        if (StringUtils.hasText((String)vo.getExtString2())) {
            String accompanyPersonStr = vo.getExtString2().substring(0, vo.getExtString2().length() - 1);
            String accompanyPersonNameStr = this.getPersonNameStr(accompanyPersonStr);
            List<Long> accompanyPersonList = Stream.of(accompanyPersonStr.split(",")).map(Long::valueOf).toList();
            vo.setAccompanyPersonNameStr(accompanyPersonNameStr);
            vo.setAccompanyPersonList(accompanyPersonList);
        }
        if (StringUtils.hasText((String)vo.getObjType())) {
            vo.setObjTypeDesc(this.cacheUtil.transferSystemSelection("crm:visit:obj_type", vo.getObjType()));
        }
        if (null == vo.getCustomId()) {
            log.warn("\u9500\u552e\u62dc\u8bbf\u8ba1\u5212\u672a\u5173\u8054\u5ba2\u6237\uff1b\u9500\u552e\u62dc\u8bbf\u8ba1\u5212\uff1a{}", (Object)vo);
            return;
        }
        CrmCustomerSimpleVO simpleVO = this.customerService.querySimpleByKey(vo.getCustomId());
        if (null != simpleVO) {
            Long bookId = simpleVO.getBookId();
            vo.setBookId(bookId);
            vo.setCompanyAddress(simpleVO.getCompanyAddress());
            vo.setLongitudeLatitude(simpleVO.getLongitudeLatitude());
            if (null == bookId) {
                log.warn("\u5ba2\u6237\u6570\u636e\u5f02\u5e38\uff1b\u627e\u4e0d\u5230bookId;  customId:{}", (Object)vo.getCustomId());
                return;
            }
            PrdAbContactsQuery prdAbContactsQuery = new PrdAbContactsQuery();
            prdAbContactsQuery.setBookId(bookId);
            PagingVO paging = this.prdAbContactsService.paging(prdAbContactsQuery);
            if (paging.isNotEmpty()) {
                PrdAbContactsVO prdAbContactsVO = (PrdAbContactsVO)paging.getRecords().get(0);
                vo.setContactsName(prdAbContactsVO.getContactsName());
                vo.setContactsPhone(prdAbContactsVO.getContactsPhone());
            }
        }
    }

    private String getPersonNameStr(String visitPersonStr) {
        return Stream.of(visitPersonStr.split(",")).map(e -> {
            Long visitPersonId = Long.valueOf(e);
            String userName = this.cacheUtil.getUserName(visitPersonId);
            return userName == null ? "" : userName;
        }).collect(Collectors.joining(","));
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public VisitPlanVO insert(VisitPlanPayload payload) {
        this.saveVisitPersonStr(payload);
        VisitPlanDO entityDo = VisitPlanConvert.INSTANCE.toDo(payload);
        entityDo.setVisitPlanStatus(VisitTaskPlanStatusEnum.incomplete.getCode());
        VisitPlanDO save = this.visitPlanDAO.save(entityDo);
        this.saveVisitPlanDetail(payload.getVisitPersonList(), save.getId(), VisitTaskPlanPersonTypeEnum.visit_person.getCode());
        this.saveVisitPlanDetail(payload.getAccompanyPersonList(), save.getId(), VisitTaskPlanPersonTypeEnum.accompany_person.getCode());
        this.visitTaskService.generateTaskByPlanId(save.getId());
        this.notice(payload, save);
        return VisitPlanConvert.INSTANCE.toVo(save);
    }

    private void notice(VisitPlanPayload payload, VisitPlanDO save) {
        String loginUserName = GlobalUtil.getLoginUserName();
        Long loginUserId = GlobalUtil.getLoginUserId();
        ArrayList<Long> noticePersonList = new ArrayList<Long>();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.prdOrgEmployeeService.queryEmployeeRef(loginUserId);
        if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getParentId() != null) {
            noticePersonList.add(prdOrgEmployeeRefVO.getParentId());
        }
        if (payload.getAccompanyPersonList() != null) {
            noticePersonList.addAll(payload.getAccompanyPersonList());
        }
        if (noticePersonList.size() > 0) {
            ArrayList messageConfigDOS = new ArrayList();
            noticePersonList.forEach(userId -> {
                String code = this.generateSeqNum("MESSAGE_CONFIG_NO", new String[0]);
                Long visitPlanId = save.getId();
                String content = loginUserName + " \u65b0\u589e\u4e86\u4e00\u6761\u62dc\u8bbf\u8ba1\u5212 <a href=\"/customerVisit/visitPlanDetail?id=" + visitPlanId + "\">" + save.getVisitPlanName() + "</a> \u3002";
                PrdMessageConfigDO ado = new PrdMessageConfigDO();
                ado.setMessageCode(code);
                ado.setMessageTitle("\u65b0\u589e\u62dc\u8bbf\u8ba1\u5212");
                ado.setMessageContent(content);
                ado.setCreateUserId(loginUserId);
                ado.setContentBigType("businessMessage");
                ado.setContentType("systemMessage");
                ado.setCreateSource("\u65b0\u589e\u62dc\u8bbf\u8ba1\u5212");
                ado.setIsEnable(0);
                ado.setMessageType(2);
                ado.setNoticeScope("appoint_people");
                ado.setNoticeSource("" + userId);
                ado.setNoticeWay("instation");
                ado.setTenantId(save.getTenantId());
                ado.setReleaseSource("profileMessage");
                ado.setReleaseStatus(3);
                ado.setTriggerTime(LocalDateTime.now());
                messageConfigDOS.add(ado);
            });
            List messageConfigDOS1 = this.repoMessage.saveAll(messageConfigDOS);
            List messageConfigVOS = messageConfigDOS1.stream().map(PrdMessageConfigConvert.INSTANCE::toVo).collect(Collectors.toList());
            this.messageConfigService.releaseMessage(messageConfigVOS);
        }
    }

    private void saveVisitPersonStr(VisitPlanPayload payload) {
        List visitPersonList = payload.getVisitPersonList();
        if (visitPersonList == null || visitPersonList.size() < 1) {
            throw new RuntimeException("\u65b0\u5efa\u8ba1\u5212 \u62dc\u8bbf\u6210\u5458\u5fc5\u586b");
        }
        String visitPersonStr = visitPersonList.stream().sorted().map(Object::toString).collect(Collectors.joining(",", "", ","));
        payload.setExtString1(visitPersonStr);
        List accompanyPersonList = payload.getAccompanyPersonList();
        if (accompanyPersonList != null && accompanyPersonList.size() > 0) {
            String accompanyPersonStr = accompanyPersonList.stream().sorted().map(Object::toString).collect(Collectors.joining(",", "", ","));
            payload.setExtString2(accompanyPersonStr);
        }
        String visitPersonParentStr = visitPersonList.stream().map(visitPersonId -> {
            PrdOrgDataRefVO defaultOrgInfoByUserId = this.cacheUtil.getDefaultOrgInfoByUserId((Long)visitPersonId);
            if (defaultOrgInfoByUserId == null) {
                return -1L;
            }
            return defaultOrgInfoByUserId.getParentId() == null ? -1L : defaultOrgInfoByUserId.getParentId();
        }).map(Object::toString).distinct().collect(Collectors.joining(",", "", ","));
        payload.setExtString3(visitPersonParentStr);
    }

    private void saveVisitPlanDetail(List<Long> visitPersonList, Long visitPlanId, String visitTaskPlanPersonType) {
        if (visitPersonList != null && visitPersonList.size() > 0) {
            for (Long visitPersonId : visitPersonList) {
                VisitPlanDetailDO ado = new VisitPlanDetailDO();
                ado.setVisitPlanId(visitPlanId);
                ado.setVisitPersonId(visitPersonId);
                ado.setVisitPersonType(visitTaskPlanPersonType);
                this.visitPlanDetailDAO.save(ado);
            }
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public long update(VisitPlanPayload payload) {
        VisitPlanVO vo;
        Long userId;
        if (payload.getId() == null || payload.getId() < 0L) {
            throw TwException.error("1", "\u62dc\u8bbf\u8ba1\u5212id\u6709\u8bef");
        }
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission.booleanValue() && !(userId = GlobalUtil.getLoginUserId()).equals((vo = this.visitPlanDAO.findByKey(payload.getId())).getCreateUserId())) {
            throw TwException.error("1", "\u53ea\u6709\u521b\u5efa\u4eba\u53ef\u4ee5\u4fee\u6539\u8ba1\u5212\uff0c\u5f53\u524d\u767b\u9646\u7528\u6237\u4e0d\u662f\u521b\u5efa\u4eba");
        }
        long count = this.visitTaskService.countByPlanId(payload.getId());
        if (count > 0L) {
            throw TwException.error("1", "\u8be5\u8ba1\u5212\u4e0b\u7684\u4efb\u52a1\u5df2\u7ecf\u5f00\u59cb\u6267\u884c\uff0c\u4e0d\u80fd\u4fee\u6539\u8ba1\u5212");
        }
        this.saveVisitPersonStr(payload);
        long l = this.visitPlanDAO.updateByKeyDynamic(payload);
        this.visitPlanDetailDAO.deleteByVisitPlanId(payload.getId());
        this.saveVisitPlanDetail(payload.getVisitPersonList(), payload.getId(), VisitTaskPlanPersonTypeEnum.visit_person.getCode());
        this.saveVisitPlanDetail(payload.getAccompanyPersonList(), payload.getId(), VisitTaskPlanPersonTypeEnum.accompany_person.getCode());
        this.visitTaskService.generateTaskByPlanId(payload.getId());
        return l;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public long completeVisitPlan(Long visitPlanId) {
        if (visitPlanId == null) {
            throw TwException.error("1", "\u62dc\u8bbf\u8ba1\u5212id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.visitPlanDAO.completeVisitPlan(visitPlanId);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                VisitPlanVO visitPlanVO = this.visitPlanDAO.queryByKey((Long)id);
                if (!visitPlanVO.getCreateUserId().equals(GlobalUtil.getLoginUserId())) {
                    throw TwException.error("1", "\u53ea\u6709\u521b\u5efa\u4eba\u53ef\u4ee5\u5220\u9664\u8ba1\u5212\uff0c\u5f53\u524d\u767b\u9646\u7528\u6237\u4e0d\u662f\u521b\u5efa\u4eba");
                }
                long count = this.visitTaskService.countByPlanId(id);
                if (count > 0L) {
                    throw TwException.error("1", "\u8be5\u8ba1\u5212\u3010" + visitPlanVO.getVisitPlanName() + "\u3011\u4e0b\u7684\u4efb\u52a1\u5df2\u5f00\u59cb/\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u5220\u9664");
                }
            });
        }
        if (!keys.isEmpty()) {
            this.visitPlanDAO.deleteSoft(keys);
        }
    }

    @Transactional
    public int verifyVisitPlanName(String visitPlanName) {
        if (StringUtils.hasText((String)visitPlanName)) {
            return this.visitPlanDAO.verifyVisitPlanName(visitPlanName);
        }
        return 0;
    }

    public Map<String, Integer> visitPlanCount() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        VisitPlanQuery query = new VisitPlanQuery();
        this.dataPermissionFlag(query);
        List<VisitPlanVO> visitPlans = this.visitPlanDAO.queryListDynamic(query);
        result.put("visitPlan_count", visitPlans.size());
        long count = visitPlans.stream().filter(e -> e.getVisitPlanStatus().equals(VisitTaskPlanStatusEnum.incomplete.getCode())).count();
        result.put("incomplete_VisitPlan_count", (int)count);
        Map<String, Long> collect = visitPlans.stream().collect(Collectors.groupingBy(VisitPlanVO::getVisitPlanType, Collectors.counting()));
        collect.forEach((k, v) -> result.put(k + "_count", v.intValue()));
        return result;
    }

    public String getVisitCustomAddress(Long customId) {
        return this.customerService.queryCompanyAddress(customId);
    }

    public List<Map<String, Object>> visitCustomRelationInfo(Long customId, String objType) {
        if (VisitTaskPlanObjTypeEnum.LEAD.getCode().equals(objType)) {
            CrmCustomerVO crmCustomerVO = this.customerService.queryDetail(customId);
            String customerName = crmCustomerVO.getCustomerName();
            List crmLeadsListVOS = this.leadsService.queryListByCustomName(customerName);
            List<Map<String, Object>> list = crmLeadsListVOS.stream().map(e -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("id", e.getId());
                result.put("name", e.getLeadsName());
                return result;
            }).toList();
            return list;
        }
        if (VisitTaskPlanObjTypeEnum.OPPO.getCode().equals(objType)) {
            List crmActProjectVOS = this.opportunityService.queryListByCustomId(customId);
            List<Map<String, Object>> list = crmActProjectVOS.stream().map(e -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("id", e.getId());
                result.put("name", e.getProjectName());
                return result;
            }).toList();
            return list;
        }
        List<CrmOperationPlanDetailVO> operationPlanByCustomId = this.visitPlanDAO.getOperationPlanByCustomId(customId);
        List<Map<String, Object>> list = operationPlanByCustomId.stream().map(e -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("id", e.getId());
            result.put("name", e.getPlanName());
            return result;
        }).toList();
        return list;
    }

    public VisitPlanServiceImpl(VisitPlanDAO visitPlanDAO, VisitPlanDetailDAO visitPlanDetailDAO, VisitTaskService visitTaskService, CacheUtil cacheUtil, PrdOrgEmployeeService prdOrgEmployeeService, CrmCustomerService customerService, PrdAbContactsService prdAbContactsService, CrmLeadsService leadsService, CrmOpportunityService opportunityService, PrdMessageConfigService messageConfigService, PrdMessageConfigRepo repoMessage) {
        this.visitPlanDAO = visitPlanDAO;
        this.visitPlanDetailDAO = visitPlanDetailDAO;
        this.visitTaskService = visitTaskService;
        this.cacheUtil = cacheUtil;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.customerService = customerService;
        this.prdAbContactsService = prdAbContactsService;
        this.leadsService = leadsService;
        this.opportunityService = opportunityService;
        this.messageConfigService = messageConfigService;
        this.repoMessage = repoMessage;
    }
}

