/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.visit.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.coord.messenger.sender.provider.SmsRpcService;
import com.elitescloud.coord.messenger.sender.provider.param.TemplateSmsDTO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerDAO;
import com.elitesland.tw.tw5crm.api.open.payload.VisitTaskOpenPayload;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5crm.api.visit.query.VisitPlanDetailQuery;
import com.elitesland.tw.tw5crm.api.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5crm.api.visit.service.VisitTaskService;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitPlanDetailVO;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitPlanVO;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitTaskVO;
import com.elitesland.tw.tw5crm.server.common.constants.VisitSignTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskEvalStatusEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanPersonTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5crm.server.visit.convert.VisitTaskConvert;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitPlanDAO;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitPlanDetailDAO;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitSignRecordDAO;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitTaskDAO;
import com.elitesland.tw.tw5crm.server.visit.entity.VisitSignRecordDO;
import com.elitesland.tw.tw5crm.server.visit.entity.VisitTaskDO;
import com.elitesland.tw.tw5crm.server.visit.repo.VisitTaskRepo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class VisitTaskServiceImpl
extends BaseServiceImpl
implements VisitTaskService {
    private static final Logger log = LoggerFactory.getLogger(VisitTaskServiceImpl.class);
    private final VisitTaskRepo visitTaskRepo;
    private final VisitTaskDAO visitTaskDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final VisitPlanDAO visitPlanDAO;
    private final VisitPlanDetailDAO visitPlanDetailDAO;
    private final CrmCustomerDAO crmCustomerDAO;
    private final VisitSignRecordDAO visitSignRecordDAO;
    private final FileUtil fileUtil;
    private final SmsRpcService smsRpcService;

    public PagingVO<VisitTaskVO> paging(VisitTaskQuery query) {
        Page page = this.visitTaskRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(VisitTaskConvert.INSTANCE::toVo));
    }

    public PagingVO<VisitTaskVO> queryPaging(VisitTaskQuery query) {
        this.dataPermissionFlag(query);
        PagingVO<VisitTaskVO> pagingVO = this.visitTaskDAO.queryPaging(query);
        pagingVO.getRecords().forEach(visitTaskVO -> this.translation((VisitTaskVO)visitTaskVO, false));
        return pagingVO;
    }

    void dataPermissionFlag(VisitTaskQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long userId = GlobalUtil.getLoginUserId();
            query.setCreateUserIdPro(userId);
            Set subordinatesIdsByUserId = this.prdOrgEmployeeService.queryOneSubordinatesIdsByUserId(userId);
            query.setSubordinatesIds(subordinatesIdsByUserId);
        }
    }

    public List<VisitTaskVO> queryList(VisitTaskQuery query) {
        return VisitTaskConvert.INSTANCE.toVoList(this.visitTaskRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<VisitTaskVO> queryListDynamic(VisitTaskQuery query) {
        this.dataPermissionFlag(query);
        return this.visitTaskDAO.queryListDynamic(query);
    }

    public VisitTaskVO queryByKey(Long key) {
        VisitTaskDO entity = this.visitTaskRepo.findById(key).orElseGet(VisitTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        VisitTaskVO vo = VisitTaskConvert.INSTANCE.toVo(entity);
        this.translation(vo, true);
        return vo;
    }

    private void translation(VisitTaskVO vo, boolean translationFileFlag) {
        PrdOrgDataRefVO defaultOrgInfo;
        String teamMemberIds = vo.getTeamMemberIds();
        if (StringUtils.hasText((String)teamMemberIds)) {
            String[] teamMemberIdArr = teamMemberIds.split(",");
            ArrayList<String> teamMemberNameList = new ArrayList<String>();
            for (int i = 0; i < teamMemberIdArr.length; ++i) {
                String userName = this.cacheUtil.getUserName(Long.valueOf(teamMemberIdArr[i]));
                teamMemberNameList.add(userName);
            }
            String teamMemberNames = teamMemberNameList.stream().collect(Collectors.joining(","));
            vo.setTeamMemberNames(teamMemberNames);
        }
        vo.setVisitMemberParentIdPro((defaultOrgInfo = this.cacheUtil.getDefaultOrgInfoByUserId(vo.getVisitMemberId())) != null ? defaultOrgInfo.getParentId() : null);
        if (translationFileFlag) {
            vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
            vo.setSignFileDatas(this.fileUtil.getFileDatas(vo.getSignFileCodes()));
            vo.setSignOutFileDatas(this.fileUtil.getFileDatas(vo.getSignOutFileCodes()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public VisitTaskVO insert(VisitTaskPayload payload) {
        this.check(payload);
        this.dataProcess(payload);
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        VisitTaskDO save = (VisitTaskDO)this.visitTaskRepo.save(entityDo);
        this.signDataProcess(payload, save);
        return VisitTaskConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public VisitTaskVO update(VisitTaskPayload payload) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            throw TwException.error("", "id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VisitTaskDO entity = this.visitTaskRepo.findById(payload.getId()).orElseGet(VisitTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u62dc\u8bbf\u4efb\u52a1\u4e0d\u5b58\u5728");
        this.checkUpdate(payload, entity);
        if (ObjectUtils.isEmpty((Object)payload.getPlanId())) {
            payload.setPlanId(entity.getPlanId());
        }
        this.dataProcess(payload);
        if (!ObjectUtils.isEmpty((Object)payload.getStatus()) && payload.getStatus().equals(VisitTaskStatusEnum.OK.getCode())) {
            if (!loginUserId.equals(entity.getVisitMemberId()) && !rolePermission.booleanValue()) {
                throw TwException.error("", "\u6743\u9650\u4e0d\u8db3");
            }
            payload.setSubmitTime(LocalDateTime.now());
            payload.setEvalStatus(VisitTaskEvalStatusEnum.NEW.getCode());
            if ((payload.getPlanType().equals((Object)VisitTaskPlanTypeEnum.general_plan) || payload.getPlanType().equals((Object)VisitTaskPlanTypeEnum.periodic_plan)) && entity.getSendFlag() == null) {
                TemplateSmsDTO smsDTO = new TemplateSmsDTO();
                HashSet<String> mobile = new HashSet<String>();
                mobile.add("15103842119");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("customer", "Zach");
                smsDTO.setTemplateCode("SMS_114300083");
                smsDTO.setSignName("\u57c3\u6797\u54f2");
                smsDTO.setMobiles(mobile);
                smsDTO.setSubject("Elitesland");
                smsDTO.setBusinessType("CRM-TESTSEND");
                smsDTO.setTemplateParams(map);
                VisitTaskServiceImpl.isValidPhoneNumber("15103842119");
                this.smsRpcService.sendTemplateMsg(smsDTO);
            }
            this.visitTaskDAO.updateSendFlag();
        }
        if (StringUtils.hasText((String)payload.getCustomerDesc()) || StringUtils.hasText((String)payload.getResult()) || null != payload.getNextVisitTime() || StringUtils.hasText((String)payload.getSignLocations()) || StringUtils.hasText((String)payload.getSignOutLocations())) {
            if (!loginUserId.equals(entity.getVisitMemberId()) && !rolePermission.booleanValue()) {
                throw TwException.error("", "\u6743\u9650\u4e0d\u8db3");
            }
            payload.setStatus(VisitTaskStatusEnum.READY.getCode());
        }
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        VisitTaskDO save = (VisitTaskDO)this.visitTaskRepo.save(entity);
        Long planId = save.getPlanId();
        this.signDataProcess(payload, save);
        this.updatePlanStatus(planId);
        return VisitTaskConvert.INSTANCE.toVo(save);
    }

    public static boolean isValidPhoneNumber(String phoneNumber) {
        if (phoneNumber != null && !phoneNumber.isEmpty()) {
            return Pattern.matches("/^1(3[0-9]|4[01456879]|5[0-35-9]|6[2567]|7[0-8]|8[0-9]|9[0-35-9])\\d{8}$/", phoneNumber);
        }
        return false;
    }

    private void signDataProcess(VisitTaskPayload payload, VisitTaskDO save) {
        VisitSignRecordDO signRecordDO;
        LocalDateTime now = LocalDateTime.now();
        if (!ObjectUtils.isEmpty((Object)payload.getSignLocations())) {
            signRecordDO = new VisitSignRecordDO();
            signRecordDO.setTaskId(save.getId());
            signRecordDO.setPlanId(save.getPlanId());
            signRecordDO.setType(VisitSignTypeEnum.IN.getCode());
            signRecordDO.setTaskName(save.getTaskName());
            signRecordDO.setFileCodes(payload.getSignFileCodes());
            signRecordDO.setSignTime(now);
            signRecordDO.setLocations(payload.getSignLocations());
            signRecordDO.setAddress(payload.getSignAddress());
            this.visitSignRecordDAO.save(signRecordDO);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSignOutLocations())) {
            signRecordDO = new VisitSignRecordDO();
            signRecordDO.setTaskId(save.getId());
            signRecordDO.setPlanId(save.getPlanId());
            signRecordDO.setType(VisitSignTypeEnum.OUT.getCode());
            signRecordDO.setTaskName(save.getTaskName());
            signRecordDO.setFileCodes(payload.getSignOutFileCodes());
            signRecordDO.setSignTime(now);
            signRecordDO.setLocations(payload.getSignOutLocations());
            signRecordDO.setAddress(payload.getSignOutAddress());
            this.visitSignRecordDAO.save(signRecordDO);
        }
    }

    public List<VisitTaskVO> generateTaskByPlanId(Long planId) {
        ArrayList<VisitTaskDO> taskDOList = new ArrayList<VisitTaskDO>();
        if (null != planId) {
            VisitPlanVO visitPlanVO = this.visitPlanDAO.queryByKey(planId);
            Assert.notNull((Object)visitPlanVO, (String)"\u62dc\u8bbf\u8ba1\u5212\u4e0d\u5b58\u5728");
            String visitPlanType = visitPlanVO.getVisitPlanType();
            int visitTimesInt = 1;
            if (!VisitTaskPlanTypeEnum.general_plan.getCode().equals(visitPlanType)) {
                String visitTimes = visitPlanVO.getVisitTimes();
                if (ObjectUtils.isEmpty((Object)visitTimes)) {
                    throw TwException.error("", "\u62dc\u8bbf\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                visitTimesInt = Integer.valueOf(visitTimes);
            }
            Long customId = visitPlanVO.getCustomId();
            String customerName = "";
            if (!ObjectUtils.isEmpty((Object)customId)) {
                CrmCustomerVO crmCustomerVO = this.crmCustomerDAO.queryDetail(customId);
                Assert.notNull((Object)crmCustomerVO, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
                customerName = crmCustomerVO.getCustomerName();
            }
            this.deleteSoftByPlanId(planId);
            VisitPlanDetailQuery planDetailQuery = new VisitPlanDetailQuery();
            planDetailQuery.setVisitPlanId(planId);
            List<Object> planDetailVOList = this.visitPlanDetailDAO.queryListDynamic(planDetailQuery);
            if (!CollectionUtils.isEmpty(planDetailVOList)) {
                planDetailVOList = planDetailVOList.stream().filter(visitPlanDetailVO -> visitPlanDetailVO.getVisitPersonType().equals(VisitTaskPlanPersonTypeEnum.visit_person.getCode())).distinct().collect(Collectors.toList());
                int i = 1;
                for (VisitPlanDetailVO visitPlanDetailVO2 : planDetailVOList) {
                    for (int j = 0; j < visitTimesInt; ++j) {
                        VisitTaskDO taskDO = new VisitTaskDO();
                        String visitPlanName = visitPlanVO.getVisitPlanName();
                        taskDO.setPlanId(planId);
                        taskDO.setPlanName(visitPlanName);
                        taskDO.setPlanType(visitPlanType);
                        taskDO.setObjId(visitPlanVO.getObjId());
                        taskDO.setObjName(visitPlanVO.getObjName());
                        taskDO.setObjType(visitPlanVO.getObjType());
                        taskDO.setStartTime(visitPlanVO.getVisitDateFrom());
                        taskDO.setEndTime(visitPlanVO.getVisitDateTo());
                        taskDO.setPlanCreateUserId(visitPlanVO.getCreateUserId());
                        taskDO.setStatus(VisitTaskStatusEnum.NEW.getCode());
                        taskDO.setCustomerId(customId);
                        taskDO.setCustomerName(customerName);
                        taskDO.setTeamMemberIds(visitPlanVO.getExtString2());
                        Long visitPersonId = visitPlanDetailVO2.getVisitPersonId();
                        taskDO.setVisitMemberId(visitPersonId);
                        String userName = this.cacheUtil.getUserName(visitPersonId);
                        taskDO.setVisitMemberName(userName);
                        PrdOrgDataRefVO defaultOrgInfo = this.cacheUtil.getDefaultOrgInfoByUserId(visitPersonId);
                        taskDO.setVisitMemberParentId(defaultOrgInfo != null ? defaultOrgInfo.getParentId() : null);
                        taskDO.setTaskName(visitPlanName + "-" + userName + "-" + i);
                        ++i;
                        taskDOList.add(taskDO);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(taskDOList)) {
            this.visitTaskDAO.saveAll(taskDOList);
        }
        return VisitTaskConvert.INSTANCE.toVoList(taskDOList);
    }

    private void updatePlanStatus(Long planId) {
        VisitTaskQuery visitTaskQuery = new VisitTaskQuery();
        visitTaskQuery.setPlanId(planId);
        visitTaskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
        long count = this.visitTaskDAO.count(visitTaskQuery);
        VisitTaskQuery visitTaskQueryAll = new VisitTaskQuery();
        visitTaskQueryAll.setPlanId(planId);
        long countAll = this.visitTaskDAO.count(visitTaskQueryAll);
        if (count == countAll) {
            this.visitPlanDAO.completeVisitPlan(planId);
        }
    }

    private void dataProcess(VisitTaskPayload payload) {
        VisitPlanVO visitPlanVO = this.visitPlanDAO.queryByKey(payload.getPlanId());
        Assert.notNull((Object)visitPlanVO, (String)"\u62dc\u8bbf\u8ba1\u5212\u4e0d\u5b58\u5728");
        payload.setPlanName(visitPlanVO.getVisitPlanName());
        payload.setPlanType(visitPlanVO.getVisitPlanType());
        payload.setObjId(visitPlanVO.getObjId());
        payload.setObjName(visitPlanVO.getObjName());
        payload.setObjType(visitPlanVO.getObjType());
        payload.setStartTime(visitPlanVO.getVisitDateFrom());
        payload.setEndTime(visitPlanVO.getVisitDateTo());
        payload.setPlanCreateUserId(visitPlanVO.getCreateUserId());
        Long customId = payload.getCustomerId();
        if (ObjectUtils.isEmpty((Object)customId)) {
            customId = visitPlanVO.getCustomId();
            payload.setCustomerId(customId);
        }
        if (!ObjectUtils.isEmpty((Object)customId)) {
            CrmCustomerVO crmCustomerVO = this.crmCustomerDAO.queryDetail(customId);
            Assert.notNull((Object)crmCustomerVO, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            payload.setCustomerName(crmCustomerVO.getCustomerName());
        }
        if (ObjectUtils.isEmpty((Object)payload.getStatus())) {
            payload.setStatus(VisitTaskStatusEnum.NEW.getCode());
        }
    }

    private void check(VisitTaskPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getPlanId())) {
            throw TwException.error("", "planId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkUpdate(VisitTaskPayload payload, VisitTaskDO entity) {
        if (entity.getStatus().equals(VisitTaskStatusEnum.OK.getCode())) {
            throw TwException.error("", "\u5df2\u63d0\u4ea4\u7684\u4efb\u52a1\u4e0d\u53ef\u53d8\u66f4");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.visitTaskRepo.findById(id);
                if (!optional.isEmpty()) {
                    VisitTaskDO entity = (VisitTaskDO)optional.get();
                    if (entity.getPlanCreateUserId().equals(loginUserId) || entity.getVisitMemberId().equals(loginUserId) || rolePermission.booleanValue()) {
                        if (!entity.getStatus().equals(VisitTaskStatusEnum.NEW.getCode())) {
                            throw TwException.error("", "[" + entity.getTaskName() + "]\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664");
                        }
                        entity.setDeleteFlag(1);
                        this.visitTaskRepo.save(entity);
                    } else {
                        throw TwException.error("", "[" + entity.getTaskName() + "]\u65e0\u6743\u9650\u5220\u9664");
                    }
                }
            });
        }
    }

    public void deleteSoftByPlanId(Long planId) {
        if (null != planId) {
            long count = this.countByPlanId(planId);
            if (count > 0L) {
                throw TwException.error("", "\u4efb\u52a1\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            this.visitTaskDAO.deleteSoftByPlanId(planId);
        }
    }

    public long countByPlanId(Long planId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        taskQuery.setPlanId(planId);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(VisitTaskStatusEnum.OK.getCode());
        statusList.add(VisitTaskStatusEnum.READY.getCode());
        taskQuery.setStatusList(statusList);
        return this.visitTaskDAO.count(taskQuery);
    }

    public VisitTaskOpenPayload customerEval(VisitTaskOpenPayload openPayload) {
        VisitTaskDO entity = this.visitTaskRepo.findById(openPayload.getId()).orElseGet(VisitTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u62dc\u8bbf\u4e0d\u5b58\u5728");
        VisitTaskPayload payload = new VisitTaskPayload();
        payload.setId(openPayload.getId());
        payload.setCustomerGradle(openPayload.getCustomerGradle());
        payload.setCustomerAdvise(openPayload.getCustomerAdvise());
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        this.visitTaskRepo.save(entity);
        return openPayload;
    }

    public VisitTaskVO leaderEval(VisitTaskPayload payload) {
        VisitTaskDO entity = this.visitTaskRepo.findById(payload.getId()).orElseGet(VisitTaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u62dc\u8bbf\u4e0d\u5b58\u5728");
        VisitTaskPayload update = new VisitTaskPayload();
        update.setId(payload.getId());
        update.setLeaderGradle(payload.getLeaderGradle());
        update.setEvalStatus(VisitTaskEvalStatusEnum.OK.getCode());
        update.setNextPlan(payload.getNextPlan());
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(update);
        entity.copy(entityDo);
        VisitTaskDO save = (VisitTaskDO)this.visitTaskRepo.save(entity);
        return VisitTaskConvert.INSTANCE.toVo(save);
    }

    public long count(VisitTaskQuery query) {
        return this.visitTaskDAO.count(query);
    }

    public VisitTaskServiceImpl(VisitTaskRepo visitTaskRepo, VisitTaskDAO visitTaskDAO, CacheUtil cacheUtil, PrdOrgEmployeeService prdOrgEmployeeService, VisitPlanDAO visitPlanDAO, VisitPlanDetailDAO visitPlanDetailDAO, CrmCustomerDAO crmCustomerDAO, VisitSignRecordDAO visitSignRecordDAO, FileUtil fileUtil, SmsRpcService smsRpcService) {
        this.visitTaskRepo = visitTaskRepo;
        this.visitTaskDAO = visitTaskDAO;
        this.cacheUtil = cacheUtil;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.visitPlanDAO = visitPlanDAO;
        this.visitPlanDetailDAO = visitPlanDetailDAO;
        this.crmCustomerDAO = crmCustomerDAO;
        this.visitSignRecordDAO = visitSignRecordDAO;
        this.fileUtil = fileUtil;
        this.smsRpcService = smsRpcService;
    }
}

