/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.workflow;

import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityQuotePayload;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityQuoteVO;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityQuoteDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/OPPO_QUOTE/callBack"})
@Transactional
public class OpportunityQuoteWorkflowController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(OpportunityQuoteWorkflowController.class);
    private final OpportunityQuoteDAO dao;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        OpportunityQuotePayload quotePayload = new OpportunityQuotePayload();
        quotePayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        OpportunityQuoteVO opportunityQuoteVO = this.dao.queryByKey(Long.valueOf(businessKey));
        if (opportunityQuoteVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    quotePayload.setQuoteStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    quotePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    quotePayload.setQuoteStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                }
                case INVALID: {
                    quotePayload.setQuoteStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    quotePayload.setDeleteFlag(Integer.valueOf(1));
                    quotePayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    quotePayload.setQuoteStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    quotePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    quotePayload.setQuoteStatus(WorkFlowStatusEnum.APPROVED.getCode());
                    quotePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    quotePayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
            }
            this.dao.updateWorkFlow(quotePayload);
        }
    }

    public OpportunityQuoteWorkflowController(OpportunityQuoteDAO dao) {
        this.dao = dao;
    }
}

