/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.common.change.payload.ComBusinessChangePayload;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPricePayload;
import com.elitesland.tw.tw5crm.api.product.service.ProductPriceService;
import com.elitesland.tw.tw5crm.server.common.change.dao.ComBusinessChangeDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductPriceDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/PRODUCT_PRICE_CHANGE/callBack"})
@Transactional
public class ProductPriceChangeWorkflowController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(ProductPriceChangeWorkflowController.class);
    private final ProductPriceService productPriceService;
    private final ComBusinessChangeDAO businessChangeDao;
    private final ProductPriceDAO productPriceDAO;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        ComBusinessChangeVO comBusinessChangeVO = this.businessChangeDao.queryByKey(Long.valueOf(businessKey));
        if (comBusinessChangeVO != null) {
            ProductPricePayload pricePayload = new ProductPricePayload();
            pricePayload.setId(Long.valueOf(comBusinessChangeVO.getChangeDocId()));
            pricePayload.setPriceStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            ComBusinessChangePayload changePayload = new ComBusinessChangePayload();
            changePayload.setId(comBusinessChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            Boolean isUp = false;
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                }
                case INTERRUPT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setApprProcInstId(null);
                    break;
                }
                case INVALID: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setApprProcInstId(null);
                    break;
                }
                case REJECTED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    isUp = true;
                    pricePayload = (ProductPricePayload)JSON.parseObject((String)comBusinessChangeVO.getChangeContent(), ProductPricePayload.class);
                    pricePayload.setPriceStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    LocalDate now = LocalDate.now();
                    LocalDate startTime = pricePayload.getStartTime();
                    LocalDate endTime = pricePayload.getEndTime();
                    if (!ObjectUtils.isEmpty((Object)startTime)) {
                        if (startTime.isAfter(now)) {
                            pricePayload.setPriceStatus(WorkFlowStatusEnum.PENDING_WORK.getCode());
                        } else if (!ObjectUtils.isEmpty((Object)endTime) && endTime.isBefore(now)) {
                            pricePayload.setPriceStatus(WorkFlowStatusEnum.PENDING_WORK.getCode());
                        }
                    }
                    pricePayload.setApprovedTime(LocalDateTime.now());
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    break;
                }
            }
            this.businessChangeDao.updateWorkFlow(changePayload);
            if (isUp.booleanValue()) {
                this.productPriceService.updateProductPrice(pricePayload);
            } else {
                this.productPriceDAO.updateWorkFlow(pricePayload);
            }
        }
    }

    public ProductPriceChangeWorkflowController(ProductPriceService productPriceService, ComBusinessChangeDAO businessChangeDao, ProductPriceDAO productPriceDAO) {
        this.productPriceService = productPriceService;
        this.businessChangeDao = businessChangeDao;
        this.productPriceDAO = productPriceDAO;
    }
}

