/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanSnapshotPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanSnapshotQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanSnapshotVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectPlanSnapshotDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsProjectPlanSnapshotDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectPlanSnapshotRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsProjectPlanSnapshotDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectPlanSnapshotRepo repo;
    private final QPmsProjectPlanSnapshotDO qdo = QPmsProjectPlanSnapshotDO.pmsProjectPlanSnapshotDO;

    private JPAQuery<PmsProjectPlanSnapshotVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectPlanSnapshotVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.projectId, this.qdo.snapName, this.qdo.snapContent})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsProjectPlanSnapshotVO> getJpaQueryWhere(PmsProjectPlanSnapshotQuery query) {
        JPAQuery<PmsProjectPlanSnapshotVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsProjectPlanSnapshotQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsProjectPlanSnapshotQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSnapName())) {
            list.add(this.qdo.snapName.like(SqlUtil.toSqlLikeString(query.getSnapName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSnapContent())) {
            list.add(this.qdo.snapContent.like(SqlUtil.toSqlLikeString(query.getSnapContent())));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectPlanSnapshotVO queryByKey(Long id) {
        JPAQuery<PmsProjectPlanSnapshotVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectPlanSnapshotVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectPlanSnapshotVO> queryListDynamic(PmsProjectPlanSnapshotQuery query) {
        JPAQuery<PmsProjectPlanSnapshotVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsProjectPlanSnapshotVO> queryPaging(PmsProjectPlanSnapshotQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectPlanSnapshotVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsProjectPlanSnapshotDO save(PmsProjectPlanSnapshotDO ado) {
        return (PmsProjectPlanSnapshotDO)this.repo.save(ado);
    }

    public List<PmsProjectPlanSnapshotDO> saveAll(List<PmsProjectPlanSnapshotDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsProjectPlanSnapshotPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getProjectId() != null) {
            update.set(this.qdo.projectId, (Object)payload.getProjectId());
        }
        if (payload.getSnapName() != null) {
            update.set((Path)this.qdo.snapName, (Object)payload.getSnapName());
        }
        if (payload.getSnapContent() != null) {
            update.set((Path)this.qdo.snapContent, (Object)payload.getSnapContent());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("projectId")) {
                update.setNull(this.qdo.projectId);
            }
            if (nullFields.contains("snapName")) {
                update.setNull((Path)this.qdo.snapName);
            }
            if (nullFields.contains("snapContent")) {
                update.setNull((Path)this.qdo.snapContent);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsProjectPlanSnapshotDAO(JPAQueryFactory jpaQueryFactory, PmsProjectPlanSnapshotRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

