/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectWbsDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsProjectWbsDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectWbsRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsProjectWbsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectWbsRepo repo;
    private final QPmsProjectWbsDO qdo = QPmsProjectWbsDO.pmsProjectWbsDO;

    private JPAQuery<PmsProjectWbsVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectWbsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.projectId, this.qdo.parentId, this.qdo.wbsName, this.qdo.wbsType, this.qdo.wbsCode, this.qdo.nodeCode, this.qdo.parentWbsCode, this.qdo.costPlan, this.qdo.subjectDist, this.qdo.invoiceAttr, this.qdo.durationDay, this.qdo.actTaskId, this.qdo.actCostType})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsProjectWbsVO> getJpaQueryWhere(PmsProjectWbsQuery query) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    private Predicate where(PmsProjectWbsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsSearch())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString(query.getWbsSearch())).or((Predicate)this.qdo.nodeCode.like(SqlUtil.toSqlLikeString(query.getWbsSearch()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsName())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString(query.getWbsName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsType())) {
            list.add(this.qdo.wbsType.eq((Object)query.getWbsType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsCode())) {
            list.add(this.qdo.wbsCode.like(SqlUtil.toSqlLikeString(query.getWbsCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNodeCode())) {
            list.add(this.qdo.nodeCode.eq((Object)query.getNodeCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentWbsCode())) {
            list.add(this.qdo.parentWbsCode.eq((Object)query.getParentWbsCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostPlan())) {
            list.add(this.qdo.costPlan.eq((Object)query.getCostPlan()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectDist())) {
            list.add(this.qdo.subjectDist.eq((Object)query.getSubjectDist()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceAttr())) {
            list.add(this.qdo.invoiceAttr.eq((Object)query.getInvoiceAttr()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDurationDay())) {
            list.add(this.qdo.durationDay.eq((Object)query.getDurationDay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getActTaskId())) {
            list.add(this.qdo.actTaskId.eq((Object)query.getActTaskId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getActCostType())) {
            list.add(this.qdo.actCostType.eq((Object)query.getActCostType()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectWbsVO queryByKey(Long id) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectWbsVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectWbsVO> queryByProjectId(Long projectId) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsVO> queryListDynamic(PmsProjectWbsQuery query) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PmsProjectWbsDO save(PmsProjectWbsDO ado) {
        return (PmsProjectWbsDO)this.repo.save(ado);
    }

    public List<PmsProjectWbsDO> saveAll(List<PmsProjectWbsDO> dos) {
        return this.repo.saveAll(dos);
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsProjectWbsDAO(JPAQueryFactory jpaQueryFactory, PmsProjectWbsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

