/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsTemplatePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsWbsTemplateQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsTemplateVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsTemplateDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsWbsTemplateDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsWbsTemplateNodeDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsWbsTemplateRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsWbsTemplateDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsWbsTemplateRepo repo;
    private final QPmsWbsTemplateDO qdo = QPmsWbsTemplateDO.pmsWbsTemplateDO;
    private final QPmsWbsTemplateNodeDO qndo = QPmsWbsTemplateNodeDO.pmsWbsTemplateNodeDO;

    private JPAQuery<PmsWbsTemplateVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsWbsTemplateVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.templateName, this.qdo.suitProjectType, this.qdo.templateStatus})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsWbsTemplateVO> getJpaQueryWhere(PmsWbsTemplateQuery query) {
        JPAQuery<PmsWbsTemplateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsWbsTemplateQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsWbsTemplateQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTemplateName())) {
            list.add(this.qdo.templateName.like(SqlUtil.toSqlLikeString(query.getTemplateName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSuitProjectType())) {
            list.add(this.qdo.suitProjectType.like(SqlUtil.toSqlLikeString("," + query.getSuitProjectType() + ",")));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTemplateStatus())) {
            list.add(this.qdo.templateStatus.eq((Object)query.getTemplateStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart()) && !ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            list.add(this.qdo.createTime.between((Comparable)query.getCreateTimeStart(), (Comparable)query.getCreateTimeEnd()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsWbsTemplateVO queryByKey(Long id) {
        JPAQuery<PmsWbsTemplateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsWbsTemplateVO)jpaQuery.fetchFirst();
    }

    public List<PmsWbsTemplateVO> queryListDynamic(PmsWbsTemplateQuery query) {
        JPAQuery<PmsWbsTemplateVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsWbsTemplateVO> queryPaging(PmsWbsTemplateQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsWbsTemplateVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsWbsTemplateDO save(PmsWbsTemplateDO ado) {
        return (PmsWbsTemplateDO)this.repo.save(ado);
    }

    public List<PmsWbsTemplateDO> saveAll(List<PmsWbsTemplateDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsWbsTemplatePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getTemplateName() != null) {
            update.set((Path)this.qdo.templateName, (Object)payload.getTemplateName());
        }
        if (payload.getSuitProjectType() != null) {
            update.set((Path)this.qdo.suitProjectType, (Object)payload.getSuitProjectType());
        }
        if (payload.getTemplateStatus() != null) {
            update.set((Path)this.qdo.templateStatus, (Object)payload.getTemplateStatus());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("templateName")) {
                update.setNull((Path)this.qdo.templateName);
            }
            if (nullFields.contains("suitProjectType")) {
                update.setNull((Path)this.qdo.suitProjectType);
            }
            if (nullFields.contains("templateStatus")) {
                update.setNull((Path)this.qdo.templateStatus);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<PmsWbsTemplateVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsWbsTemplateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public Long updateStatus(List<Long> keys, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.templateStatus, (Object)status).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public boolean queryByName(PmsWbsTemplatePayload payload) {
        JPAQuery<PmsWbsTemplateVO> jpaQuerySelect = this.getJpaQuerySelect();
        JPAQuery jpaQuery = (JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.templateName.eq((Object)payload.getTemplateName()));
        PmsWbsTemplateVO pmsWbsTemplateVO = (PmsWbsTemplateVO)jpaQuery.fetchOne();
        return pmsWbsTemplateVO != null;
    }

    public PmsWbsTemplateDAO(JPAQueryFactory jpaQueryFactory, PmsWbsTemplateRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

