/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanDataPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanSnapshotPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanLogQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanSnapshotQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectPlanService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectPlanSnapshotService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanSimpleVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanSnapshotVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComChangeTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.common.util.ChangeFieldUtil;
import com.elitesland.tw.tw5pms.server.common.util.criticalPath.Task;
import com.elitesland.tw.tw5pms.server.common.util.criticalPath.Wbs;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectPlanConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectPlanDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectPlanDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectPlanRepo;
import java.math.BigDecimal;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectPlanServiceImpl
extends BaseServiceImpl
implements PmsProjectPlanService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectPlanServiceImpl.class);
    private final ComLogService logService;
    private final ComChangeService changeService;
    private final PmsProjectDAO projectDAO;
    private final CacheUtil cacheUtil;
    private final PmsProjectPlanRepo pmsProjectPlanRepo;
    private final PmsProjectPlanDAO pmsProjectPlanDAO;
    private final ChangeFieldUtil changeFieldUtil;
    private final TransactionUtilService transactionUtilService;
    private final PmsProjectPlanSnapshotService planSnapshotService;

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectPlanVO batchInsertOrUpdate(PmsProjectPlanDataPayload payload) {
        this.checkPlanData(payload);
        PmsProjectVO projectVO = this.projectDAO.queryByKey(payload.getProjectId());
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error("", "\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsProjectPlanVO> pmsProjectPlanVOS = this.pmsProjectPlanDAO.queryByProjectId(payload.getProjectId());
        ArrayList<ComLogPayload> logPayloads = new ArrayList<ComLogPayload>();
        if (!ObjectUtils.isEmpty((Object)payload.getDelPlanIds())) {
            List<PmsProjectPlanVO> collect = pmsProjectPlanVOS.stream().filter(planVO -> payload.getDelPlanIds().contains(planVO.getId())).collect(Collectors.toList());
            List<PmsProjectPlanVO> planVOS = pmsProjectPlanVOS.stream().filter(planVO -> payload.getDelPlanIds().contains(planVO.getParentId()) && planVO.getPlanType().equals("TASK")).collect(Collectors.toList());
            this.checkDelPlan(planVOS, payload.getDelPlanIds());
            this.createPlanDelLog(logPayloads, collect);
            this.pmsProjectPlanDAO.deleteSoft(payload.getDelPlanIds());
            pmsProjectPlanVOS.removeAll(collect);
        }
        List planPayloads = payload.getPlanPayloads();
        ArrayList updateDOs = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)planPayloads)) {
            this.checkPlan(planPayloads, pmsProjectPlanVOS);
            List<PmsProjectPlanPayload> updatePayloads = planPayloads.stream().filter(planPayload -> planPayload.getId() != null).collect(Collectors.toList());
            List<Long> updateIds = this.createPlanUpdateLog(logPayloads, pmsProjectPlanVOS, updatePayloads);
            List<PmsProjectPlanDO> entityDos = planPayloads.stream().map(e -> {
                e.setProjectId(payload.getProjectId());
                if (e.getId() == null && e.getPlanType().equals("STAGE")) {
                    String lastFourDigits = String.format("%04d", System.currentTimeMillis() % 10000L);
                    Random random = new Random();
                    int s = random.nextInt(99) % 90 + 10;
                    e.setNodeCode(projectVO.getProjectCode() + "-STG-" + lastFourDigits + s);
                }
                PmsProjectPlanDO planDO = PmsProjectPlanConvert.INSTANCE.toDo((PmsProjectPlanPayload)e);
                e.setPlanDO((BaseModel)planDO);
                return planDO;
            }).collect(Collectors.toList());
            List<PmsProjectPlanDO> pmsProjectPlanDOS = this.pmsProjectPlanDAO.saveAll(entityDos);
            pmsProjectPlanDOS.forEach(planDO -> {
                Optional<PmsProjectPlanVO> first = pmsProjectPlanVOS.stream().filter(planVO -> planVO.getId().equals(planDO.getId())).findFirst();
                if (first.isPresent()) {
                    pmsProjectPlanVOS.remove(first.get());
                }
                pmsProjectPlanVOS.add(PmsProjectPlanConvert.INSTANCE.toVo((PmsProjectPlanDO)planDO));
            });
            ArrayList<PmsProjectPlanPayload> addPayloads = new ArrayList<PmsProjectPlanPayload>();
            planPayloads.forEach(planPayload1 -> {
                planPayload1.setId(planPayload1.getPlanDO().getId());
                if (!updateIds.contains(planPayload1.getId())) {
                    addPayloads.add((PmsProjectPlanPayload)planPayload1);
                }
            });
            this.createPlanAddLog(logPayloads, addPayloads);
            pmsProjectPlanDOS.forEach(planDO -> {
                boolean isAdd = false;
                if (StringUtils.hasText((String)planDO.getParentPlanCode())) {
                    Optional<PmsProjectPlanVO> first = pmsProjectPlanVOS.stream().filter(pmsProjectPlanVO -> pmsProjectPlanVO.getPlanCode().equals(planDO.getParentPlanCode())).findFirst();
                    if (first.isPresent()) {
                        planDO.setParentId(first.get().getId());
                        updateDOs.add(planDO);
                        isAdd = true;
                    } else {
                        throw TwException.error("", "\u4e0a\u7ea7\u7f16\u53f7\u4e3a\u3010" + planDO.getParentPlanCode() + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                }
                if (StringUtils.hasText((String)planDO.getRelySourceIds())) {
                    List collect = pmsProjectPlanVOS.stream().filter(pmsProjectPlanVO -> planDO.getRelySourceIds().contains("" + pmsProjectPlanVO.getSourceId())).collect(Collectors.toList());
                    if (!ObjectUtils.isEmpty(collect)) {
                        String collect1 = collect.stream().map(BaseViewModel::getId).map(Objects::toString).collect(Collectors.joining(","));
                        String collect2 = collect.stream().map(PmsProjectPlanVO::getSourceId).map(Objects::toString).collect(Collectors.joining(","));
                        String collect3 = collect.stream().map(PmsProjectPlanVO::getPlanName).collect(Collectors.joining(","));
                        planDO.setRelyPlanIds(collect1);
                        planDO.setRelySourceIds(collect2);
                        planDO.setRelyPlanNames(collect3);
                        if (!isAdd) {
                            updateDOs.add(planDO);
                        }
                    } else {
                        throw TwException.error("", "\u4e0a\u7ea7\u7f16\u53f7\u4e3a\u3010" + planDO.getParentPlanCode() + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                }
            });
        }
        if (logPayloads.size() > 0) {
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setChangeContent("\u9879\u76eeplan\u53d8\u66f4");
            changePayload.setChangeDocId("" + payload.getProjectId());
            changePayload.setChangeType(ComChangeTypeEnum.PMS_PROJECT_PLAN.getCode());
            changePayload.setCreator(GlobalUtil.getLoginUserName());
            ComChangeVO insert = this.changeService.insert(changePayload);
            String vid = payload.getProjectId() + "-" + insert.getVersionNo();
            logPayloads.forEach(log -> log.setExtString1(vid));
            this.logService.insertBacth(logPayloads);
        }
        if (!ObjectUtils.isEmpty(updateDOs)) {
            this.transactionUtilService.executeWithRunnable(() -> this.pmsProjectPlanDAO.saveAll(updateDOs));
        }
        return null;
    }

    List<Long> operKeyPath(List<PmsProjectPlanVO> pmsProjectPlanVOS) {
        ArrayList<PmsProjectPlanVO> planVOS = new ArrayList<PmsProjectPlanVO>();
        Object relys = ",";
        for (PmsProjectPlanVO pmsProjectPlanVO : pmsProjectPlanVOS) {
            if (!pmsProjectPlanVO.getPlanType().equals("ACT")) continue;
            planVOS.add(pmsProjectPlanVO);
            if (!StringUtils.hasText((String)pmsProjectPlanVO.getRelyPlanIds())) continue;
            relys = (String)relys + pmsProjectPlanVO.getRelyPlanIds() + "," + pmsProjectPlanVO.getId() + ",";
        }
        LinkedList<Task> tl = new LinkedList<Task>();
        for (PmsProjectPlanVO planVO : pmsProjectPlanVOS) {
            if (!((String)relys).contains(planVO.getId() + ",")) continue;
            Double durationDay = planVO.getDurationDay() == null ? 0.0 : planVO.getDurationDay().doubleValue();
            Double relyDay = planVO.getRelyDay() == null ? 0.0 : planVO.getRelyDay().doubleValue();
            String relyType = StringUtils.hasText((String)planVO.getRelyType()) ? planVO.getRelyType() : "FS";
            Task task2 = new Task("" + planVO.getId(), relyType, durationDay, relyDay, planVO.getRelyPlanIds());
            tl.add(task2);
        }
        if (!ObjectUtils.isEmpty(tl)) {
            tl.forEach(task -> {
                List<Task> collect;
                if (StringUtils.hasText((String)task.getRelyPlanIds()) && !ObjectUtils.isEmpty(collect = tl.stream().filter(task1 -> task.getRelyPlanIds().contains(task1.getTaskNumber())).collect(Collectors.toList()))) {
                    task.setPreviousTasks(collect);
                }
            });
        }
        Wbs wbs = new Wbs(tl);
        wbs.calculateTime();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Task task3 : wbs.getTasks()) {
            task3.setCriticalPath();
            if (!task3.isCriticalPath()) continue;
            ids.add(Long.valueOf(task3.getTaskNumber()));
        }
        return ids;
    }

    void createPlanAddLog(List<ComLogPayload> logPayloads, List<PmsProjectPlanPayload> planPayloads) {
        if (!ObjectUtils.isEmpty(planPayloads)) {
            planPayloads.forEach(planPayload -> {
                String fieldsCreateLog = this.changeFieldUtil.getFieldsCreateLog(planPayload, null);
                ComLogPayload logPayload = new ComLogPayload();
                logPayload.setObjectId("" + planPayload.getId());
                logPayload.setLogType(ComLogTypeEnum.pms_project_plan.getCode());
                logPayload.setExtString2(planPayload.getPlanType());
                logPayload.setExtString3("CREATE");
                logPayload.setExtString4(planPayload.getPlanName());
                logPayload.setLogContent(fieldsCreateLog);
                logPayloads.add(logPayload);
            });
        }
    }

    List<Long> createPlanUpdateLog(List<ComLogPayload> logPayloads, List<PmsProjectPlanVO> planVOS, List<PmsProjectPlanPayload> planPayloads) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (!ObjectUtils.isEmpty(planPayloads)) {
            planPayloads.forEach(planPayload -> {
                Optional<PmsProjectPlanVO> first;
                ids.add(planPayload.getId());
                if (!ObjectUtils.isEmpty((Object)planVOS) && (first = planVOS.stream().filter(planVO -> planVO.getId().equals(planPayload.getId())).findFirst()).isPresent()) {
                    PmsProjectPlanVO pmsProjectPlanVO = first.get();
                    PmsProjectPlanPayload pmsProjectPlanPayload = PmsProjectPlanConvert.INSTANCE.toPayload(pmsProjectPlanVO);
                    this.transferData(pmsProjectPlanPayload);
                    this.transferData((PmsProjectPlanPayload)planPayload);
                    String fieldsUpdateLog = this.changeFieldUtil.getFieldsUpdateLog(planPayload, pmsProjectPlanPayload);
                    if (StringUtils.hasText((String)fieldsUpdateLog)) {
                        ComLogPayload logPayload = new ComLogPayload();
                        logPayload.setObjectId("" + planPayload.getId());
                        logPayload.setLogType(ComLogTypeEnum.pms_project_plan.getCode());
                        logPayload.setExtString2(planPayload.getPlanType());
                        logPayload.setExtString3("UPDATE");
                        logPayload.setExtString4(planPayload.getPlanName());
                        logPayload.setLogContent(fieldsUpdateLog);
                        logPayloads.add(logPayload);
                    }
                }
            });
        }
        return ids;
    }

    void createPlanDelLog(List<ComLogPayload> logPayloads, List<PmsProjectPlanVO> collect) {
        collect.forEach(planVO -> {
            ComLogPayload logPayload = new ComLogPayload();
            logPayload.setObjectId("" + planVO.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_plan.getCode());
            logPayload.setLogContent("\u8ba1\u5212\u3010" + planVO.getPlanName() + "\u3011\u88ab\u5220\u9664");
            logPayload.setExtString2(planVO.getPlanType());
            logPayload.setExtString3("DEL");
            logPayload.setExtString4(planVO.getPlanName());
            logPayloads.add(logPayload);
        });
    }

    void checkPlan(List<PmsProjectPlanPayload> planPayloads, List<PmsProjectPlanVO> planVOS) {
        List collect = planPayloads.stream().map(PmsProjectPlanPayload::getPlanName).distinct().collect(Collectors.toList());
        if (planPayloads.size() != collect.size()) {
            throw TwException.error("", "\u8ba1\u5212\u63cf\u8ff0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List collect0 = planPayloads.stream().map(PmsProjectPlanPayload::getPlanCode).distinct().collect(Collectors.toList());
        if (planPayloads.size() != collect0.size()) {
            throw TwException.error("", "\u8ba1\u5212\u7f16\u7801\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Map<Long, Long> collect1 = planPayloads.stream().filter(planPayload -> planPayload.getSourceId() != null).collect(Collectors.groupingBy(PmsProjectPlanPayload::getSourceId, Collectors.counting()));
        Optional<Long> collect2 = collect1.keySet().stream().filter(key -> (Long)collect1.get(key) > 1L).findFirst();
        if (collect2.isPresent()) {
            throw TwException.error("", "\u8ba1\u5212\u5173\u8054\u8d44\u6e90\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        planPayloads.forEach(planPayload -> {
            if (ObjectUtils.isEmpty((Object)planPayload.getPlanCode())) {
                throw TwException.error("", "\u8ba1\u5212\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)planPayload.getPlanType())) {
                throw TwException.error("", "\u8ba1\u5212\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!(ObjectUtils.isEmpty((Object)planPayload.getRelyType()) || "FS".equals(planPayload.getRelyType()) || "FF".equals(planPayload.getRelyType()) || "SS".equals(planPayload.getRelyType()))) {
                throw TwException.error("", "\u975e\u6cd5\u524d\u7f6e\u4f9d\u8d56\u7c7b\u578b\u3010" + planPayload.getRelyType() + "\u3011\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!ObjectUtils.isEmpty((Object)planPayload.getStartDate()) && !ObjectUtils.isEmpty((Object)planPayload.getEndDate())) {
                if (planPayload.getStartDate().isAfter(planPayload.getEndDate())) {
                    throw TwException.error("", "\u7ed3\u675f\u65f6\u95f4\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                BigDecimal days = new BigDecimal(ChronoUnit.DAYS.between(planPayload.getStartDate(), planPayload.getEndDate()) + 1L);
                planPayload.setDurationDay(days);
            }
            if (!ObjectUtils.isEmpty((Object)planPayload.getRelySourceIds())) {
                if (!"ACT".equals(planPayload.getPlanType())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u6d3b\u52a8\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (ObjectUtils.isEmpty((Object)planPayload.getStartDate()) || ObjectUtils.isEmpty((Object)planPayload.getEndDate())) {
                    throw TwException.error("", "\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\u9700\u4fdd\u8bc1\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                List collect3 = planPayloads.stream().filter(plan -> planPayload.getRelySourceIds().contains("" + plan.getSourceId())).collect(Collectors.toList());
                long relyDay = -10000L;
                if ("FS".equals(planPayload.getRelyType())) {
                    relyDay = 10000L;
                }
                for (int i = 0; i < collect3.size(); ++i) {
                    long relyDay0;
                    PmsProjectPlanPayload planPayload0 = (PmsProjectPlanPayload)collect3.get(i);
                    if (!"ACT".equals(planPayload0.getPlanType())) {
                        throw TwException.error("", "\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\u5fc5\u987b\u662f\u6d3b\u52a8\u7c7b\u578b\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (ObjectUtils.isEmpty((Object)planPayload0.getStartDate()) || ObjectUtils.isEmpty((Object)planPayload0.getEndDate())) {
                        throw TwException.error("", "\u8bbe\u7f6e\u524d\u7f6e\u4f9d\u8d56\u6d3b\u52a8\u5fc5\u987b\u8bbe\u7f6e\u5f00\u59cb\u53ca\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if ("FS".equals(planPayload.getRelyType())) {
                        relyDay0 = ChronoUnit.DAYS.between(planPayload0.getEndDate(), planPayload.getStartDate()) - 1L;
                        if (relyDay0 < 0L) {
                            throw TwException.error("", "\u3010" + planPayload.getPlanName() + "\u3011\u8bbe\u7f6e\u4f9d\u8d56\u6d3b\u52a8\u3010" + planPayload0.getPlanName() + "\u3011\u5fc5\u987b\u8bbe\u7f6e\u5f00\u59cb\u53ca\u7ed3\u675f\u65f6\u95f4\u4e0d\u5408\u7406\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        if (relyDay0 < relyDay) {
                            relyDay = relyDay0;
                        }
                    }
                    if ("FF".equals(planPayload.getRelyType()) && (relyDay0 = ChronoUnit.DAYS.between(planPayload.getEndDate(), planPayload0.getEndDate())) > relyDay) {
                        relyDay = relyDay0;
                    }
                    if (!"SS".equals(planPayload.getRelyType()) || (relyDay0 = ChronoUnit.DAYS.between(planPayload.getStartDate(), planPayload0.getStartDate())) <= relyDay) continue;
                    relyDay = relyDay0;
                }
                planPayload.setRelyDay(new BigDecimal(relyDay));
            }
        });
    }

    void checkDelPlan(List<PmsProjectPlanVO> planVOS, List<Long> delPlanIds) {
        if (!ObjectUtils.isEmpty(planVOS)) {
            Map<Long, List<PmsProjectPlanVO>> groupedList = planVOS.stream().collect(Collectors.groupingBy(PmsProjectPlanVO::getParentId));
            delPlanIds.forEach(delId -> {
                List collect;
                List pmsProjectPlanVOS = (List)groupedList.get(delId);
                if (!ObjectUtils.isEmpty((Object)pmsProjectPlanVOS) && !delPlanIds.containsAll(collect = pmsProjectPlanVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList()))) {
                    throw TwException.error("", "\u8bf7\u5148\u4e3a\u9636\u6bb5\u4e0b\u7684\u4efb\u52a1\u66f4\u6362\u5173\u8054\u9879\uff01");
                }
            });
        }
    }

    public PagingVO<PmsProjectPlanVO> queryPaging(PmsProjectPlanQuery query) {
        PagingVO<PmsProjectPlanVO> pmsProjectPlanVOPagingVO = this.pmsProjectPlanDAO.queryPaging(query);
        pmsProjectPlanVOPagingVO.getRecords().forEach(this::transferData);
        return pmsProjectPlanVOPagingVO;
    }

    void transferData(PmsProjectPlanVO vo) {
        vo.setManagerUserName(this.cacheUtil.getUserName(vo.getManagerUserId()));
        vo.setSourceStatusName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:PLAN:STATUS", vo.getSourceStatus()));
    }

    void transferData(PmsProjectPlanPayload payload) {
        payload.setManagerUserName(this.cacheUtil.getUserName(payload.getManagerUserId()));
        payload.setSourceStatusName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:PLAN:STATUS", payload.getSourceStatus()));
    }

    public List<PmsProjectPlanVO> queryListDynamic(PmsProjectPlanQuery query) {
        List<PmsProjectPlanVO> planVOS = this.pmsProjectPlanDAO.queryListDynamic(query);
        planVOS.forEach(this::transferData);
        return planVOS;
    }

    public PmsProjectPlanVO queryByKey(Long key) {
        PmsProjectPlanDO entity = this.pmsProjectPlanRepo.findById(key).orElseGet(PmsProjectPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectPlanVO vo = PmsProjectPlanConvert.INSTANCE.toVo(entity);
        this.transferData(vo);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectPlanDAO.deleteSoft(keys);
        }
    }

    public List<ComLogVO> queryLogList(PmsProjectPlanLogQuery query) {
        if (query.getProjectId() != null && query.getVersionNo() != null || query.getPlanId() != null) {
            ComLogQuery logQuery = new ComLogQuery();
            logQuery.setLogType(ComLogTypeEnum.pms_project_plan.getCode());
            logQuery.setLogContent(query.getLogContent());
            if (query.getProjectId() != null && query.getVersionNo() != null) {
                String vid = query.getProjectId() + "-" + query.getVersionNo();
                logQuery.setExtString1(vid);
            } else {
                logQuery.setObjectId("" + query.getPlanId());
            }
            if (StringUtils.hasText((String)query.getOperType())) {
                logQuery.setExtString3(query.getOperType());
            }
            if (StringUtils.hasText((String)query.getPlanType())) {
                logQuery.setExtString2(query.getPlanType());
            }
            return this.logService.queryList(logQuery);
        }
        throw TwException.error("", "\u67e5\u8be2\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    public PmsProjectPlanSnapshotVO insertSnapshot(PmsProjectPlanSnapshotPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error("", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsProjectPlanSimpleVO> pmsProjectPlanVOS = this.pmsProjectPlanDAO.querySimpleByProjectId(payload.getProjectId());
        if (ObjectUtils.isEmpty(pmsProjectPlanVOS)) {
            throw TwException.error("", "\u57fa\u7ebf\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        String originalContent = JSONObject.toJSONString(pmsProjectPlanVOS);
        payload.setSnapContent(originalContent);
        PmsProjectPlanSnapshotVO insert = this.planSnapshotService.insert(payload);
        return insert;
    }

    public List<PmsProjectPlanSnapshotVO> querySnapshotList(PmsProjectPlanSnapshotQuery query) {
        List pmsProjectPlanSnapshotVOS = this.planSnapshotService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty((Object)pmsProjectPlanSnapshotVOS)) {
            pmsProjectPlanSnapshotVOS.forEach(snapshotVO -> {
                List pmsProjectPlanVOS = (List)JSON.parseObject((String)snapshotVO.getSnapContent(), List.class);
                snapshotVO.setPmsProjectPlanVOS(pmsProjectPlanVOS);
            });
        }
        return pmsProjectPlanSnapshotVOS;
    }

    public void deleteSoftSnapshot(List<Long> snapshotKeys) {
        this.planSnapshotService.deleteSoft(snapshotKeys);
    }

    void checkPlanData(PmsProjectPlanDataPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error("", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    public PmsProjectPlanServiceImpl(ComLogService logService, ComChangeService changeService, PmsProjectDAO projectDAO, CacheUtil cacheUtil, PmsProjectPlanRepo pmsProjectPlanRepo, PmsProjectPlanDAO pmsProjectPlanDAO, ChangeFieldUtil changeFieldUtil, TransactionUtilService transactionUtilService, PmsProjectPlanSnapshotService planSnapshotService) {
        this.logService = logService;
        this.changeService = changeService;
        this.projectDAO = projectDAO;
        this.cacheUtil = cacheUtil;
        this.pmsProjectPlanRepo = pmsProjectPlanRepo;
        this.pmsProjectPlanDAO = pmsProjectPlanDAO;
        this.changeFieldUtil = changeFieldUtil;
        this.transactionUtilService = transactionUtilService;
        this.planSnapshotService = planSnapshotService;
    }
}

