/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectTemplatePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectTemplateQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectTemplateService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectTemplateConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectTemplateDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectTemplateDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectTemplateRepo;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectTemplateServiceImpl
extends BaseServiceImpl
implements PmsProjectTemplateService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectTemplateServiceImpl.class);
    private final PmsProjectTemplateRepo pmsProjectTemplateRepo;
    private final PmsProjectTemplateDAO pmsProjectTemplateDAO;
    private final CacheUtil cacheUtil;
    private final ComLogService logService;

    public PagingVO<PmsProjectTemplateVO> paging(PmsProjectTemplateQuery query) {
        query.setTemplateType("tem");
        PagingVO<PmsProjectTemplateVO> paging = this.pmsProjectTemplateDAO.paging(query);
        if (!ObjectUtils.isEmpty((Object)paging.getRecords())) {
            paging.getRecords().forEach(record -> this.transferData((PmsProjectTemplateVO)record));
        }
        return paging;
    }

    public PagingVO<PmsProjectTemplateVO> queryPaging(PmsProjectTemplateQuery query) {
        query.setTemplateType("pre_tem");
        return this.pmsProjectTemplateDAO.queryPaging(query);
    }

    void transferData(PmsProjectTemplateVO vo) {
        vo.setTemplateStatusName(this.cacheUtil.transferSystemSelection("SYSTEM_BASIC:STATUS", vo.getTemplateStatus()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
    }

    public List<PmsProjectTemplateVO> queryList(PmsProjectTemplateQuery query) {
        query.setTemplateType("tem");
        return PmsProjectTemplateConvert.INSTANCE.toVoList(this.pmsProjectTemplateRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<PmsProjectTemplateVO> queryListDynamic(PmsProjectTemplateQuery query) {
        query.setTemplateType("tem");
        return this.pmsProjectTemplateDAO.queryListDynamic(query);
    }

    public PmsProjectTemplateVO queryByKey(Long key) {
        PmsProjectTemplateVO pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByKey(key);
        this.transferData(pmsProjectTemplateVO);
        return pmsProjectTemplateVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTemplateVO insert(PmsProjectTemplatePayload payload) {
        PmsProjectTemplateVO pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByName(payload.getTemplateName());
        if (!ObjectUtils.isEmpty((Object)pmsProjectTemplateVO)) {
            throw TwException.error("", "\u540d\u79f0\u53ef\u4e0d\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectTemplateDO entityDo = PmsProjectTemplateConvert.INSTANCE.toDo(payload);
        entityDo.setTemplateStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        entityDo.setTemplateType("tem");
        PmsProjectTemplateDO save = (PmsProjectTemplateDO)this.pmsProjectTemplateRepo.save(entityDo);
        ComLogPayload logPayload = new ComLogPayload();
        logPayload.setObjectId("" + save.getId());
        logPayload.setLogType(ComLogTypeEnum.pms_project_template.getCode());
        String content = "\u65b0\u589e\u6a21\u677f\uff1a\u3010" + save.getTemplateName() + "\u3011";
        logPayload.setLogContent(content);
        this.logService.insert(logPayload);
        return PmsProjectTemplateConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTemplateVO update(PmsProjectTemplatePayload payload) {
        PmsProjectTemplateVO pmsProjectTemplateVO;
        PmsProjectTemplateDO entity = this.pmsProjectTemplateRepo.findById(payload.getId()).orElseGet(PmsProjectTemplateDO::new);
        if (!entity.getTemplateName().equals(payload.getTemplateName()) && !ObjectUtils.isEmpty((Object)(pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByName(payload.getTemplateName())))) {
            throw TwException.error("", "\u540d\u79f0\u53ef\u4e0d\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectTemplateDO entityDo = PmsProjectTemplateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        ComLogPayload logPayload = new ComLogPayload();
        logPayload.setObjectId("" + entity.getId());
        logPayload.setLogType(ComLogTypeEnum.pms_project_template.getCode());
        String content = "\u7f16\u8f91\u6a21\u677f\uff1a\u3010" + entity.getTemplateName() + "\u3011";
        logPayload.setLogContent(content);
        this.logService.insert(logPayload);
        return PmsProjectTemplateConvert.INSTANCE.toVo((PmsProjectTemplateDO)this.pmsProjectTemplateRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            Object content = "\u5220\u9664\u6a21\u677f\uff1a\u3010";
            List<PmsProjectTemplateVO> templateVOS = this.pmsProjectTemplateDAO.queryByKeys(keys);
            for (PmsProjectTemplateVO templateVO : templateVOS) {
                String templateStatus = templateVO.getTemplateStatus();
                if (!templateStatus.equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u6682\u6302\u72b6\u6001\u4e0b\u7684\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                content = (String)content + templateVO.getTemplateName() + "\u3011,\u3010";
            }
            this.pmsProjectTemplateDAO.deleteSoft(keys);
            ComLogPayload logPayload = new ComLogPayload();
            logPayload.setObjectId("");
            logPayload.setLogType(ComLogTypeEnum.pms_project_template.getCode());
            content = ((String)content).substring(0, ((String)content).length() - 2);
            logPayload.setLogContent((String)content);
            this.logService.insert(logPayload);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateStatus(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsProjectTemplateVO> templateVOS = this.pmsProjectTemplateDAO.queryByKeys(keys);
            if (ObjectUtils.isEmpty(templateVOS)) {
                throw TwException.error("", "\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            List collect = templateVOS.stream().map(PmsProjectTemplateVO::getTemplateStatus).distinct().collect(Collectors.toList());
            if (collect.size() > 1) {
                throw TwException.error("", "\u76f8\u540c\u6570\u636e\u72b6\u6001\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            String templateStatus = (String)collect.get(0);
            String templateStatusNew = templateStatus.equals(WorkFlowStatusEnum.PENDING_WORK.getCode()) ? WorkFlowStatusEnum.APPROVED_WORK.getCode() : WorkFlowStatusEnum.PENDING_WORK.getCode();
            return this.pmsProjectTemplateDAO.updateStatus(keys, templateStatusNew);
        }
        throw TwException.error("", "\u64cd\u4f5c\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    public PmsProjectTemplateServiceImpl(PmsProjectTemplateRepo pmsProjectTemplateRepo, PmsProjectTemplateDAO pmsProjectTemplateDAO, CacheUtil cacheUtil, ComLogService logService) {
        this.pmsProjectTemplateRepo = pmsProjectTemplateRepo;
        this.pmsProjectTemplateDAO = pmsProjectTemplateDAO;
        this.cacheUtil = cacheUtil;
        this.logService = logService;
    }
}

