/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectWbsDataPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectWbsPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsActCostPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsActPayPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsLogQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectWbsService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsActCostVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsActPayVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComChangeTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.common.util.ChangeFieldUtil;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectWbsConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsActCostConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsActPayConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectWbsDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsActCostDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsActPayDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectWbsDO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsActCostDO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsActPayDO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectWbsServiceImpl
extends BaseServiceImpl
implements PmsProjectWbsService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectWbsServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PmsProjectWbsDAO pmsProjectWbsDAO;
    private final PmsWbsActCostDAO pmsWbsActCostDAO;
    private final PmsWbsActPayDAO pmsWbsActPayDAO;
    private final ComLogService logService;
    private final ComChangeService changeService;
    private final PmsProjectDAO pmsProjectDAO;
    private final ChangeFieldUtil changeFieldUtil;

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsVO batchInsertOrUpdate(PmsProjectWbsDataPayload payload) {
        this.checkWbsData(payload);
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(payload.getProjectId());
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error("", "\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List wbsPayloads = payload.getWbsPayloads();
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryByProjectId(payload.getProjectId());
        if (payload.getIsTempCreate().booleanValue() && !ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
            List collect = pmsProjectWbsVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            payload.setDelWbsIds(collect);
        }
        ArrayList<ComLogPayload> logPayloads = new ArrayList<ComLogPayload>();
        if (!ObjectUtils.isEmpty((Object)payload.getDelWbsIds())) {
            List<PmsProjectWbsVO> collect = pmsProjectWbsVOS.stream().filter(wbsVO -> payload.getDelWbsIds().contains(wbsVO.getId())).collect(Collectors.toList());
            this.createWbsDelLog(logPayloads, collect);
            this.pmsProjectWbsDAO.deleteSoft(payload.getDelWbsIds());
            this.pmsWbsActCostDAO.deleteSoftByWbsIds(payload.getDelWbsIds());
            this.pmsWbsActPayDAO.deleteSoftByWbsIds(payload.getDelWbsIds());
            pmsProjectWbsVOS.removeAll(collect);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getWbsPayloads())) {
            this.checkWbs(wbsPayloads, pmsProjectWbsVOS);
            String lastFourDigits = String.format("%04d", System.currentTimeMillis() % 10000L);
            wbsPayloads.forEach(wbsPayload -> {
                wbsPayload.setProjectId(payload.getProjectId());
                if (wbsPayload.getId() == null) {
                    Random random = new Random();
                    int s = random.nextInt(99) % 90 + 10;
                    wbsPayload.setNodeCode(pmsProjectVO.getProjectCode() + "-" + wbsPayload.getWbsType() + "-" + lastFourDigits + s);
                }
                if (StringUtils.hasText((String)wbsPayload.getParentWbsCode())) {
                    Optional<PmsProjectWbsPayload> payload1 = wbsPayloads.stream().filter(load -> load.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                    if (payload1.isPresent()) {
                        wbsPayload.setParentWbsName(payload1.get().getWbsName());
                    } else {
                        Optional<PmsProjectWbsVO> vo1 = pmsProjectWbsVOS.stream().filter(vo -> vo.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                        if (vo1.isPresent()) {
                            wbsPayload.setParentWbsName(vo1.get().getWbsName());
                        }
                    }
                }
            });
            List<PmsProjectWbsPayload> updatePayloads = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getId() != null).collect(Collectors.toList());
            List<Long> updateIds = this.createWbsUpdateLog(logPayloads, pmsProjectWbsVOS, updatePayloads);
            List<PmsProjectWbsDO> entityDos = wbsPayloads.stream().map(e -> {
                PmsProjectWbsDO wbsDO = PmsProjectWbsConvert.INSTANCE.toDo((PmsProjectWbsPayload)e);
                e.setWbsDO((BaseModel)wbsDO);
                return wbsDO;
            }).collect(Collectors.toList());
            List<PmsProjectWbsDO> pmsProjectWbsDOS = this.pmsProjectWbsDAO.saveAll(entityDos);
            ArrayList<PmsProjectWbsPayload> addPayloads = new ArrayList<PmsProjectWbsPayload>();
            wbsPayloads.forEach(wbsPayload -> {
                wbsPayload.setId(wbsPayload.getWbsDO().getId());
                if (!updateIds.contains(wbsPayload.getId())) {
                    addPayloads.add((PmsProjectWbsPayload)wbsPayload);
                }
            });
            this.createWbsAddLog(logPayloads, addPayloads);
            List<PmsProjectWbsPayload> act = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getWbsType().equals("ACT")).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(act)) {
                List<Object> pmsWbsActCostVOS = this.pmsWbsActCostDAO.queryByProjectId(payload.getProjectId());
                List<Object> pmsWbsActPayVOS = this.pmsWbsActPayDAO.queryByProjectId(payload.getProjectId());
                ArrayList<Long> delActCostIds = new ArrayList<Long>();
                ArrayList<Long> delActPayIds = new ArrayList<Long>();
                for (PmsProjectWbsPayload wbsPayload2 : act) {
                    if (!ObjectUtils.isEmpty((Object)wbsPayload2.getDelActCostIds())) {
                        delActCostIds.addAll(wbsPayload2.getDelActCostIds());
                    }
                    if (!ObjectUtils.isEmpty((Object)wbsPayload2.getDelActPayIds())) {
                        delActPayIds.addAll(wbsPayload2.getDelActPayIds());
                    }
                    if (!ObjectUtils.isEmpty((Object)wbsPayload2.getDelActCostIds()) || !ObjectUtils.isEmpty((Object)wbsPayload2.getActCostPayloads())) {
                        this.operActCostLog(logPayloads, wbsPayload2, pmsWbsActCostVOS);
                    }
                    if (ObjectUtils.isEmpty((Object)wbsPayload2.getDelActPayIds()) && ObjectUtils.isEmpty((Object)wbsPayload2.getActPayPayloads())) continue;
                    this.operActPayLog(logPayloads, wbsPayload2, pmsWbsActPayVOS);
                }
                if (delActCostIds.size() > 0) {
                    this.pmsWbsActCostDAO.deleteSoft(delActCostIds);
                    pmsWbsActCostVOS = pmsWbsActCostVOS.stream().filter(costVO -> !delActCostIds.contains(costVO.getId())).collect(Collectors.toList());
                }
                if (delActPayIds.size() > 0) {
                    this.pmsWbsActPayDAO.deleteSoft(delActPayIds);
                    pmsWbsActPayVOS = pmsWbsActPayVOS.stream().filter(payVO -> !delActPayIds.contains(payVO.getId())).collect(Collectors.toList());
                }
                ArrayList<PmsWbsActCostPayload> actCostPayloads = new ArrayList<PmsWbsActCostPayload>();
                ArrayList<PmsWbsActPayPayload> actPayPayloads = new ArrayList<PmsWbsActPayPayload>();
                this.checkWbsAct(act, pmsProjectWbsDOS, actCostPayloads, actPayPayloads, payload.getProjectId(), pmsWbsActCostVOS, pmsWbsActPayVOS);
                if (actCostPayloads.size() > 0) {
                    List<PmsWbsActCostDO> pmsWbsActCostDOS = PmsWbsActCostConvert.INSTANCE.toDoList(actCostPayloads);
                    this.pmsWbsActCostDAO.saveAll(pmsWbsActCostDOS);
                }
                if (actPayPayloads.size() > 0) {
                    List<PmsWbsActPayDO> pmsWbsActPayDOS = PmsWbsActPayConvert.INSTANCE.toDoList(actPayPayloads);
                    this.pmsWbsActPayDAO.saveAll(pmsWbsActPayDOS);
                }
            }
        }
        if (logPayloads.size() > 0) {
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setChangeContent("\u9879\u76eewbs\u53d8\u66f4");
            changePayload.setChangeDocId("" + payload.getProjectId());
            changePayload.setChangeType(ComChangeTypeEnum.PMS_PROJECT_WBS.getCode());
            changePayload.setCreator(GlobalUtil.getLoginUserName());
            ComChangeVO insert = this.changeService.insert(changePayload);
            String vid = payload.getProjectId() + "-" + insert.getVersionNo();
            logPayloads.forEach(log -> log.setExtString1(vid));
            this.logService.insertBacth(logPayloads);
        }
        return null;
    }

    void operActCostLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActCostVO> pmsWbsActCostVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals("" + wbsPayload.getId())).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            logPayload.setObjectId("" + wbsPayload.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("\u6210\u672c\u4f30\u8ba1:");
        builder.append("\n");
        List<Object> dels = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)wbsPayload.getDelActCostIds())) {
            dels = pmsWbsActCostVOS.stream().filter(wbsVO -> wbsPayload.getDelActCostIds().contains(wbsVO.getId())).map(PmsWbsActCostVO::getCostName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("\u5220\u9664");
            for (int i = 0; i < dels.size(); ++i) {
                if (i == 0) {
                    builder.append("\u3010" + (String)dels.get(i) + "\u3011");
                    continue;
                }
                builder.append(",\u3010" + (String)dels.get(i) + "\u3011");
            }
        }
        List actCostPayloads = wbsPayload.getActCostPayloads();
        List<Object> adds = new ArrayList();
        List<Object> updates = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)actCostPayloads)) {
            adds = actCostPayloads.stream().filter(actCost -> actCost.getId() == null).collect(Collectors.toList());
            updates = actCostPayloads.stream().filter(actCost -> actCost.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("\u6210\u672c\u8981\u7d20-\u6210\u672c\u4f30\u8ba1 \u521b\u5efa\u4e3a");
            builder.append("\n");
            for (PmsWbsActCostPayload pmsWbsActCostPayload : adds) {
                builder.append(pmsWbsActCostPayload.getCostName() + "-" + pmsWbsActCostPayload.getCostEstimate());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("\u6210\u672c\u8981\u7d20-\u6210\u672c\u4f30\u8ba1");
            builder.append("\n");
            for (PmsWbsActCostPayload pmsWbsActCostPayload : updates) {
                PmsWbsActCostVO pmsWbsActCostVO;
                Optional<PmsWbsActCostVO> firstCost = pmsWbsActCostVOS.stream().filter(actCost -> actCost.getId().equals(up.getId())).findFirst();
                if (!firstCost.isPresent() || (pmsWbsActCostVO = firstCost.get()).getCostName().equals(pmsWbsActCostPayload.getCostName()) && pmsWbsActCostVO.getCostEstimate().equals(pmsWbsActCostPayload.getCostEstimate())) continue;
                String str = pmsWbsActCostVO.getCostName() + "-" + pmsWbsActCostVO.getCostEstimate() + "\u66f4\u65b0\u4e3a" + pmsWbsActCostPayload.getCostName() + "-" + pmsWbsActCostPayload.getCostEstimate();
                builder.append(str);
                builder.append("\n");
            }
        }
        logPayload.setLogContent(builder.toString());
    }

    void operActPayLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals("" + wbsPayload.getId())).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            logPayload.setObjectId("" + wbsPayload.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("\u4ea4\u4ed8\u7269:");
        builder.append("\n");
        List<Object> dels = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)wbsPayload.getDelActPayIds())) {
            dels = pmsWbsActPayVOS.stream().filter(wbsVO -> wbsPayload.getDelActPayIds().contains(wbsVO.getId())).map(PmsWbsActPayVO::getPayName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("\u5220\u9664");
            for (int i = 0; i < dels.size(); ++i) {
                if (i == 0) {
                    builder.append("\u3010" + (String)dels.get(i) + "\u3011");
                    continue;
                }
                builder.append(",\u3010" + (String)dels.get(i) + "\u3011");
            }
        }
        List actPayPayloads = wbsPayload.getActPayPayloads();
        List<Object> adds = new ArrayList();
        List<Object> updates = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)actPayPayloads)) {
            adds = actPayPayloads.stream().filter(actPay -> actPay.getId() == null).collect(Collectors.toList());
            updates = actPayPayloads.stream().filter(actPay -> actPay.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("\u4ea4\u4ed8\u7269\u540d\u79f0-\u4ea4\u4ed8\u7269\u7c7b\u578b \u521b\u5efa\u4e3a");
            builder.append("\n");
            for (PmsWbsActPayPayload pmsWbsActPayPayload : adds) {
                builder.append(pmsWbsActPayPayload.getPayName() + "-" + pmsWbsActPayPayload.getPayTypeName());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("\u4ea4\u4ed8\u7269\u540d\u79f0-\u4ea4\u4ed8\u7269\u7c7b\u578b");
            builder.append("\n");
            for (PmsWbsActPayPayload pmsWbsActPayPayload : updates) {
                PmsWbsActPayVO pmsWbsActPayVO;
                Optional<PmsWbsActPayVO> firstPay = pmsWbsActPayVOS.stream().filter(actPay -> actPay.getId().equals(up.getId())).findFirst();
                if (!firstPay.isPresent() || (pmsWbsActPayVO = firstPay.get()).getPayName().equals(pmsWbsActPayPayload.getPayName()) && pmsWbsActPayVO.getPayTypeName().equals(pmsWbsActPayPayload.getPayTypeName())) continue;
                String str = pmsWbsActPayVO.getPayName() + "-" + pmsWbsActPayVO.getPayTypeName() + "\u66f4\u65b0\u4e3a" + pmsWbsActPayPayload.getPayName() + "-" + pmsWbsActPayPayload.getPayTypeName();
                builder.append(str);
                builder.append("\n");
            }
        }
        logPayload.setLogContent(builder.toString());
    }

    void createWbsAddLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsPayload> wbsPayloads) {
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                String fieldsCreateLog = this.changeFieldUtil.getFieldsCreateLog(wbsPayload, null);
                ComLogPayload logPayload = new ComLogPayload();
                logPayload.setObjectId("" + wbsPayload.getId());
                logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
                logPayload.setExtString2(wbsPayload.getWbsType());
                logPayload.setExtString3("CREATE");
                logPayload.setLogContent(fieldsCreateLog);
                logPayloads.add(logPayload);
            });
        }
    }

    List<Long> createWbsUpdateLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> wbsVOS, List<PmsProjectWbsPayload> wbsPayloads) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                Optional<PmsProjectWbsVO> first;
                ids.add(wbsPayload.getId());
                if (!ObjectUtils.isEmpty((Object)wbsVOS) && (first = wbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(wbsPayload.getId())).findFirst()).isPresent()) {
                    PmsProjectWbsVO pmsProjectWbsVO = first.get();
                    PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                    this.transferData(pmsProjectWbsPayload);
                    String fieldsUpdateLog = this.changeFieldUtil.getFieldsUpdateLog(wbsPayload, pmsProjectWbsPayload);
                    if (StringUtils.hasText((String)fieldsUpdateLog)) {
                        ComLogPayload logPayload = new ComLogPayload();
                        logPayload.setObjectId("" + wbsPayload.getId());
                        logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
                        logPayload.setExtString2(wbsPayload.getWbsType());
                        logPayload.setExtString3("UPDATE");
                        logPayload.setLogContent(fieldsUpdateLog);
                        logPayloads.add(logPayload);
                    }
                }
            });
        }
        return ids;
    }

    void createWbsDelLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> collect) {
        collect.forEach(wbsVO -> {
            ComLogPayload logPayload = new ComLogPayload();
            logPayload.setObjectId("" + wbsVO.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setLogContent("\u8282\u70b9\u3010" + wbsVO.getWbsName() + "\u3011\u88ab\u5220\u9664");
            logPayload.setExtString2(wbsVO.getWbsType());
            logPayload.setExtString3("DEL");
            logPayloads.add(logPayload);
        });
    }

    public List<PmsProjectWbsVO> queryList(PmsProjectWbsQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getProjectId())) {
            throw TwException.error("", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListDynamic(query);
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> this.transferData((PmsProjectWbsVO)pmsProjectWbsVO));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        return pmsProjectWbsVOS;
    }

    public PmsProjectWbsVO queryByKey(Long key) {
        PmsProjectWbsVO pmsProjectWbsVO = this.pmsProjectWbsDAO.queryByKey(key);
        if (pmsProjectWbsVO.getWbsType().equals("ACT")) {
            List<PmsWbsActCostVO> pmsWbsActCostVOS = this.pmsWbsActCostDAO.queryByWbsId(key);
            List<PmsWbsActPayVO> pmsWbsActPayVOS = this.pmsWbsActPayDAO.queryByWbsId(key);
            pmsProjectWbsVO.setActCostVOs(pmsWbsActCostVOS);
            pmsProjectWbsVO.setActPayVOs(pmsWbsActPayVOS);
        }
        this.transferData(pmsProjectWbsVO);
        return pmsProjectWbsVO;
    }

    void transferData(PmsProjectWbsVO vo) {
        vo.setActCostTypeName(this.cacheUtil.transferSystemSelection("PMS:WBS:ACT_COST:TYPE", vo.getActCostType()));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectWbsDAO.deleteSoft(keys);
            this.pmsWbsActCostDAO.deleteSoftByWbsIds(keys);
            this.pmsWbsActPayDAO.deleteSoftByWbsIds(keys);
        }
    }

    public List<ComLogVO> queryLogList(PmsProjectWbsLogQuery query) {
        if (query.getProjectId() != null && query.getVersionNo() != null || query.getWbsId() != null) {
            ComLogQuery logQuery = new ComLogQuery();
            logQuery.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logQuery.setLogContent(query.getLogContent());
            if (query.getProjectId() != null && query.getVersionNo() != null) {
                String vid = query.getProjectId() + "-" + query.getVersionNo();
                logQuery.setExtString1(vid);
            } else {
                logQuery.setObjectId("" + query.getWbsId());
            }
            if (StringUtils.hasText((String)query.getOperType())) {
                logQuery.setExtString3(query.getOperType());
            }
            if (StringUtils.hasText((String)query.getWbsType())) {
                logQuery.setExtString2(query.getWbsType());
            }
            return this.logService.queryList(logQuery);
        }
        throw TwException.error("", "\u67e5\u8be2\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    void checkWbsAct(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsDO> pmsProjectWbsDOS, List<PmsWbsActCostPayload> actCostPayloads, List<PmsWbsActPayPayload> actPayPayloads, Long projectId, List<PmsWbsActCostVO> pmsWbsActCostVOS, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        boolean haveCost = !ObjectUtils.isEmpty(pmsWbsActCostVOS);
        boolean havePay = !ObjectUtils.isEmpty(pmsWbsActPayVOS);
        for (PmsProjectWbsPayload wbsPayload : wbsPayloads) {
            List collect;
            List costPayloads = wbsPayload.getActCostPayloads();
            List payloads = wbsPayload.getActPayPayloads();
            if (ObjectUtils.isEmpty((Object)costPayloads) && ObjectUtils.isEmpty((Object)payloads)) continue;
            Optional<PmsProjectWbsDO> first = pmsProjectWbsDOS.stream().filter(wbsDO -> wbsDO.getWbsCode().equals(wbsPayload.getWbsCode())).findFirst();
            PmsProjectWbsDO pmsProjectWbsDO = first.get();
            if (!ObjectUtils.isEmpty((Object)costPayloads)) {
                collect = costPayloads.stream().map(PmsWbsActCostPayload::getCostName).distinct().collect(Collectors.toList());
                if (costPayloads.size() != collect.size()) {
                    throw TwException.error("", "\u3010" + pmsProjectWbsDO.getWbsName() + "\u3011\u6d3b\u52a8\u63cf\u8ff0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                costPayloads.forEach(costPayload -> {
                    costPayload.setProjectId(projectId);
                    costPayload.setWbsId(pmsProjectWbsDO.getId());
                    costPayload.setWbsName(pmsProjectWbsDO.getWbsName());
                });
                actCostPayloads.addAll(costPayloads);
            }
            if (ObjectUtils.isEmpty((Object)payloads)) continue;
            collect = payloads.stream().map(PmsWbsActPayPayload::getPayName).distinct().collect(Collectors.toList());
            if (payloads.size() != collect.size()) {
                throw TwException.error("", "\u3010" + pmsProjectWbsDO.getWbsName() + "\u3011\u76ee\u6807\u4ea4\u4ed8\u7269\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            payloads.forEach(payPayload -> {
                payPayload.setProjectId(projectId);
                payPayload.setWbsId(pmsProjectWbsDO.getId());
                payPayload.setWbsName(pmsProjectWbsDO.getWbsName());
            });
            actPayPayloads.addAll(payloads);
        }
    }

    void checkWbs(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsVO> pmsProjectWbsVOS) {
        boolean isHave;
        List collect = wbsPayloads.stream().map(PmsProjectWbsPayload::getWbsName).distinct().collect(Collectors.toList());
        if (wbsPayloads.size() != collect.size()) {
            throw TwException.error("", "\u8282\u70b9\u63cf\u8ff0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List collect0 = wbsPayloads.stream().map(PmsProjectWbsPayload::getWbsCode).distinct().collect(Collectors.toList());
        if (wbsPayloads.size() != collect0.size()) {
            throw TwException.error("", "wbs\u7f16\u7801\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        boolean bl = isHave = !ObjectUtils.isEmpty(pmsProjectWbsVOS);
        if (isHave) {
            pmsProjectWbsVOS.forEach(wbsVO -> {
                Optional<PmsProjectWbsVO> vo1 = pmsProjectWbsVOS.stream().filter(load -> load.getWbsCode().equals(wbsVO.getParentWbsCode())).findFirst();
                if (vo1.isPresent()) {
                    wbsVO.setParentWbsName(vo1.get().getWbsName());
                }
            });
        }
        wbsPayloads.forEach(entityDo -> {
            if (ObjectUtils.isEmpty((Object)entityDo.getWbsCode())) {
                throw TwException.error("", "wbs\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)entityDo.getWbsType())) {
                throw TwException.error("", "wbs\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)entityDo.getParentWbsCode())) {
                if (!entityDo.getWbsType().equals("WBS") && !entityDo.getWbsType().equals("NET")) {
                    throw TwException.error("", "\u4e00\u7ea7\u8282\u70b9\u53ea\u53ef\u65b0\u5efa\u201cWBS\u5143\u7d20\u201d\u548c\u201c\u7f51\u7edc\u201d\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            } else {
                Optional<PmsProjectWbsPayload> first = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getWbsCode().equals(entityDo.getParentWbsCode())).findFirst();
                String parentWbsType = "";
                if (first.isPresent()) {
                    parentWbsType = first.get().getWbsType();
                } else {
                    Optional<PmsProjectWbsVO> first0 = pmsProjectWbsVOS.stream().filter(wbsPayload -> wbsPayload.getWbsCode().equals(entityDo.getParentWbsCode())).findFirst();
                    if (first0.isPresent()) {
                        parentWbsType = first0.get().getWbsType();
                    } else {
                        throw TwException.error("", entityDo.getParentWbsCode() + "\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                }
                if (entityDo.getWbsType().equals("WBS") && !parentWbsType.equals("WBS")) {
                    throw TwException.error("", "WBS\u5143\u7d20\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (entityDo.getWbsType().equals("NET") && !parentWbsType.equals("WBS")) {
                    throw TwException.error("", "\u7f51\u7edc\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (entityDo.getWbsType().equals("ACT") && !parentWbsType.equals("WBS") && !parentWbsType.equals("NET")) {
                    throw TwException.error("", "\u6d3b\u52a8\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\u6216\u7f51\u7edc\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (entityDo.getWbsType().equals("MS") && !parentWbsType.equals("WBS") && !parentWbsType.equals("NET")) {
                    throw TwException.error("", "\u6d3b\u52a8\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\u6216\u7f51\u7edc\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            }
            this.transferData((PmsProjectWbsPayload)entityDo);
        });
    }

    void transferData(PmsProjectWbsPayload vo) {
        vo.setActCostTypeName(this.cacheUtil.transferSystemSelection("PMS:WBS:ACT_COST:TYPE", vo.getActCostType()));
        String wbsTypeName = vo.getWbsType().equals("WBS") ? "WBS\u5143\u7d20" : (vo.getWbsType().equals("NET") ? "\u7f51\u7edc" : (vo.getWbsType().equals("ACT") ? "\u6d3b\u52a8" : "\u91cc\u7a0b\u7891"));
        vo.setWbsTypeName(wbsTypeName);
        if (vo.getInvoiceAttr() != null) {
            vo.setInvoiceAttrName(vo.getInvoiceAttr() == 0 ? "\u53d6\u6d88\u52fe\u9009" : "\u52fe\u9009");
        }
        if (vo.getCostPlan() != null) {
            vo.setCostPlanName(vo.getCostPlan() == 0 ? "\u53d6\u6d88\u52fe\u9009" : "\u52fe\u9009");
        }
        if (vo.getSubjectDist() != null) {
            vo.setSubjectDistName(vo.getSubjectDist() == 0 ? "\u53d6\u6d88\u52fe\u9009" : "\u52fe\u9009");
        }
    }

    void checkWbsData(PmsProjectWbsDataPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error("", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    public PmsProjectWbsServiceImpl(CacheUtil cacheUtil, PmsProjectWbsDAO pmsProjectWbsDAO, PmsWbsActCostDAO pmsWbsActCostDAO, PmsWbsActPayDAO pmsWbsActPayDAO, ComLogService logService, ComChangeService changeService, PmsProjectDAO pmsProjectDAO, ChangeFieldUtil changeFieldUtil) {
        this.cacheUtil = cacheUtil;
        this.pmsProjectWbsDAO = pmsProjectWbsDAO;
        this.pmsWbsActCostDAO = pmsWbsActCostDAO;
        this.pmsWbsActPayDAO = pmsWbsActPayDAO;
        this.logService = logService;
        this.changeService = changeService;
        this.pmsProjectDAO = pmsProjectDAO;
        this.changeFieldUtil = changeFieldUtil;
    }
}

