/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsTemplateNodePayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsTemplatePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsWbsTemplateQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsWbsTemplateService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsTemplateNodeVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsTemplateVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsTemplateConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsWbsTemplateNodeConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsTemplateDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsWbsTemplateNodeDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsTemplateDO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsTemplateNodeDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsWbsTemplateRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsWbsTemplateServiceImpl
extends BaseServiceImpl
implements PmsWbsTemplateService {
    private static final Logger log = LoggerFactory.getLogger(PmsWbsTemplateServiceImpl.class);
    private final PmsWbsTemplateRepo pmsWbsTemplateRepo;
    private final PmsWbsTemplateDAO pmsWbsTemplateDAO;
    private final PmsWbsTemplateNodeDAO pmsWbsTemplateNodeDAO;
    private final CacheUtil cacheUtil;

    public PagingVO<PmsWbsTemplateVO> paging(PmsWbsTemplateQuery query) {
        Page page = this.pmsWbsTemplateRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(PmsWbsTemplateConvert.INSTANCE::toVo));
    }

    void transferData(PmsWbsTemplateVO vo) {
        vo.setSuitProjectType(vo.getSuitProjectType().substring(1, vo.getSuitProjectType().length() - 1));
        String[] split = vo.getSuitProjectType().split(",");
        StringBuilder temp = new StringBuilder();
        for (String s : split) {
            temp.append(this.cacheUtil.transferSystemSelection("PMS:PROJECT:TYPE", s)).append(",");
        }
        temp = new StringBuilder(temp.substring(0, temp.length() - 1));
        vo.setSuitProjectTypeNames(temp.toString());
        Long key = vo.getId();
        List<PmsWbsTemplateNodeVO> pmsWbsTemplateNodeVOS = this.pmsWbsTemplateNodeDAO.queryByTemplateIds(List.of(key));
        vo.setNodes(pmsWbsTemplateNodeVOS);
    }

    public PagingVO<PmsWbsTemplateVO> queryPaging(PmsWbsTemplateQuery query) {
        PagingVO<PmsWbsTemplateVO> pagingVO = this.pmsWbsTemplateDAO.queryPaging(query);
        pagingVO.getRecords().forEach(this::transferData);
        return pagingVO;
    }

    public List<PmsWbsTemplateVO> queryList(PmsWbsTemplateQuery query) {
        return PmsWbsTemplateConvert.INSTANCE.toVoList(this.pmsWbsTemplateRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<PmsWbsTemplateVO> queryListDynamic(PmsWbsTemplateQuery query) {
        return this.pmsWbsTemplateDAO.queryListDynamic(query);
    }

    public PmsWbsTemplateVO queryByKey(Long key) {
        PmsWbsTemplateDO entity = this.pmsWbsTemplateRepo.findById(key).orElseGet(PmsWbsTemplateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsWbsTemplateVO vo = PmsWbsTemplateConvert.INSTANCE.toVo(entity);
        List<PmsWbsTemplateNodeVO> pmsWbsTemplateNodeVOS = this.pmsWbsTemplateNodeDAO.queryByTemplateIds(List.of(key));
        vo.setNodes(pmsWbsTemplateNodeVOS);
        this.transferData(vo);
        vo.getNodes().sort(Comparator.comparing(PmsWbsTemplateNodeVO::getWbsCode));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsWbsTemplateVO insert(PmsWbsTemplatePayload payload) {
        this.checkData(payload);
        if (this.pmsWbsTemplateDAO.queryByName(payload)) {
            throw TwException.error("", "\u5df2\u5b58\u5728\uff01");
        }
        payload.setSuitProjectType("," + payload.getSuitProjectType() + ",");
        PmsWbsTemplateDO entityDo = PmsWbsTemplateConvert.INSTANCE.toDo(payload);
        this.pmsWbsTemplateDAO.save(entityDo);
        Long id = entityDo.getId();
        this.setNodeCode(payload, entityDo, id);
        return PmsWbsTemplateConvert.INSTANCE.toVo(entityDo);
    }

    private void setNodeCode(PmsWbsTemplatePayload payload, PmsWbsTemplateDO entity, Long id) {
        List nodes = payload.getNodes();
        ArrayList<PmsWbsTemplateNodeDO> dNodes = new ArrayList<PmsWbsTemplateNodeDO>();
        nodes.forEach(node -> {
            node.setTemplateId(id);
            node.setNodeCode("TEMP-[" + id + "]-" + node.getWbsType() + "-" + node.getWbsCode());
            dNodes.add(PmsWbsTemplateNodeConvert.INSTANCE.toDo((PmsWbsTemplateNodePayload)node));
        });
        this.checkTemplateNode(payload.getNodes(), PmsWbsTemplateConvert.INSTANCE.toVo(entity).getNodes());
        this.pmsWbsTemplateNodeDAO.saveAll(dNodes);
    }

    void checkData(PmsWbsTemplatePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getTemplateName()) || ObjectUtils.isEmpty((Object)payload.getSuitProjectType()) || ObjectUtils.isEmpty((Object)payload.getTemplateStatus())) {
            throw TwException.error("", "\u8bf7\u5b8c\u5584\u6807 * \u7684\u76f8\u5173\u4fe1\u606f");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsWbsTemplateVO update(PmsWbsTemplatePayload payload) {
        this.checkData(payload);
        PmsWbsTemplateDO entity = this.pmsWbsTemplateRepo.findById(payload.getId()).orElseGet(PmsWbsTemplateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        payload.setSuitProjectType("," + payload.getSuitProjectType() + ",");
        PmsWbsTemplateDO entityDo = PmsWbsTemplateConvert.INSTANCE.toDo(payload);
        Long id = entityDo.getId();
        this.pmsWbsTemplateNodeDAO.deleteSoftByTemplateId(id);
        this.setNodeCode(payload, entity, id);
        entity.copy(entityDo);
        return PmsWbsTemplateConvert.INSTANCE.toVo((PmsWbsTemplateDO)this.pmsWbsTemplateRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsWbsTemplateVO> pmsWbsTemplateVOS = this.pmsWbsTemplateDAO.queryByKeys(keys);
            for (PmsWbsTemplateVO pmsWbsTemplateVO : pmsWbsTemplateVOS) {
                String templateStatus = pmsWbsTemplateVO.getTemplateStatus();
                if (!templateStatus.equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) continue;
                throw TwException.error("", "\u6fc0\u6d3b\u72b6\u6001\u7684\u6a21\u7248\u4e0d\u53ef\u5220\u9664");
            }
            this.pmsWbsTemplateDAO.deleteSoft(keys);
            this.pmsWbsTemplateNodeDAO.deleteSoftByTemplateIds(keys);
        }
    }

    @Transactional
    public Long updateStatus(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsWbsTemplateVO> pmsWbsTemplateVOS = this.pmsWbsTemplateDAO.queryByKeys(keys);
            if (ObjectUtils.isEmpty(pmsWbsTemplateVOS)) {
                throw TwException.error("", "\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            List collect = pmsWbsTemplateVOS.stream().map(PmsWbsTemplateVO::getTemplateStatus).distinct().collect(Collectors.toList());
            if (collect.size() > 1) {
                throw TwException.error("", "\u76f8\u540c\u6570\u636e\u72b6\u6001\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            String templateStatus = (String)collect.get(0);
            String templateStatusNew = templateStatus.equals("0") ? "1" : "0";
            return this.pmsWbsTemplateDAO.updateStatus(keys, templateStatusNew);
        }
        throw TwException.error("", "\u64cd\u4f5c\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    void checkTemplateNode(List<PmsWbsTemplateNodePayload> templateNodePayload, List<PmsWbsTemplateNodeVO> templateNodeVOS) {
        List collect = templateNodePayload.stream().map(PmsWbsTemplateNodePayload::getWbsName).distinct().collect(Collectors.toList());
        if (templateNodePayload.size() != collect.size()) {
            throw TwException.error("", "\u8282\u70b9\u63cf\u8ff0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List collect0 = templateNodePayload.stream().map(PmsWbsTemplateNodePayload::getWbsCode).distinct().collect(Collectors.toList());
        if (templateNodePayload.size() != collect0.size()) {
            throw TwException.error("", "wbs\u7f16\u7801\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        templateNodePayload.forEach(entityDo -> {
            PmsWbsTemplateNodeVO first;
            if (ObjectUtils.isEmpty((Object)entityDo.getWbsCode())) {
                throw TwException.error("", "wbs\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)entityDo.getWbsType())) {
                throw TwException.error("", "wbs\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)entityDo.getParentWbsCode())) {
                if (!entityDo.getWbsType().equals("WBS") && !entityDo.getWbsType().equals("NET")) {
                    throw TwException.error("", "\u4e00\u7ea7\u8282\u70b9\u53ea\u53ef\u65b0\u5efa\u201cWBS\u5143\u7d20\u201d\u548c\u201c\u7f51\u7edc\u201d\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            } else {
                first = templateNodePayload.stream().filter(wbsPayload -> wbsPayload.getWbsCode().equals(entityDo.getParentWbsCode())).findFirst();
                if (first.isPresent()) {
                    PmsWbsTemplateNodePayload parentWbsPayload = first.get();
                    if (entityDo.getWbsType().equals("WBS") && !parentWbsPayload.getWbsType().equals("WBS")) {
                        throw TwException.error("", "WBS\u5143\u7d20\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (entityDo.getWbsType().equals("NET") && !parentWbsPayload.getWbsType().equals("WBS")) {
                        throw TwException.error("", "\u7f51\u7edc\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (entityDo.getWbsType().equals("ACT") && !parentWbsPayload.getWbsType().equals("WBS") && !parentWbsPayload.getWbsType().equals("NET")) {
                        throw TwException.error("", "\u6d3b\u52a8\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\u6216\u7f51\u7edc\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (entityDo.getWbsType().equals("MS") && !parentWbsPayload.getWbsType().equals("WBS") && !parentWbsPayload.getWbsType().equals("NET")) {
                        throw TwException.error("", "\u91cc\u7a0b\u7891\u4e0a\u7ea7\u53ea\u80fd\u662fWBS\u5143\u7d20\u6216\u7f51\u7edc\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                } else {
                    throw TwException.error("", entityDo.getParentWbsCode() + "\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            }
            if (!ObjectUtils.isEmpty((Object)templateNodeVOS)) {
                first = null;
                PmsWbsTemplateNodeVO first0 = null;
                for (PmsWbsTemplateNodeVO wbsVO : templateNodeVOS) {
                    Optional<PmsWbsTemplateNodePayload> firstPayload = templateNodePayload.stream().filter(wbsPayload -> wbsPayload.getId().equals(wbsVO.getId())).findFirst();
                    if (firstPayload.isPresent()) {
                        wbsVO.setWbsCode(firstPayload.get().getWbsCode());
                        wbsVO.setWbsName(firstPayload.get().getWbsName());
                    }
                    if (wbsVO.getWbsCode().equals(entityDo.getWbsCode())) {
                        first = wbsVO;
                    }
                    if (!wbsVO.getWbsName().equals(entityDo.getWbsName())) continue;
                    first0 = wbsVO;
                }
                if (!(first == null || entityDo.getId() != null && first.getId().equals(entityDo.getId()))) {
                    throw TwException.error("", "\u3010" + entityDo.getWbsName() + "\u3011wbs\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (!(first0 == null || entityDo.getId() != null && first0.getId().equals(entityDo.getId()))) {
                    throw TwException.error("", "\u3010" + entityDo.getWbsName() + "\u3011\u8282\u70b9\u63cf\u8ff0\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            }
        });
    }

    public PmsWbsTemplateServiceImpl(PmsWbsTemplateRepo pmsWbsTemplateRepo, PmsWbsTemplateDAO pmsWbsTemplateDAO, PmsWbsTemplateNodeDAO pmsWbsTemplateNodeDAO, CacheUtil cacheUtil) {
        this.pmsWbsTemplateRepo = pmsWbsTemplateRepo;
        this.pmsWbsTemplateDAO = pmsWbsTemplateDAO;
        this.pmsWbsTemplateNodeDAO = pmsWbsTemplateNodeDAO;
        this.cacheUtil = cacheUtil;
    }
}

