/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.workflow;

import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPayload;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/PMS_PROJECT/callBack"})
@Transactional
public class PmsProjectCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectCallBackController.class);
    private final PmsProjectDAO pmsProjectDAO;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsProjectPayload PmsProjectPayload2 = new PmsProjectPayload();
        PmsProjectPayload2.setId(Long.valueOf(Long.parseLong(businessKey)));
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(Long.valueOf(businessKey));
        if (pmsProjectVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    PmsProjectPayload2.setProjectStatus(ProjectStatusEnum.CREATE.getCode());
                    PmsProjectPayload2.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    PmsProjectPayload2.setProjectStatus(ProjectStatusEnum.CREATE.getCode());
                    break;
                }
                case INVALID: {
                    PmsProjectPayload2.setProjectStatus(ProjectStatusEnum.TERMINATED.getCode());
                    PmsProjectPayload2.setDeleteFlag(Integer.valueOf(1));
                    PmsProjectPayload2.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    PmsProjectPayload2.setProjectStatus(ProjectStatusEnum.APPROVING_EJECTED.getCode());
                    PmsProjectPayload2.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    PmsProjectPayload2.setProjectStatus(ProjectStatusEnum.APPROVED.getCode());
                    PmsProjectPayload2.setProcInstStatus(ProcInstStatus.APPROVED);
                    PmsProjectPayload2.setApprovedTime(LocalDateTime.now());
                    break;
                }
            }
            this.pmsProjectDAO.updateWorkFlow(PmsProjectPayload2);
        }
    }

    public PmsProjectCallBackController(PmsProjectDAO pmsProjectDAO) {
        this.pmsProjectDAO = pmsProjectDAO;
    }
}

