package com.elitesland.tw.tw5.server;

import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * 项目启动类
 * https://nrp-dev.elitescloud.com:25543/login
 *
 * @author zhangyongqiang
 */
@SpringBootApplication(scanBasePackages = "com.elitesland")
@EntityScan("com.elitesland")
@EnableJpaRepositories("com.elitesland")
@EnableAsync
@Log4j2
@ServletComponentScan
public class Tw5ServerApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(Tw5ServerApplication.class)
                // .listeners(new ApplicationStartedEventListener())
                .run(args);
        log.info("【启动完成。。。】");
        log.info("\n" +
            "################################################################################################################################\n" +
            "################################################################################################################################\n" +
            "################################################################################################################################\n" +
            "##########################    ###########################                       ######################               ###########\n" +
            "############       ######       #########################                       #####################                      #####\n" +
            "###########       #######       #################      ##############################################                      #####\n" +
            "##########        ######               #########       ####                   ###########        ####                      #####\n" +
            "#########                              #########       ###                      ########          #####      ###       #########\n" +
            "#########                               ###########    ###      #########       #######            ####     ####       #########\n" +
            "########                                ##################                      ######      #       ###    #####       #########\n" +
            "########       ########        #################       ###############################      ##      ###     ####       #########\n" +
            "#######        ########        #################       ##                    #########      ###     ###      ###       #########\n" +
            "#######       #########        #################      ##                        ######      ###     ###                    #####\n" +
            "#########     #########        ################      ##        ##      ###       #####      ##      ###                    #####\n" +
            "#######################                 #######      ##                          #####      #       #####              #########\n" +
            "#########                                ######      ##                         ######             ####       ##       #########\n" +
            "#########                                ######      ##       ###      ###      #######           ####        ##       #########\n" +
            "#########                        ##############       ##                       ########          #####       ###       #########\n" +
            "#######################        ################                                ##########      ######        ###       #########\n" +
            "#######################        #################                       ##############################       ###         ########\n" +
            "#######################        ###################                     #############################        ##           #######\n" +
            "#########################      #################################################################################################\n" +
            "################################################################################################################################\n" +
            "################################################################################################################################\n" +
            "##################################  #########################   ################  ##############################################\n" +
            "##################################  #########################   ################  ##############################################\n" +
            "#############################################################   ################################################################\n" +
            "###############          #########  ########  ######   ######          #########  ########  #####   ##########        ##########\n" +
            "###############           ########  ########  ######   ######           ########  ########  #####   ########   ####   ##########\n" +
            "###############  #######  ########  ########  ######   ######   ######   #######  #########  ####   #######  #######  ##########\n" +
            "###############  #######  ########  ########   #####   ######   ####     #######  ##########   #   ########  #######  ##########\n" +
            "###############  #######  ########  ########    ###    ######   ##      ########  ##########      #########    ####   ##########\n" +
            "###############  ######  #########  ########           ######          #########  ############   ############          #########\n" +
            "#############################################################################################   ################################\n" +
            "############################################################################################   #################################\n" +
            "################################################################################################################################");
    }
}
