package com.elitesland.tw.tw5.server.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbAddressService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerDAO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 数据翻译
 */
@Service
@RequiredArgsConstructor
public class BusinessFollowServiceImpl {
    private final CacheUtil cacheUtil;
    private final TransferUtilDAO dao;
    private final CrmCustomerDAO daoCustomer;
    private final CrmLeadsService leadService;
    private final PrdAbAddressService serviceAbAddress;
    private final CrmOpportunityService opportunityService;
    private final HttpUtil httpUtil;

    /**
     * 获取线索数据
     *
     * @param query
     * @return
     */
    public PagingVO<CrmLeadsListVO> queryLeadsFollow(TwQueryParam query, Long customerId) {
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));

        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setCurrent(query.getCurrent());
        leadsQuery.setSize(query.getSize());
        leadsQuery.setFormalCustomerId(customerId);
        leadsQuery.setIsPermission(!rolePermission);

        return leadService.paging(leadsQuery);
    }


    /**
     * 获取商机数据
     *
     * @param query
     * @return
     */
    public PagingVO<CrmOpportunityVO> queryOppoFollow(TwQueryParam query, Long customerId) {
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
        CrmOpportunityQuery oppoQuery = new CrmOpportunityQuery();
        oppoQuery.setCurrent(query.getCurrent());
        oppoQuery.setSize(query.getSize());
        oppoQuery.setFormalCustomerId(customerId);
        oppoQuery.setIsPermission(!rolePermission);
        return opportunityService.paging(oppoQuery);
    }

    /**
     * 获取合同数量
     *
     * @param customerId
     * @return
     */
    public Object queryContractNum(Long customerId) {
        String url = "api/openReport/v1/sync/contractCount";
        PrdAbVO prdAbVO = daoCustomer.queryAbVOBykey(customerId);
        if (ObjectUtils.isEmpty(prdAbVO)) {
            throw TwException.error("", "关联客户数据不存在，请核验！");
        }
        ////获取4.0用户id
        //List<Long> longs = dao.queryEmployeeTw4Ids(List.of(GlobalUtil.getLoginUserId()));
        //Long userId4 = 0L;
        //if (!ObjectUtils.isEmpty(longs)) {
        //    userId4 = longs.get(0);
        //}
        //Map<String, Object> map = new HashMap<>();
        //map.put("bookId", prdAbVO.getBookIdV4());
        //map.put("userId", userId4);
        //String result = httpUtil.sendSyncGet(url, map);
        //Map<String, Object> data = (Map) JSON.parse(result);
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        return data.get("datum");
        //    }
        //}
        return 0;
    }

    /**
     * 获取项目数量
     *
     * @param customerId
     * @return
     */
    public Object queryProjectNum(Long customerId) {
        String url = "api/openReport/v1/sync/countProjectNumByCustId";
        PrdAbVO prdAbVO = daoCustomer.queryAbVOBykey(customerId);
        if (ObjectUtils.isEmpty(prdAbVO)) {
            throw TwException.error("", "关联客户数据不存在，请核验！");
        }
        //List<Long> longs = dao.queryEmployeeTw4Ids(List.of(GlobalUtil.getLoginUserId()));
        //Long userId4 = 0L;
        //if (!ObjectUtils.isEmpty(longs)) {
        //    userId4 = longs.get(0);
        //}
        //Map<String, Object> map = new HashMap<>();
        //map.put("bookId", prdAbVO.getBookIdV4());
        //map.put("userId", userId4);
        //String result = httpUtil.sendSyncGet(url, map);
        //Map<String, Object> data = (Map) JSON.parse(result);
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        return data.get("datum");
        //    }
        //}
        return 0;
    }

    /**
     * 获取4.0的合同数据
     *
     * @param query
     * @return
     */
    public Map<String, Object> queryContractFollow(TwQueryParam query, Long customerId) {

        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("total", 0);
        resultMap.put("records", new ArrayList<>());
        String url = "api/openReport/v1/sync/contract";
        PrdAbVO prdAbVO = daoCustomer.queryAbVOBykey(customerId);
        if (ObjectUtils.isEmpty(prdAbVO)) {
            throw TwException.error("", "关联客户数据不存在，请核验！");
        }
        //获取4.0用户id
        //List<Long> longs = dao.queryEmployeeTw4Ids(List.of(GlobalUtil.getLoginUserId()));
        //Long userId4 = 0L;
        //if (!ObjectUtils.isEmpty(longs)) {
        //    userId4 = longs.get(0);
        //}
        //Map<String, Object> map = new HashMap<>();
        //map.put("bookId", prdAbVO.getBookIdV4());
        //map.put("userId", userId4);
        //map.put("offset", query.getPageRequest().getOffset());
        //map.put("limit", query.getPageRequest().getPageSize());
        //String result = httpUtil.sendSyncGet(url, map);
        //Map<String, Object> data = (Map) JSON.parse(result);
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        Map<String, Object> datas = (Map<String, Object>) data.get("datum");
        //        resultMap.put("total", datas.get("total"));
        //        resultMap.put("records", datas.get("rows"));
        //    }
        //}
        return resultMap;
    }

}
