package com.elitesland.tw.tw5.server.common.util;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.SneakyThrows;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.*;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/25 - 18:35
 */
public class BeanUtil {
    /**
     * 获取非空属性
     * @param source
     * @return 所有非空的属性名
     */
    public static String[] getNullPropertyNames(Object source) {
        final BeanWrapper src = new BeanWrapperImpl(source);
        java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();

        Set<String> emptyNames = new HashSet<>();
        for (java.beans.PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) {
                emptyNames.add(pd.getName());
            }
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }


    /**
     * 根据属性名获取属性值
     *
     * @param fieldName
     * @param object
     * @return
     */
    @SneakyThrows
    public static Object getFieldValueByFieldName(String fieldName, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            //设置对象的访问权限，保证对private的属性的访问
            field.setAccessible(true);
            return field.get(object);
        } catch (Exception e) {
            return null;
        }
    }


    @SneakyThrows
    public static Object getAllFieldValueByFieldName(String fieldName, Object object) {
        Field field = null;
        Class<?> clazz = object.getClass();
        //从当前的类开始找，没找到再从父类中找。
        for (; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
            } catch (Exception e) {
                // 这里甚么都不能抛出去。
                // 如果这里的异常打印或者往外抛，则就不会进入
            }
        }
        //设置对象的访问权限，保证对private的属性的访问
        field.setAccessible(true);
        return field.get(object);
    }


    /**
     * @param key    属性名
     * @param value  属性名的值
     * @param object 属性的实体类
     */
    public static void setFieldValueByFieldName(String key, String value, Object object) {
        Object returnStr = null;
        try {
            Field[] fields = object.getClass().getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                returnStr = field.get(object);
                if (field.getAnnotation(JsonProperty.class) != null) {
                    JsonProperty annotation = ((JsonProperty) field.getAnnotation(JsonProperty.class));
                    if (annotation != null) {
                        System.out.println(annotation + "");
                        String jsonPropertyValue = annotation.value();
                        if (key.equals(jsonPropertyValue)) {
                            field.set(object, value);
                            break;
                        }
                    }
                } else {
                    String fieldName = field.getName();
                    if (key.equals(fieldName)) {
                        field.set(object, value);
                        break;
                    }
                }
            }
        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }


//    /**
//     * 通过反射设置属性的值
//     * @param fieldName  属性名
//     * @param fieldValue  属性值
//     * @param object  实体类对象
//     * @param parameterTypes  设置属性值的类型
//     * @throws
//     */
//    public static void setFieldValueByFieldName(String fieldName,Object fieldValue,Object object) {
//        try {
//            Field[] fields = object.getClass().getDeclaredFields();
//            for(int i=0;i<fields.length;i++){
//                Field field = fields[i];
//                //字段名称
//                String name = field.getName();
//                if(name.equals(fieldName)){
//                    field.setAccessible(true);
//                    //field.set(object,fieldValue) 可代替下面的拼接set方法;
//                    //将属性的首字符大写，方便构造get，set方法
//                    String methname = name.substring(0,1).toUpperCase()+name.substring(1);
//                    Method m = object.getClass().getMethod("set" + methname);
//                    m.invoke(object,fieldValue);
//                }
//            }
//        }catch (Exception e){
//            e.printStackTrace();
//        }
//    }


    /**
     * 根据属性名获取属性元素，包括各种安全范围和所有父类
     *
     * @param fieldName
     * @param object
     * @return
     */
    public static Field getFieldByClasss(String fieldName, Object object) {
        Field field = null;
        Class<?> clazz = object.getClass();
        //从当前的类开始找，没找到再从父类中找。
        for (; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
            } catch (Exception e) {
                // 这里甚么都不能抛出去。
                // 如果这里的异常打印或者往外抛，则就不会进入
            }
        }
        return field;

    }

    /**
     * 获取本类及其父类的字段属性
     *
     * @param clazz 当前类对象
     * @return 字段数组
     */
    public static Field[] getAllFields(Class<?> clazz) {
        List<Field> fieldList = new ArrayList<>();
        while (clazz != null) {
            Field[] declaredFields = clazz.getDeclaredFields();
            fieldList.addAll(new ArrayList<>(Arrays.asList(declaredFields)));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        return fieldList.toArray(fields);
    }

    /**
     * 获取本类的字段属性名，读取其注释注释，
     *
     * @param clazz 当前类对象
     * @return 字段数组
     */
    public static Map<String, String> getAllFieldsAndName(Class<?> clazz, List<String> withChildrenFields) {
        List<Field> allFields = getFields(clazz, withChildrenFields);
        Map<String, String> fieldWithName = new LinkedHashMap<>();
        for (Field field : allFields) {
            if (field.isAnnotationPresent(Comment.class)) {
                //获取字段名  TableField 就是对应的注解
                Comment declaredAnnotation = field.getDeclaredAnnotation(Comment.class);
                String columnName = declaredAnnotation.value();
                fieldWithName.put(field.getName(), columnName);
            }
        }
        return fieldWithName;
    }


    /**
     * 获取本类的字段属性,（目前只支持一层，有特殊需要需优化）
     *
     * @param clazz 当前类对象
     * @return 字段数组
     */
    public static List<Field> getFields(Class<?> clazz, List<String> withChildrenFields) {
        Field[] declaredFields = clazz.getDeclaredFields();
        List<Field> fields = new ArrayList<>(Arrays.asList(declaredFields));
        //检查所有的对象字段
        for (Field field : declaredFields) {
            if (withChildrenFields != null && withChildrenFields.size() > 0) {
                for (String withChildrenField : withChildrenFields) {
                    if (field.getName().equals(withChildrenField)) {
                        fields.remove(field);
                        //获取子对象字段
                        List<Field> childFields = getFields(field.getType(), null);
                        fields.addAll(childFields);
                    }
                }
            }
        }
        return fields;
    }

    /**
     * 判断是不是private类型方法
     */
    public static boolean isPrivate(int modifiers) {
        return ((modifiers & 0x2) != 0);
    }


//    public static <T> Map<String, Object> beanToMap(T bean) {
//        BeanMap beanMap = BeanMap.create(bean);
//        Map<String, Object> map = new HashMap<>();
//
//        beanMap.forEach((key, value) -> {
//            map.put(String.valueOf(key), value);
//        });
//        return map;
//    }

        /**
         * bean转化为map
         * @param bean
         * @return
         */
        public static Map<String, Object> beanToMap(Object bean) {
            if (bean == null) {
                return null;
            } else {
                HashMap<String, Object> hashMap = new HashMap<>();

                try {
                    Class<?> c = bean.getClass();
                    Method[] methods = c.getMethods();

                    for (Method method : methods) {
                        String name = method.getName();
                        String key = "";
                        if (name.startsWith("get")) {
                            key = name.substring(3);
                        }

                        if (key.length() > 0 && Character.isUpperCase(key.charAt(0)) && method.getParameterTypes().length == 0) {
                            if (key.length() == 1) {
                                key = key.toLowerCase();
                            } else if (!Character.isUpperCase(key.charAt(1))) {
                                key = key.substring(0, 1).toLowerCase() + key.substring(1);
                            }

                            if (!"class".equals(key.toLowerCase())) {
                                Object value = method.invoke(bean);
                                if (value != null) {
                                    hashMap.put(key, value);
                                }
                            }
                        }
                    }
                } catch (Throwable var9) {
                    var9.printStackTrace();
                }

                return hashMap;
            }
        }

        /**
         * 将map转换为bean
         *
         * @param clazz
         * @param map
         * @param <T>
         * @return
         */
        public static <T> T mapToBean(Class<T> clazz, Map<String, Object> map,List<String> excludeKeys) {
            T bean = null;
            try {
                bean = clazz.newInstance();
                for (Map.Entry<String, Object> stringObjectEntry : map.entrySet()) {
                    String key = stringObjectEntry.getKey();
                    if(excludeKeys.contains(key)){
                        continue;
                    }
                    Object value = stringObjectEntry.getValue();
                    // 去这个类及其父类递归找到这个属性
                    Field field = getClassField(clazz, key);
                    if (field != null) {
                        // 获取属性的set方法
                        String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
                        Method method = clazz.getMethod(methodName, field.getType());
                        if(value!=null && value instanceof Integer){
                            String typeName = field.getGenericType().getTypeName();
                            if(typeName.equals("java.lang.Long")){
                                value=(Long.valueOf((Integer)value));
                            }
                        }
                        if(value!=null){
                            String typeName = field.getGenericType().getTypeName();
                            if(typeName.equals("java.time.LocalDate")){
                                value=LocalDate.parse(value.toString());
                            }
                        }
                        try {
                            method.invoke(bean, value);
                        }catch (Exception e){
                            e.printStackTrace();
                        }finally {
                            continue;
                        }
                    }
                }
//            } catch (NoSuchMethodException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            } catch (Exception e) {
                e.printStackTrace();
            }
            return bean;
        }

        private static Field getClassField(Class<?> clazz, String fieldName) {
            Field[] declaredFields = clazz.getDeclaredFields();
            for (Field declaredField : declaredFields) {
                if (declaredField.getName().equals(fieldName)) {
                    return declaredField;
                }
            }
            // 如果找不到对应属性。递归去父类找
            Class<?> superclass = clazz.getSuperclass();
            if (null != superclass) {
                return getClassField(superclass, fieldName);
            }
            return null;
        }

//        /**
//         * 大写带下划线的属性列,转化为驼峰命名风格的 MAP
//         *
//         * @param stringObjectMap
//         * @return
//         */
//        public Map<String, Object> columnUpperCaseToMap(Map<String, Object> stringObjectMap) {
//            Set<Map.Entry<String, Object>> entrySet = stringObjectMap.entrySet();
//            Map<String, Object> map = new HashMap<>(entrySet.size());
//            for (Map.Entry<String, Object> stringObjectEntry : entrySet) {
//                String key = stringObjectEntry.getKey();
//                Object value = stringObjectEntry.getValue();
//                String newKey = WordUtils.capitalizeFully(key, new char[]{'_'}).replace("_", "");
//                String s = newKey.substring(0, 1).toLowerCase() + newKey.substring(1);
//                map.put(s, value);
//            }
//            return map;
//        }



    /**
     * 比较两个实体属性值，返回一个boolean,true则表时两个对象中的属性值无差异
     * @param oldObject 进行属性比较的对象1
     * @param newObject 进行属性比较的对象2
     * @return 属性差异比较结果boolean
     */
    public static boolean compareObject(Object oldObject, Object newObject) {
        Map<String, Map<String,Object>> resultMap=compareFields(oldObject,newObject);

        if(resultMap.size()>0) {
            return false;
        }else {
            return true;
        }
    }

    /**
     * 比较两个实体属性值，返回一个map以有差异的属性名为key，value为一个Map分别存oldObject,newObject此属性名的值
     * @param oldObject 进行属性比较的对象1
     * @param newObject 进行属性比较的对象2
     * @return 属性差异比较结果map
     */
    @SuppressWarnings("rawtypes")
    public static Map<String, Map<String,Object>> compareFields(Object oldObject, Object newObject) {
        Map<String, Map<String, Object>> map = null;

        try{
            /**
             * 只有两个对象都是同一类型的才有可比性
             */
            if (oldObject.getClass() == newObject.getClass()) {
                map = new HashMap<String, Map<String,Object>>();

                Class clazz = oldObject.getClass();
                //获取object的所有属性
                PropertyDescriptor[] pds = Introspector.getBeanInfo(clazz,Object.class).getPropertyDescriptors();

                for (PropertyDescriptor pd : pds) {
                    //遍历获取属性名
                    String name = pd.getName();

                    //获取属性的get方法
                    Method readMethod = pd.getReadMethod();

                    // 在oldObject上调用get方法等同于获得oldObject的属性值
                    Object oldValue = readMethod.invoke(oldObject);
                    // 在newObject上调用get方法等同于获得newObject的属性值
                    Object newValue = readMethod.invoke(newObject);

                    if(oldValue instanceof List){
                        continue;
                    }

                    if(newValue instanceof List){
                        continue;
                    }

                    if(oldValue instanceof Timestamp){
                        oldValue = new Date(((Timestamp) oldValue).getTime());
                    }

                    if(newValue instanceof Timestamp){
                        newValue = new Date(((Timestamp) newValue).getTime());
                    }

                    if(oldValue == null && newValue == null){
                        continue;
                    }else if(oldValue == null && newValue != null){
                        Map<String,Object> valueMap = new HashMap<String,Object>();
                        valueMap.put("oldValue",oldValue);
                        valueMap.put("newValue",newValue);

                        map.put(name, valueMap);

                        continue;
                    }

                    if (!oldValue.equals(newValue)) {// 比较这两个值是否相等,不等就可以放入map了
                        Map<String,Object> valueMap = new HashMap<String,Object>();
                        valueMap.put("oldValue",oldValue);
                        valueMap.put("newValue",newValue);

                        map.put(name, valueMap);
                    }
                }
            }
        }catch(Exception e){
            e.printStackTrace();
        }

        return map;
    }


}



