package com.elitesland.tw.tw5.server.common.util;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpenseaDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import com.elitesland.tw.tw5.server.udc.UdcTypeEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 字段改变记录日志工具类
 *
 * @author duwh
 * @date 2022/11/16
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class ChangeFieldLogUtil {

    private final CacheUtil cacheUtil;
    private final CrmOpenseaDAO openseaDAO;
    private final CrmOffshoreDAO offshoreDAO;

    /**
     * 获取变更内容
     *
     * @param newBean 更改后的Bean
     * @param oldBean 更改前的Bean
     * @param <T>
     * @return
     */
    public <T> String getFieldsUpdateLog(T newBean, T oldBean) {
        Field[] fields = newBean.getClass().getDeclaredFields();
        StringBuilder builder = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(FieldUpdateLog.class)) {
                try {
                    final String selectionKey = field.getAnnotation(FieldUpdateLog.class).selectionKey();
                    final String changeAction = field.getAnnotation(FieldUpdateLog.class).changeAction();
                    Object newValue = field.get(newBean);
                    Object oldValue = field.get(oldBean);
                    if (null == newValue) {
                        continue;
                    }
                    if (ObjectUtils.isEmpty(newValue)) {
                        newValue = "空";
                    } else {
                        newValue = translation(selectionKey, newValue);
                    }
                    if (ObjectUtils.isEmpty(oldValue)) {
                        oldValue = "空";
                    } else {
                        oldValue = translation(selectionKey, oldValue);
                    }

                    if (!Objects.equals(newValue, oldValue)) {
                        if (StringUtils.hasText(field.getAnnotation(FieldUpdateLog.class).fieldObject())) {
                        } else {
                            if (StringUtils.hasText(field.getAnnotation(FieldUpdateLog.class).objectNameField())) {
                                //获取字段名称
                                builder.append(BeanUtil.getAllFieldValueByFieldName(field.getAnnotation(FieldUpdateLog.class).objectNameField(), oldBean));
                            } else {
                                builder.append(field.getAnnotation(FieldUpdateLog.class).fieldName());
                            }
                            builder.append(" 由 ");
                            builder.append(oldValue);
                            builder.append(changeAction == null ? " 修改为 " : " " + changeAction + " ");
                            builder.append(newValue);
                        }
                    }
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        return builder.toString();
    }

    /**
     * 获取字段创建日志
     *
     * @param newBean 更改后的Bean
     * @return {@link String}
     */
    public <T> String getFieldsCreateLog(T newBean) {
        return getFieldsCreateLog(newBean, null);
    }

    public <T> String getFieldsCreateLog(T newBean, String content) {
        Field[] fields = newBean.getClass().getDeclaredFields();
        StringBuilder builder = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(FieldCreateLog.class)) {
                try {
                    Object newValue = field.get(newBean);
                    if (null == newValue) {
                        continue;
                    }
                    if (!ObjectUtils.isEmpty(newValue)) {
                        final String selectionKey = field.getAnnotation(FieldCreateLog.class).selectionKey();
                        //不处理对象字段，交由程序去处理
                        if (StringUtils.hasText(field.getAnnotation(FieldCreateLog.class).fieldObject())) {
                        } else {
                            newValue = translation(selectionKey, newValue);
                            //获取字段名称
                            builder.append(field.getAnnotation(FieldCreateLog.class).fieldName());
                            if (!StringUtils.hasText(content)) {
                                content = "创建为";
                            }
                            builder.append(" " + content + " ");
                            builder.append(newValue);
                            builder.append("\n");
                        }
                    }

                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        return builder.toString();
    }

    /**
     * 空字段处理
     *
     * @param payload  有效载荷
     * @param entityDb 实体数据库
     * @param entity   实体
     * @return {@link StringBuilder}
     */
    public StringBuilder nullFieldsProcess(TwCommonPayload payload, BaseModel entityDb, BaseModel entity) {
        StringBuilder builder = new StringBuilder();
        final List<String> nullFields = payload.getNullFields();
        final Class cClass = entity.getClass();
        final Class cClassReq = payload.getClass();
        final Class cClassDbDO = entityDb.getClass();
        if (!CollectionUtils.isEmpty(nullFields)) {
            nullFields.forEach(s -> {
                try {
                    Field field = cClass.getDeclaredField(s);
                    Field fReq = cClassReq.getDeclaredField(s);
                    Field fDbDO = cClassDbDO.getDeclaredField(s);
                    field.setAccessible(true);
                    fReq.setAccessible(true);
                    fDbDO.setAccessible(true);
                    field.set(entity, null);
                    fReq.set(payload, null);
                    Object oldValue = fDbDO.get(entityDb);
                    fDbDO.set(entityDb, null);
                    if (field.isAnnotationPresent(FieldUpdateLog.class)) {
                        try {
                            final String selectionKey = field.getAnnotation(FieldUpdateLog.class).selectionKey();
                            final String changeAction = field.getAnnotation(FieldUpdateLog.class).changeAction();
                            Object newValue = "空";
                            if (ObjectUtils.isEmpty(oldValue)) {
                                oldValue = "空";
                            } else {
                                oldValue = translation(selectionKey, oldValue);
                            }
                            if (!Objects.equals(newValue, oldValue)) {
                                //获取字段名称
                                builder.append(field.getAnnotation(FieldUpdateLog.class).fieldName());
                                builder.append(" 由 ");
                                builder.append(oldValue);
//                                builder.append(" 修改为 ");
                                builder.append(changeAction == null ? " 修改为 " : " " + changeAction + " ");
                                builder.append(newValue);

                            }
                        } catch (Exception e) {
                            log.error(e.getMessage(), e);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        return builder;
    }


    /**
     * 翻译
     *
     * @param selectionKey key
     * @param value        pub
     * @return {@link Object}
     */
    public <T> Object translation(String selectionKey, Object value) {
        if (StringUtils.hasText(selectionKey)) {
            // 用户翻译
            if (selectionKey.equals(UdcTypeEnum.USER.getCode())) {
                value = cacheUtil.getUserName(Long.valueOf(value.toString()));
                // 组织部门翻译
            } else if (selectionKey.equals(UdcTypeEnum.BU.getCode())) {
                value = cacheUtil.getOrgName(Long.valueOf(value.toString()));
            } else if (selectionKey.equals(UdcTypeEnum.OPENSEA.getCode())) {
                // 公海名称
                CrmOpenseaDO openseaDO = openseaDAO.queryById(Long.valueOf(BeanUtil.getAllFieldValueByFieldName("id", value).toString()));
                value = openseaDO == null ? null : openseaDO.getOpenseaName();
            } else if (selectionKey.equals(UdcTypeEnum.OFFSHORE.getCode())) {
                // 近海名称
                CrmOffshoreDO offshoreDO = offshoreDAO.queryById(Long.valueOf(BeanUtil.getAllFieldValueByFieldName("id", value).toString()));
                value = offshoreDO == null ? null : offshoreDO.getOffshoreName();
            } else {
                //特殊udc处理
                switch (selectionKey) {
                    case "crm:leads_channel":
                        //市场渠道特殊翻译
                        value = transferMarketChannel(value.toString());
                        break;
                    //标签特殊翻译
                    case "crm:tags":
                        value = transferTags(value.toString());
                        break;
                    default:
                        // udc  系统选择项翻译
                        value = cacheUtil.transferSystemSelection(selectionKey, value.toString());
                }

            }
        }
        return value;
    }

    private Object transferTags(String tagIds) {
        if (tagIds != null) {
            List<String> tagList = new ArrayList<>();
            String[] tags = tagIds.split(",");
            for (String tag : tags) {
                List<PrdSystemTagVO> systemTags = cacheUtil.getSystemTag(Long.parseLong(tag));
                for (PrdSystemTagVO systemTag : systemTags) {
                    tagList.add(systemTag.getTagName());
                }
            }
            return String.join(",", tagList);
        } else {
            return null;
        }
    }

    private Object transferMarketChannel(String marketChannel) {
        // 市场渠道
        if (marketChannel != null) {
            String[] split = marketChannel.split(",");
            if (split.length < 2) {
                return cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
            } else {
                String s1 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                String s2 = "";
                switch (split[0]) {
                    case "baidu":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                        break;
                    case "sem_360":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                        break;
                    case "offline_activity":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                        break;
                    case "thrid_party_data":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                        break;
                }
                return s2.equals("") ? s1 : s1 + "/" + s2;
            }
        } else {
            return null;
        }
    }

    /**
     * 根据属性名获取属性值
     *
     * @param fieldName
     * @param object
     * @return
     */
//    private String getFieldValueByFieldName(String fieldName, Object object) {
//        try {
//            Field field = object.getClass().getField(fieldName);
//            //设置对象的访问权限，保证对private的属性的访问
//            return  (String)field.get(object);
//        } catch (Exception e) {
//            return null;
//        }
//    }
    /**
     * 根据属性名获取属性元素，包括各种安全范围和所有父类
     *
     * @param fieldName
     * @param object
     * @return
     */
//    private String getFieldValueByFieldName(String fieldName, Object object) {
//        Field field = null;
//        Class<?> clazz = object.getClass();
//        for (; clazz != Object.class; clazz = clazz.getSuperclass()) {
//            try {
//                field = clazz.getDeclaredField(fieldName);
//                return  (String)field.get(object);
//            } catch (Exception e) {
//                // 这里甚么都不能抛出去。
//                // 如果这里的异常打印或者往外抛，则就不会进入
//                return null;
//            }
//        }
//        return null;
//    }


}
