package com.elitesland.tw.tw5.server.config;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemConfigVO;
import com.elitesland.tw.tw5.server.common.FilterInteceptor;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@RequiredArgsConstructor
public class FilterConfig implements WebMvcConfigurer {
    private final FilterInteceptor filterInteceptor;
    private final CacheUtil cacheUtil;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        //注册TestInterceptor拦截器
        InterceptorRegistration registration = registry.addInterceptor(filterInteceptor);
        registration.addPathPatterns("/api/**");                      //所有路径都被拦截
        PrdSystemConfigVO pvo = cacheUtil.getSystemConfig(TwSystemConfig.CONFIG_PATH);
        if (pvo != null) {
            registration.excludePathPatterns(pvo.getConfigValue());
        }

    }
}
