package com.elitesland.tw.tw5.server.demo.controller;

import com.elitesland.tw.tw5.api.demo.query.DemoCompanyBankQuery;
import com.elitesland.tw.tw5.api.demo.service.DemoCompanyService;
import com.elitesland.tw.tw5.api.demo.vo.DemoCompanyBankVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 标准样例controller
 *
 * @author wangding
 */
@Api("ERP关联数据样例")
@RestController
@RequiredArgsConstructor
@RequestMapping("/tw/company/")
@Slf4j

public class TwCompanyDemoController {

    private final DemoCompanyService service;

    @ApiOperation("多表分页查询")
    @GetMapping("paging")
    public TwOutputUtil paging(DemoCompanyBankQuery query) {
        PagingVO<DemoCompanyBankVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation("主键查询")
    @GetMapping("findId/{id}")
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        DemoCompanyBankVO paging = service.queryByKey(id);
        return TwOutputUtil.ok(paging);
    }


}
