package com.elitesland.tw.tw5.server.demo.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 简单样例DO
 * @author zhangyongqiang
 */
// 指定数据库是哪个表
@Entity(name = "demo_bank")
// 生产数据库表
@Table(name = "demo_bank")
// 为表增加注释字段
@org.hibernate.annotations.Table(appliesTo = "demo_bank", comment = "银行表")
@Getter
@Setter
@Where(clause = " delete_flag = 0 ")
public class DemoBankDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;
    @Comment("银行名称")
    @Column(nullable = false, length = 50)
    private String bankName;
    @Comment("开户行")
    @Column(nullable = false, length = 50)
    private String handleName;
    @Comment("银行卡号")
    @Column(nullable = false, length = 50)
    private String bankCard;
    @Comment("公司Id")
    @Column()
    private Long  companyId;
}
