package com.elitesland.tw.tw5.server.prd.ab.controller;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAddressPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbAddressService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAddressVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 地址管理
 *
 * @author carl.wang
 */
@Api("地址管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/ab")
@Slf4j
public class PrdAbAddressController {

    private final PrdAbAddressService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/address/insert")
    public TwOutputUtil insert(PrdAbAddressPayload payload) {
        // 校验地址类型 默认只能有一个
        List<PrdAbAddressVO> abAddressVOList = service.queryList(payload.getBookId(), payload.getAddressType());
        if (null != payload.getDefaultAddress() && payload.getDefaultAddress()) {
            if (!CollectionUtils.isEmpty(abAddressVOList)) {
                final long count = abAddressVOList.stream()
                    .filter(prdAbAddressVO -> null != prdAbAddressVO.getDefaultAddress() && prdAbAddressVO.getDefaultAddress())
                    .count();
                if (count > 0) {
                    return TwOutputUtil.error("999", "同一地址类型只能有一个设为默认！", payload);
                }
            }
        }
        PrdAbAddressVO vo = service.save(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/address/update")
    public TwOutputUtil update(PrdAbAddressPayload payload) {
        // 校验地址类型 默认只能有一个
        List<PrdAbAddressVO> abAddressVOList = service.queryList(payload.getBookId(), payload.getAddressType());
        if (null != payload.getDefaultAddress() && payload.getDefaultAddress()) {
            if (!CollectionUtils.isEmpty(abAddressVOList)) {
                final long count = abAddressVOList.stream()
                    .filter(prdAbAddressVO -> null != prdAbAddressVO.getDefaultAddress() && prdAbAddressVO.getDefaultAddress()
                        && !prdAbAddressVO.getId().equals(payload.getId()))
                    .count();
                if (count > 0) {
                    return TwOutputUtil.error("999", "同一地址类型只能有一个设为默认！", payload);
                }
            }
        }
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 删除
     *
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @param keys       主键id
     * @return result
     */
    @DeleteMapping("/address/delete")
    public TwOutputUtil delete(Long bookId, String objectType, Long[] keys) {
        service.delete(bookId, objectType, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param bookId 地址薄主键
     * @return result
     */
    @GetMapping("/address/queryList")
    public TwOutputUtil<PrdAbAddressVO> queryList(Long bookId) {
        return TwOutputUtil.ok(service.queryList(bookId));
    }

    /**
     * 根据客户主键查询地址列表
     *
     * @param customerId 客户主键
     * @return result
     */
    @GetMapping("/address/listByCustomerId")
    public TwOutputUtil<PrdAbAddressVO> listByCustomerId(Long customerId) {
        return TwOutputUtil.ok(service.listByCustomerId(customerId));
    }
}
