package com.elitesland.tw.tw5.server.prd.ab.controller;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbContactsPayload;
import com.elitesland.tw.tw5.api.prd.ab.query.PrdAbContactsQuery;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbContactsService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbContactsVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * 联系人管理
 *
 * @author carl.wang
 */
@Api("联系人管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/ab")
@Slf4j
public class PrdAbContactsController {

    private final PrdAbContactsService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/contacts/insert")
    public TwOutputUtil insert(PrdAbContactsPayload payload) {
        PrdAbContactsVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/contacts/update")
    public TwOutputUtil update(PrdAbContactsPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/contacts/paging")
    public TwOutputUtil paging(PrdAbContactsQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 详情查询
     *
     * @param id 主键
     * @return result
     */
    @GetMapping("/contacts/queryByKey/{id}")
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        PrdAbContactsVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 删除
     *
     * @param bookId     地址簿id
     * @param objectType 主档类型
     * @param keys       主键id
     * @return result
     */
    @DeleteMapping("/contacts/delete")
    public TwOutputUtil delete(Long bookId, String objectType, Long[] keys) {
        service.delete(bookId, objectType, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 修改激活暂挂状态
     *
     * @param key            主键
     * @param contactsStatus 状态
     * @return result
     */
    @GetMapping("/act/updateStatus")
    public TwOutputUtil updateStatus(Long key, String contactsStatus) {
        service.updateStatus(key, contactsStatus);
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param bookId 地址薄主键
     * @return result
     */
    @GetMapping("/contacts/queryList")
    public TwOutputUtil queryList(Long bookId) {
        return TwOutputUtil.ok(service.queryList(bookId));
    }

    /**
     * 添加跟进动态
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/contacts/addFollow")
    public TwOutputUtil addFollow(CrmFollowPayload payload) {
        service.addFollow(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 修改跟进动态
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/contacts/updateFollow")
    public TwOutputUtil updateFollow(CrmFollowPayload payload) {
        service.updateFollow(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 跟进动态列表查询
     *
     * @param objectId 联系人Id
     * @return result
     */
    @GetMapping("/contacts/queryListFollow")
    public TwOutputUtil queryListFollow(Long objectId) {
        return TwOutputUtil.ok(service.queryListFollow(objectId));
    }

    /**
     * 查询修改记录
     *
     * @return result
     */
    @GetMapping("/contacts/queryLogList")
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok(service.queryLogList(query));
    }


    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/contacts/batchExport")
    public void batchExport(HttpServletResponse response, PrdAbContactsQuery query) {
        service.downloadBatch(response, query);
    }
}
