package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbOrCompanyPayload;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.TwAssert;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgCompanyDO;
import com.elitesland.tw.tw5crm.server.common.util.GeodesyUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @Author carl.wang
 * @Description 地址簿管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdAbServiceImpl implements PrdAbService {
    private final CacheUtil cacheUtil;
    private final PrdAbDAO dao;
    private final GeodesyUtil geodesyUtil;
    //    // @DubboReference(version = "${provider.service.version}")
    //private SysNumberRuleService numberRuleService;

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public PrdAbVO saveAbOrCompany(PrdAbOrCompanyPayload payload) {
        PrdAbVO abVO = null;
        if (payload.getTaxNo() != null) {
            abVO = dao.queryCompanyByTaxNo(payload.getTaxNo());
        }
        boolean isNew = false;
        PrdAbDO abDO = null;
        //获取编号
        if (abVO == null) {
            abDO = PrdAbConvert.INSTANCE.toDo(payload);
            // abDO.setBookNo(code);
            abDO.setBookName(payload.getCompanyName());
            abDO = dao.save(abDO);
            isNew = true;
        }
        if (isNew) {
            PrdOrgCompanyDO companyDO = PrdAbConvert.INSTANCE.toCompanyDo(payload);
            companyDO.setCompanyNo(payload.getBookNo());
            companyDO.setBookId(abDO.getId());
            if (StringUtils.hasText(companyDO.getCompanyAddress())) {
                //获取经纬度
                String addressByLocation = geodesyUtil.getAddressByLocation(companyDO.getCompanyAddress());
                companyDO.setLongitudeLatitude(addressByLocation);
            }

            dao.saveCompany(companyDO);

            PrdAbAddressDO abAddressDO = new PrdAbAddressDO();
            abAddressDO.setBookId(abDO.getId());
            abAddressDO.setAddressEmail(payload.getCompanyEmail());
            abAddressDO.setAddressType(SystemDefaultEnum.DefaultAddressType.getCode());
            abAddressDO.setCity(payload.getCity());
            abAddressDO.setCityName(payload.getCityName());
            abAddressDO.setCountry("");
            abAddressDO.setDetailAddress(payload.getCompanyAddress());

            abAddressDO.setDistrict(payload.getDistrict());
            abAddressDO.setDistrictName(payload.getDistrictName());
            abAddressDO.setProvince(payload.getProvince());
            abAddressDO.setProvinceName(payload.getProvinceName());
            dao.saveAddress(abAddressDO);
        } else {
            if (!abVO.getRelateType().contains(payload.getRelateType())) {
                PrdAbPayload ab = new PrdAbPayload();
                ab.setId(abVO.getId());
                if ("".equals(abVO.getRelateType())) {
                    ab.setRelateType(payload.getRelateType());
                } else {
                    ab.setRelateType(abVO.getRelateType() + "," + payload.getRelateType());
                }
                dao.updateByKeyDynamic(ab);

            } else {
                throw TwException.error("", "该税号档案库已存在");
            }
        }
        return PrdAbConvert.INSTANCE.toVo(abDO);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public boolean updateAbOrCompany(PrdAbOrCompanyPayload payload) {
        PrdAbVO abVO = null;
        if (StringUtils.hasText(payload.getTaxNo())) {
            abVO = dao.queryCompanyByTaxNo(payload.getTaxNo());
        }
        if (abVO == null || abVO.getId().longValue() == payload.getId().longValue()) {
            if (StringUtils.hasText(payload.getCompanyName())) {
                PrdAbPayload ab = new PrdAbPayload();
                ab.setId(payload.getId());
                ab.setBookName(payload.getCompanyName());
                dao.updateByKeyDynamic(ab);
            }
            if (StringUtils.hasText(payload.getCompanyAddress())) {
                PrdAbVO prdAbVO = dao.queryCompanyByBookId(payload.getId());
                TwAssert.notNull(prdAbVO, "地址簿不在");
                if (!StringUtils.hasText(prdAbVO.getLongitudeLatitude()) || !payload.getCompanyAddress().equals(prdAbVO.getCompanyAddress())) {
                    //获取经纬度
                    String addressByLocation = geodesyUtil.getLongitudeAndLatitudeByAddress(payload.getCompanyAddress());
                    payload.setLongitudeLatitude(addressByLocation);
                }

            }
            dao.updateCompanyByKey(payload);
            //dao.saveCompany(companyDO);
        } else {
            throw TwException.error("", "该税号档案库已存在");
        }
        return true;
    }

    @Override
    public Long update(PrdAbPayload payload) {
        return null;
    }

    @Override
    public List<PrdAbVO> queryList() {
        return null;
    }

    @Override
    public boolean deleteSoft(List<Long> keys) {
        return false;
    }
}
