package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustOperInfoSysPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustOperInfoSysQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustOperInfoSysService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * 客户经营-信息化系统
 *
 * @author haobo.chang
 * @date 2022/12/26
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/customerOperation/infoSys")
@Slf4j
public class CrmCustOperInfoSysController {
    private final CrmCustOperInfoSysService service;

    @PostMapping("/save")
    public TwOutputUtil save(@RequestBody CrmCustOperInfoSysPayload payload) {
        service.save(payload);
        return TwOutputUtil.ok();
    }

    @DeleteMapping("/delete/{id}")
    public TwOutputUtil delete(@PathVariable long id) {
        service.delete(id);
        return TwOutputUtil.ok();
    }

    @PostMapping("/paging")
    public TwOutputUtil paging(@RequestBody CrmCustOperInfoSysQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }
}
