package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationChancePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationChanceService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 人脉经营-经营机会点
 *
 * @author carl
 * @date 2022/11/21
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmCustomerOperationChanceController {

    private final CrmCustomerOperationChanceService service;

    /**
     * 新增或更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/customerOperationChance")
    public TwOutputUtil insertOrUpdate(@RequestBody CrmCustomerOperationChancePayload payload) {
        return TwOutputUtil.ok(service.insertOrUpdate(payload));
    }


    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/customerOperationChance/{key}")
    //@UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmCustomerOperationChanceVO prdFileVO = service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }


    /**
     * 查询列表
     *
     * @param operId 客户经营id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/customerOperationChance/list")
    //@UdcNameClass
    public TwOutputUtil queryList(Long operId) {
        List<CrmCustomerOperationChanceVO> vos = service.queryList(operId);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 分页查询
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/customerOperationChance/paging")
    @UdcNameClass
    public TwOutputUtil paging(CrmCustomerOperationChanceQuery query) {
        PagingVO<CrmCustomerOperationChanceVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/customerOperationChance/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 标记为已读
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/customerOperationChance/updateIsRead")
    public TwOutputUtil updateIsRead(Long[] keys) {
        service.updateIsRead(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 操作记录日志列表
     *
     * @param key 机会点主键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/customerOperationChance/queryLogList/{key}")
    @UdcNameClass
    public TwOutputUtil logList(@PathVariable Long key) {
        final List<PrdSystemLogVO> prdSystemLogVOS = service.queryLogList(key);
        return TwOutputUtil.ok(prdSystemLogVOS);
    }

    /**
     * 删除或新增参与者
     *
     * @param key     机会点主键
     * @param userIds 要新增或删除的参与者ids
     * @return
     */
    @GetMapping("/customerOperationChance/updateInvolvedUser")
    public TwOutputUtil updateInvolvedUser(Long key, Long[] userIds) {
        service.updateInvolvedUser(key, Arrays.asList(userIds));
        return TwOutputUtil.ok();
    }
}
