package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpenseaService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPotentialCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author zoey
 * 公海管理
 * @date 2022/6/14 - 9:27
 */
@Api("公海管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmOpenseaController {

    private final CrmOpenseaService service;
    private final CrmPotentialCustomerService potentialCustomerService;

    /**
     * 新建或修改
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增和修改")
    @PostMapping("/opensea/saveOne")
    public TwOutputUtil insert(@RequestBody CrmOpenseaPayload payload) {
        CrmOpenseaVO vo = service.saveOne(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 局部字段更新
     * @param payload po类
     * @return result
     */
    @PostMapping("/opensea/dynamicUpdate")
    public TwOutputUtil dynamicUpdate(@RequestBody CrmOpenseaPayload payload) {
        service.dynamicUpdate(payload);
        return TwOutputUtil.ok();
    }



    /**
     * 列表查询不分页(默认列表)
     * @param query 查询参数
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/opensea/list")
    public TwOutputUtil queryList(CrmOpenseaQuery query) {
        List<CrmOpenseaListVO> list = service.queryList(query);
        return TwOutputUtil.ok(list);
    }


    /**
     * 当前用户作为管理员的公海列表
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/opensea/list/my")
    public TwOutputUtil queryListMy() {
        List<CrmOpenseaListVO> list = service.queryListMy();
        return TwOutputUtil.ok(list);
    }

    /**
     * 分页查询
     *
     * @return result
     */
    @GetMapping("/opensea/paging")
    public TwOutputUtil paging(CrmOpenseaQuery query) {

        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 详情查询
     * @param id 主键
     * @return result
     */
    @ApiOperation("详情查询")
    @GetMapping("/opensea/detail/{id}")
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        CrmOpenseaVO vo= service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 逻辑删除
     * @param openseaId 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/opensea/delete")
    public TwOutputUtil delete(@RequestParam Long openseaId,@RequestParam(required = false) Long newOpenseaId) {
        potentialCustomerService.deleteOpenseaSoft(openseaId,newOpenseaId);
        return TwOutputUtil.ok();
    }


    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @PostMapping("/opensea/batchExport")
    public void batchExport(HttpServletResponse response, CrmOpenseaQuery query) {
        service.downloadOpensea(response, query);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/opensea/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    @Transactional
    public TwOutputUtil batchImport(MultipartFile file) {
        service.importOpensea(file);
        return TwOutputUtil.ok();
    }

}
