package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityAnalyzePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityAnalyzeService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityAnalyzeVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 商机案情分析管理
 *
 * @author carl.wang
 * @date
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmOpportunityAnalyzeController {
    private final CrmOpportunityAnalyzeService service;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;

    @Value("${tw4.account.operation}")
    private String account_operation;

    @Value("${tw4.account.del}")
    private String account_del;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/analyze/insert")
    public TwOutputUtil insert(CrmOpportunityAnalyzePayload payload) {
        CrmOpportunityAnalyzeVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/oppo/analyze/update")
    public TwOutputUtil update(CrmOpportunityAnalyzePayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/analyze/updateFromV4")
    public TwOutputUtil updateFromV4(CrmOpportunityAnalyzePayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param oppoId 商机id
     * @return result
     */
    @GetMapping("/oppo/analyze/queryList")
    public TwOutputUtil queryList(Long oppoId) {
        return TwOutputUtil.ok(service.queryList(oppoId));
    }


    /**
     * 删除
     *
     * @param oppoId 商机id
     * @param keys   主键id
     * @return result
     */
    @DeleteMapping("/oppo/analyze/deleteSoft")
    public TwOutputUtil deleteSoft(Long oppoId, Long[] keys) {
        service.deleteSoft(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
