package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 商机管理
 *
 * @author carl.wang
 * @date
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmOpportunityController {

    private final CrmOpportunityService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/insert")
    public TwOutputUtil insert(CrmOpportunityPayload payload) {
        CrmOpportunityVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/oppo/update")
    public TwOutputUtil update(CrmOpportunityPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setId(service.getIdByV4(payload.getOppoIdV4()));
        }
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/updateFromV4")
    public TwOutputUtil updateFromV4(CrmOpportunityPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setId(service.getIdByV4(payload.getOppoIdV4()));
        }
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 切换验证状态接口（待验证改为已验证，已验证改为待验证）
     * @param ids
     * @return
     */
    @PostMapping("/oppo/toggleCheckStatus")
    public TwOutputUtil toggleCheckStatus(@RequestBody List<Long> ids){
        service.toggleCheckStatus(ids);
        return TwOutputUtil.ok();
    }
    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @PostMapping("/oppo/paging")
    @UdcNameClass
    public TwOutputUtil paging(@RequestBody CrmOpportunityQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 列表查询 用于下拉选择 （用于商机下拉选择）
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/oppo/queryListSimple")
    public TwOutputUtil queryListSimple(CrmOpportunityQuery query) {
        return TwOutputUtil.ok(service.queryListSimple(query));
    }

    /**
     * 详情查询
     *
     * @param id 主键
     * @return result
     */
    @GetMapping("/oppo/queryByKey/{id}")
    @UdcNameClass
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        CrmOpportunityVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改状态
     *
     * @param id 主键
     * @return result
     **/
    @GetMapping("/oppo/changeStatus/{id}")
    public TwOutputUtil changeStatus(@PathVariable Long id,Long oppoIdV4) {
        if(oppoIdV4!=null){
            id = service.getIdByV4(oppoIdV4);
        }
        service.changeStatus(id);
        return TwOutputUtil.ok();
    }

    /**
     * 关闭
     *
     * @param key         主键
     * @param closeReason  关闭原因
     * @param loseReson   丢单原因
     * @param clsoeRemark 关闭备注
     * @return result
     **/
    @GetMapping("/oppo/closeOpportunity")
    public TwOutputUtil closeOpportunity(Long key, String closeReason, String loseReson, String clsoeRemark,Long oppoIdV4) {
        if(oppoIdV4!=null){
            key = service.getIdByV4(oppoIdV4);
        }
        service.closeOpportunity(key, closeReason, loseReson, clsoeRemark);
        return TwOutputUtil.ok();
    }

    /**
     * 添加成员
     *
     * @param oppoId  商机Id
     * @param userIds 添加成员userid
     * @return result
     */
    @GetMapping("/oppo/addMember")
    public TwOutputUtil addMember(Long oppoId, Long[] userIds) {
        List<PrjProjectMemberVO> memberVOS = service.addMember(oppoId, Arrays.asList(userIds));
        return TwOutputUtil.ok(memberVOS);
    }

    /**
     * 删除成员
     *
     * @param oppoId 商机Id
     * @param keys   成员主键id
     * @return result
     */
    @DeleteMapping("/oppo/deleteMember")
    public TwOutputUtil deleteMember(Long oppoId, Long[] keys) {
        service.deleteMember(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 添加跟进动态
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/addFollow")
    public TwOutputUtil addFollow(CrmFollowPayload payload) {
        service.addFollow(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 修改跟进动态
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/oppo/updateFollow")
    public TwOutputUtil updateFollow(CrmFollowPayload payload) {
        service.updateFollow(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 跟进动态列表查询
     *
     * @param objectId 商机Id
     * @return result
     */
    @GetMapping("/oppo/queryListFollow")
    public TwOutputUtil queryListFollow(Long objectId) {
        return TwOutputUtil.ok(service.queryListFollow(objectId));
    }

    /**
     * 查询修改记录
     *
     * @return result
     */
    @GetMapping("/oppo/queryLogList")
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok(service.queryLogList(query));
    }


    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/oppo/batchExport")
    public void batchExport(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        service.downloadBatch(response, query);
    }


    /**
     * 关联客户
     * @return result
     */
    @GetMapping("/oppo/bindCustomer/{id}")
    public TwOutputUtil bindCustomer(@PathVariable Long id) {
        Map<String,Object> result = new HashMap<>();
        try {
            result = service.bindCustomer(id);
        }catch (Exception e){
            service.deleteSoft(id);
            return TwOutputUtil.error("","绑定失败，请重试！","");
        }
        return TwOutputUtil.ok(result);
    }


    /**
     * 对商机历史数据绑定客户
     */
    @GetMapping("/oppo/bindCustomers")
    public TwOutputUtil bindCustomers() {
        return TwOutputUtil.ok(service.bindCustomers());
    }


    /**
     * 获取易稻壳文件夹地址
     * 1、文件夹不存在，创建、授权、返回itemId 存到商机数据中；获取易稻壳链接；
     * 2、itemId存在，根据itemId查询易稻壳链接返回；
     *
     * @return result
     */
    @GetMapping("/oppo/yeedoc/getUri/{id}")
    public TwOutputUtil yeedocGetUri(@PathVariable Long id) {
        return TwOutputUtil.ok(service.yeedocGetUri(id));
    }


}
