package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunitySalesPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunitySalesService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunitySalesVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunitySalesDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunitySalesDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunitySalesRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 商机销售清单管理
 *
 * @author carl.wang
 * @date
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmOpportunitySalesController {
    private final CrmOpportunitySalesService service;
    private final CrmOpportunitySalesDAO dao;
    private final CrmOpportunitySalesRepo repo;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/sales/insert")
    public TwOutputUtil insert(CrmOpportunitySalesPayload payload) {
        CrmOpportunitySalesVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/oppo/sales/update")
    public TwOutputUtil update(CrmOpportunitySalesPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/sales/updateFromV4")
    public TwOutputUtil updateFromV4(CrmOpportunitySalesPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param oppoId 商机id
     * @return result
     */
    @GetMapping("/oppo/sales/queryList")
    public TwOutputUtil queryList(Long oppoId) {
        return TwOutputUtil.ok(service.queryList(oppoId));
    }


    /**
     * 删除
     *
     * @param oppoId 商机id
     * @param keys   主键id
     * @return result
     */
    @DeleteMapping("/oppo/sales/deleteSoft")
    public TwOutputUtil deleteSoft(Long oppoId, Long[] keys) {
        service.deleteSoft(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping("/oppo/sales/deleteV4")
    public TwOutputUtil delete(Long[] keysV4) {
        List<Long> keys = new ArrayList<>();
        for (Long keyV4 : keysV4) {
            keys.add(dao.getIdByV4(keyV4));
        }
        if(keys!=null && !keys.isEmpty()){
            CrmOpportunitySalesDO crmOpportunitySalesDO = repo.findById(keys.get(0)).orElse(null);
            service.deleteSoft(crmOpportunitySalesDO.getOppoId(),keys);
        }
        return TwOutputUtil.ok();
    }

}
