package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityStakeholderPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityStakeholderService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityStakeholderVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 商机干系人管理
 *
 * @author carl.wang
 * @date
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmOpportunityStakeholderController {
    private final CrmOpportunityStakeholderService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/stakeholder/insert")
    public TwOutputUtil insert(CrmOpportunityStakeholderPayload payload) {
        CrmOpportunityStakeholderVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/oppo/stakeholder/update")
    public TwOutputUtil update(CrmOpportunityStakeholderPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/stakeholder/updateFromV4")
    public TwOutputUtil updatefromV4(CrmOpportunityStakeholderPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param oppoId 商机id
     * @return result
     */
    @GetMapping("/oppo/stakeholder/queryList")
    public TwOutputUtil queryList(Long oppoId) {
        return TwOutputUtil.ok(service.queryList(oppoId));
    }


    /**
     * 删除
     *
     * @param oppoId 商机id
     * @param keys   主键id
     * @return result
     */
    @DeleteMapping("/oppo/stakeholder/deleteSoft")
    public TwOutputUtil deleteSoft(Long oppoId, Long[] keys) {
        service.deleteSoft(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
