package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActDynamicPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActReportPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActActivityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActReportVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.entity.*;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActActivityRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActDynamicRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActReportRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectMemberDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class CrmActActivityDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmActActivityRepo repo;
    private final CrmActDynamicRepo repoDyn;
    private final CrmActReportRepo repoReport;
    private final QCrmActActivityDO qdo = QCrmActActivityDO.crmActActivityDO;
    private final QCrmActDynamicDO qdoDyn = QCrmActDynamicDO.crmActDynamicDO;
    private final QCrmOpportunityDO qdoOppo = QCrmOpportunityDO.crmOpportunityDO;
    private final QCrmActReportDO qdoReport = QCrmActReportDO.crmActReportDO;
    private final QPrjProjectDO qdoProject = QPrjProjectDO.prjProjectDO;
    private final QCrmActPlanDO qdoPlan = QCrmActPlanDO.crmActPlanDO;
    private final QCrmActPlanDetailDO qdoDetail = QCrmActPlanDetailDO.crmActPlanDetailDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrjProjectMemberDO qdoMember = QPrjProjectMemberDO.prjProjectMemberDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmActActivityDO save(CrmActActivityDO ado) {
        return repo.save(ado);
    }

    /**
     * 更新发布状态
     *
     * @param ids
     * @param isRelease
     */
    public void updataReleaseByIds(List<Long> ids, Integer isRelease) {
        repo.updataReleaseByIds(ids, isRelease);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmActDynamicDO saveDynamic(CrmActDynamicDO ado) {
        return repoDyn.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmActReportDO saveReport(CrmActReportDO ado) {
        return repoReport.save(ado);
    }


    /**
     * @param payload 修改结项报告
     * @return 修改的行数
     */
    @Transactional
    public long updateReportyKeyDynamic(CrmActReportPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoReport)
                .where(qdoReport.id.eq(payload.getId()));
        if (payload.getReportStatus() != null) {
            update.set(qdoReport.reportStatus, payload.getReportStatus());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdoReport.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdoReport.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdoReport.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdoReport.deleteFlag, payload.getDeleteFlag());
        }
        if (payload.getProcInstId() != null) {
            update.set(qdoReport.procInstId, payload.getProcInstId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdoReport.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qdoReport.procInstId);
            }
        }
        // 执行修改
        return update.execute();
    }


    /**
     * @param detailId 预算明细id
     * @return
     * @Description 查询所有活动总金额
     **/
    public List<CrmActActivityDO> queryActivityByDetailId(Long detailId) {
        JPAQuery<CrmActActivityDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.detailId.eq(detailId));
        jpaQuery.where(qdo.deleteFlag.eq(0));

        return jpaQuery.fetch();
    }

//    /**
//     * 更新活动以结项
//     *
//     * @param key 主键
//     * @return 删除的行数
//     */
//    public long updateActFinish(Long key) {
//        JPAUpdateClause update = jpaQueryFactory.update(qdo)
//                .set(qdo.isFinish, 1)
//                .where(qdo.id.eq(key));
//        return update.execute();
//    }

    /**
     * 获取逾期的活动
     *
     * @return
     * @Description
     **/
    public List<CrmActActivityVO> findActivityUnReleases() {
        JPAQuery<CrmActActivityVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActActivityVO.class,
                qdo.id,
                qdoProject.projectNo,
                qdoProject.projectName,
                qdoProject.createUserId

        )).from(qdo).leftJoin(qdoProject).on(qdo.projectId.eq(qdoProject.id));
        jpaQuery.where(qdo.deleteFlag.eq(0)).where(qdoProject.deleteFlag.eq(0)).where(qdo.procInstStatus.eq(ProcInstStatus.APPROVED));
        jpaQuery.where(qdo.isRelease.eq(0)).where(qdo.approvedTime.loe(LocalDateTime.now().minusDays(3))).where(qdo.isEmailRemind.isNull().or(qdo.isEmailRemind.eq(0)));
        return jpaQuery.fetch();
    }

    /**
     * 获取创建人待发布的活动公告数量
     *
     * @param userId 创建人id
     * @return
     * @Description
     **/
    public QueryResults<CrmActActivityDO> findActivityReleaseByUserId(Long userId) {
        JPAQuery<CrmActActivityDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.createUserId.eq(userId)).where(qdo.deleteFlag.eq(0)).where(qdo.procInstStatus.eq(ProcInstStatus.APPROVED));
        jpaQuery.where(qdo.isRelease.eq(0)).orderBy(qdo.approvedTime.asc()).limit(1);
        return jpaQuery.fetchResults();
    }

    /**
     * @param key 主键
     * @return
     * @Description
     **/
    public CrmActActivityDO queryActivityByKey(Long key) {
        JPAQuery<CrmActActivityDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.id.eq(key));
        return jpaQuery.fetchFirst();
    }

    /**
     * 更新市场计划明细支出额
     *
     * @param detailId    市场计划明细主键
     * @param expenditure 市场计划明细支出总额
     * @return 删除的行数
     */
    public long updatePlanDetail(Long detailId, BigDecimal expenditure) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoDetail)
                .set(qdoDetail.expenditure, expenditure)
                .where(qdoDetail.id.eq(detailId));
        return update.execute();
    }

    /**
     * 更新是否发起逾期邮件通知
     *
     * @param ids
     * @return
     */

    public long updateEmailRemind(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.isEmailRemind, 1)
                .where(qdo.id.in(ids));
        return update.execute();
    }

//

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象项目
     * @return 修改的行数
     */
    @Transactional
    public long updateProjectByKeyDynamic(CrmActActivityPayload payload, Long projectId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoProject)
                .where(qdoProject.id.eq(projectId));
        if (payload.getProjectName() != null) {
            update.set(qdoProject.projectName, payload.getProjectName());
        }
        if (payload.getStartTime() != null) {
            update.set(qdoProject.startTime, payload.getStartTime());
        }
        if (payload.getEndTime() != null) {
            update.set(qdoProject.endTime, payload.getEndTime());
        }
        if (payload.getManageUserId() != null) {
            update.set(qdoProject.manageUserId, payload.getManageUserId());
        }
        if (payload.getOrgId() != null) {
            update.set(qdoProject.orgId, payload.getOrgId());
        }
        if (payload.getCompanyId() != null) {
            update.set(qdoProject.companyId, payload.getCompanyId());
        }
        if (payload.getFileCodes() != null) {
            update.set(qdoProject.fileCodes, payload.getFileCodes());
        }
        if (payload.getCloseReason() != null) {
            update.set(qdoProject.closeReason, payload.getCloseReason());
        }
        if (payload.getClsoeRemark() != null) {
            update.set(qdoProject.clsoeRemark, payload.getClsoeRemark());
        }
        if (payload.getProjectStatus() != null) {
            update.set(qdoProject.projectStatus, payload.getProjectStatus());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
//            if (nullFields.contains("leadsId")) {
//                update.setNull(qdo.leadsId);
//            }
        }
        // 执行修改
        return update.execute();
    }

//

//    /**
//     * 修改锁定状态
//     *
//     * @param key 主键
//     * @return 修改的行数
//     */
//    public long updateIsLock(Long key, Integer isLock) {
//        JPAUpdateClause update = jpaQueryFactory.update(qdo).set(qdo.isLock, isLock)
//                .where(qdo.id.eq(key));
//        return update.execute();
//    }

    /**
     * 修改活动动态跟进
     *
     * @param payload 主键
     * @return
     */
    public long updateDynamic(CrmActDynamicPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoDyn)
                .where(qdoDyn.id.eq(payload.getId()));
        if (payload.getDynamicContent() != null) {
            update.set(qdoDyn.dynamicContent, payload.getDynamicContent());
        }
        if (payload.getDynamicType() != null) {
            update.set(qdoDyn.dynamicType, payload.getDynamicType());
        }
        if (payload.getFileCodes() != null) {
            update.set(qdoDyn.fileCodes, payload.getFileCodes());
        }
        return update.execute();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象活动
     * @return 修改的行数
     */
    @Transactional
    public long updateActivityByKeyDynamic(CrmActActivityPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getPlanId() != null) {
            update.set(qdo.planId, payload.getPlanId());
        }
        if (payload.getDetailId() != null) {
            update.set(qdo.detailId, payload.getDetailId());
        }
        if (payload.getActivityScale() != null) {
            update.set(qdo.activityScale, payload.getActivityScale());
        }
        if (payload.getActivityAddr() != null) {
            update.set(qdo.activityAddr, payload.getActivityAddr());
        }
        if (payload.getActivityTarget() != null) {
            update.set(qdo.activityTarget, payload.getActivityTarget());
        }
        if (payload.getPersonNum() != null) {
            update.set(qdo.personNum, payload.getPersonNum());
        }
        if (payload.getPersonMoney() != null) {
            update.set(qdo.personMoney, payload.getPersonMoney());
        }
        if (payload.getPersonSource() != null) {
            update.set(qdo.personSource, payload.getPersonSource());
        }
        if (payload.getClaimMoney() != null) {
            update.set(qdo.claimMoney, payload.getClaimMoney());
        }
        if (payload.getPurchaseMoney() != null) {
            update.set(qdo.purchaseMoney, payload.getPurchaseMoney());
        }
        if (payload.getSundryMoney() != null) {
            update.set(qdo.sundryMoney, payload.getSundryMoney());
        }
        if (payload.getBudgetMoney() != null) {
            update.set(qdo.budgetMoney, payload.getBudgetMoney());
        }
        if (payload.getTotalMoney() != null) {
            update.set(qdo.totalMoney, payload.getTotalMoney());
        }
        if (payload.getPotentialCustomer() != null) {
            update.set(qdo.potentialCustomer, payload.getPotentialCustomer());
        }
        if (payload.getLeadNum() != null) {
            update.set(qdo.leadNum, payload.getLeadNum());
        }
        if (payload.getBusOps() != null) {
            update.set(qdo.busOps, payload.getBusOps());
        }
        if (payload.getPipeline() != null) {
            update.set(qdo.pipeline, payload.getPipeline());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getProcDefKey() != null) {
            update.set(qdo.procDefKey, payload.getProcDefKey());
        }
        if (payload.getIsRelease() != null) {
            update.set(qdo.isRelease, payload.getIsRelease());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
        }
        // 执行修改
        return update.execute();
    }

//
//    /**
//     * 逻辑删除
//     *
//     * @param keys 主键
//     * @return 删除的行数
//     */
//    public long deleteSoft(List<Long> keys) {
//        JPAUpdateClause update = jpaQueryFactory.update(qdo)
//                .set(qdo.deleteFlag, 1)
//                .where(qdo.id.in(keys));
//        return update.execute();
//    }
//

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActReportVO> getJpaQuerySelectReport() {
        JPAQuery<CrmActReportVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActReportVO.class,
                qdoReport.id,
                qdoReport.actId,
                qdoReport.personNum,
                qdoReport.personMoney,
                qdoReport.claimMoney,
                qdoReport.purchaseMoney,
                qdoReport.sundryMoney,
                qdoReport.totalMoney,
                qdoReport.potentialCustomer,
                qdoReport.leadNum,
                qdoReport.busOps,
                qdoReport.pipeline,
                qdoReport.reportContent,
                qdoReport.reportNo,
                qdo.projectId,
                qdoProject.projectName,
                qdoProject.startTime,
                qdoProject.endTime,
                qdoProject.projectNo,
                qdoProject.projectStatus,
                qdo.personNum.as("budPersonNum"),
                qdo.personMoney.as("budPersonMoney"),
                qdo.claimMoney.as("budClaimMoney"),
                qdo.purchaseMoney.as("budPurchaseMoney"),
                qdo.sundryMoney.as("budSundryMoney"),
                qdo.totalMoney.as("budTotalMoney"),
                qdo.potentialCustomer.as("budPotentialCustomer"),
                qdo.leadNum.as("budLeadNum"),
                qdo.busOps.as("budBusOps"),
                qdo.pipeline.as("budPipeline"),
                qdoEmployee.employeeName,
                qdoReport.createUserId,
                qdoReport.creator,
                qdoReport.createTime,
                qdoReport.createTime,
                qdoReport.procInstId,
                qdoReport.procInstStatus,
                qdoReport.submitTime,
                qdoReport.approvedTime,
                qdoReport.reportStatus
        )).from(qdoReport).leftJoin(qdo).on(qdo.id.longValue().eq(qdoReport.actId.longValue()))
                .leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue()))
                .leftJoin(qdoEmployee).on(qdoReport.createUserId.eq(qdoEmployee.userId));
        return jpaQuery;
    }

    /**
     * @param actId 活动主键
     * @return
     * @Description 获取汇报数据列表
     **/
    public List<CrmActReportVO> queryActReportList(Long actId, Integer reportType) {
        JPAQuery<CrmActReportVO> jpaQuery = getJpaQuerySelectReport();
        jpaQuery.where(qdoReport.actId.eq(actId));
        jpaQuery.where(qdoReport.reportType.eq(reportType));
        jpaQuery.orderBy(qdoReport.createTime.desc());
        return jpaQuery.fetch();
    }

    /**
     * @param key 汇报数据主键
     * @return
     * @Description 获取汇报数据详情
     **/
    public CrmActReportVO queryActReportDetail(Long key) {
        JPAQuery<CrmActReportVO> jpaQuery = getJpaQuerySelectReport();
        jpaQuery.where(qdoReport.id.eq(key));
        return jpaQuery.fetchFirst();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActReportVO> getJpaQuerySelectData() {
        JPAQuery<CrmActReportVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActReportVO.class,
                qdo.id.as("actId"),
                qdo.projectId,
                qdoProject.projectName,
                qdoProject.projectNo,
                qdoProject.startTime,
                qdoProject.endTime,
                qdoProject.projectStatus,
                qdo.personNum.as("budPersonNum"),
                qdo.personMoney.as("budPersonMoney"),
                qdo.claimMoney.as("budClaimMoney"),
                qdo.purchaseMoney.as("budPurchaseMoney"),
                qdo.sundryMoney.as("budSundryMoney"),
                qdo.totalMoney.as("budTotalMoney"),
                qdo.potentialCustomer.as("budPotentialCustomer"),
                qdo.leadNum.as("budLeadNum"),
                qdo.busOps.as("budBusOps"),
                qdo.pipeline.as("budPipeline")
        )).from(qdo).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue()));
        return jpaQuery;
    }

    /**
     * @param key 主键
     * @return
     * @Description 获取汇报数据
     **/
    public CrmActReportVO queryActReportData(Long key) {
        JPAQuery<CrmActReportVO> jpaQuery = getJpaQuerySelectData();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    /**
     * @param key 主键
     * @return
     * @Description 获取活动关联商机数量
     **/
    public long queryOppoCount(Long key) {
        JPAQuery<CrmOpportunityDO> jpaQuery = jpaQueryFactory.select(qdoOppo).from(qdoOppo);
        jpaQuery.where(qdoOppo.actId.eq(key));
        jpaQuery.where(qdoOppo.deleteFlag.eq(0));
        return jpaQuery.fetchCount();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActActivityVO> getJpaQuerySelect() {
        JPAQuery<CrmActActivityVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActActivityVO.class,
                qdo.id,
                qdo.projectId,
                qdo.planId,
                qdoPlan.planName,
                qdo.detailId,
                qdoDetail.detailType,
                qdoProject.projectName,
                qdoProject.projectNo,
                qdoProject.startTime,
                qdoProject.endTime,
                qdoProject.orgId,
                qdoOrg.orgName,
                qdoProject.manageUserId,
                qdoProject.companyId,
                qdoProject.fileCodes,
                qdoProject.projectStatus,
                qdoProject.closeReason,
                qdoProject.clsoeRemark,
                qdo.activityScale,
                qdo.activityAddr,
                qdoDetail.totalMoney.as("planDetailTotalMoney"),
                qdoDetail.expenditure,
                qdo.activityTarget,
                qdo.personNum,
                qdo.personMoney,
                qdo.personSource,
                qdo.claimMoney,
                qdo.purchaseMoney,
                qdo.sundryMoney,
                qdo.budgetMoney,
                qdo.totalMoney,
                qdo.potentialCustomer,
                qdo.leadNum,
                qdo.busOps,
                qdo.pipeline,

                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.createTime,
                qdo.procInstId,
                qdo.procInstStatus,
                qdo.procDefKey,
                qdo.submitTime,
                qdo.approvedTime
        )).from(qdo).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue()))
                .leftJoin(qdoPlan).on(qdoPlan.id.longValue().eq(qdo.planId.longValue()))
                .leftJoin(qdoDetail).on(qdoDetail.id.longValue().eq(qdo.detailId.longValue()))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoProject.orgId.longValue()))
                .leftJoin(qdoMember).on(qdoMember.projectId.longValue().eq(qdoProject.id.longValue()));
        return jpaQuery;
    }

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public CrmActActivityVO queryBykey(Long key) {
        JPAQuery<CrmActActivityVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActProjectVO> getJpaQuerySelectProject() {
        JPAQuery<CrmActProjectVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActProjectVO.class,
                qdoProject.id,
                qdoProject.projectName,
                qdoProject.projectNo,
                qdoProject.manageUserId,
                qdoProject.projectStatus,
                qdoProject.closeReason,
                qdoEmployee.employeeName.as("manageUserName"),

                qdo.detailId,
                qdo.totalMoney,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime
        )).from(qdo).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue())).leftJoin(qdoEmployee).on(qdoEmployee.userId.longValue().eq(qdoProject.manageUserId.longValue()));
        return jpaQuery;
    }

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public CrmActProjectVO queryProjectBykey(Long key) {
        JPAQuery<CrmActProjectVO> jpaQuery = getJpaQuerySelectProject();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @return
     * @Description 列表查询
     **/
    public List<CrmActProjectVO> queryList(Long planId) {
        JPAQuery<CrmActProjectVO> jpaQuery = getJpaQuerySelectProject();
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        if (planId != null) {
            jpaQuery.where(qdo.planId.eq(planId));
        } else {
            jpaQuery.where(qdoProject.projectStatus.eq(WorkFlowStatusEnum.APPROVED_WORK.getCode()).or(qdoProject.projectStatus.eq(WorkFlowStatusEnum.CLOSED_WORK.getCode())));
        }
        return jpaQuery.fetch();
    }
//

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActActivityVO> getJpaQueryWhere(CrmActActivityQuery query, List<Long> actUserIds, List<Long> orgManageIds) {
        JPAQuery<CrmActActivityVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getActivityIds())) {
            jpaQuery.where(qdo.id.in(query.getActivityIds()));
        }
        if (!ObjectUtils.isEmpty(query.getPlanId())) {
            jpaQuery.where(qdo.planId.eq(query.getPlanId()));
        }
        if (!ObjectUtils.isEmpty(query.getDetailId())) {
            jpaQuery.where(qdo.detailId.eq(query.getDetailId()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qdo.createUserId.eq(query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectName())) {
            jpaQuery.where(qdoProject.projectName.like(SqlUtil.toSqlLikeString(query.getProjectName())));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoProject.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectNo())) {
            jpaQuery.where(qdoProject.projectNo.eq(query.getProjectNo()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectTime())) {
            jpaQuery.where(qdoProject.startTime.loe(query.getProjectTime()));
            jpaQuery.where(qdoProject.endTime.goe(query.getProjectTime()));
        }
        if (!ObjectUtils.isEmpty(query.getManageUserId())) {
            jpaQuery.where(qdoProject.manageUserId.eq(query.getManageUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectStatus())) {
            jpaQuery.where(qdoProject.projectStatus.eq(query.getProjectStatus()));
        }
        if (actUserIds != null && !actUserIds.isEmpty()) {
            jpaQuery.where(qdoMember.userId.in(actUserIds).or(qdoProject.orgId.in(orgManageIds)));
            jpaQuery.where(qdoMember.deleteFlag.eq(0));
        }
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        jpaQuery.groupBy(qdoProject.id);
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 获取创建人待发布的活动公告
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmActActivityVO> queryPagingUnReleased(CrmActActivityQuery query) {
        JPAQuery<CrmActActivityVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.createUserId.eq(query.getCreateUserId())).where(qdo.deleteFlag.eq(0)).where(qdo.procInstStatus.eq(ProcInstStatus.APPROVED));
        jpaQuery.where(qdo.isRelease.eq(0));

        QueryResults<CrmActActivityVO> result = jpaQuery.groupBy(qdo.id).offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<CrmActActivityVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmActActivityVO> queryPaging(CrmActActivityQuery query, List<Long> actUserIds, List<Long> orgManageIds) {
        JPAQuery<CrmActActivityVO> jpaQuery = getJpaQueryWhere(query, actUserIds, orgManageIds);
        QueryResults<CrmActActivityVO> result = jpaQuery.groupBy(qdo.id).offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<CrmActActivityVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrjProjectMemberVO> getJpaQuerySelectProjectMember() {
        JPAQuery<PrjProjectMemberVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrjProjectMemberVO.class,
                qdoMember.id,
                qdoMember.projectId,
                qdoMember.userId,
                qdoMember.employeeName,
                qdoMember.createUserId,
                qdoMember.creator,
                qdoMember.createTime
        )).from(qdoMember);
        return jpaQuery;
    }

    /**
     * @param projectId 项目主键
     * @return
     * @Description 获取项目成员
     **/
    public List<PrjProjectMemberVO> queryProjectMember(Long projectId) {
        JPAQuery<PrjProjectMemberVO> jpaQuery = getJpaQuerySelectProjectMember();
        jpaQuery.where(qdoMember.projectId.eq(projectId));
        jpaQuery.where(qdoMember.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActDynamicVO> getJpaQuerySelectActDynamic() {
        JPAQuery<CrmActDynamicVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActDynamicVO.class,
                qdoDyn.id,
                qdoDyn.actId,
                qdoDyn.dynamicType,
                qdoDyn.dynamicContent,
                qdoEmployee.employeeName,
                qdoDyn.fileCodes,
                qdoDyn.createUserId,
                qdoDyn.creator,
                qdoDyn.createTime
        )).from(qdoDyn).leftJoin(qdoEmployee).on(qdoDyn.createUserId.eq(qdoEmployee.userId));
        return jpaQuery;
    }

    /**
     * @param actId 活动主键
     * @return
     * @Description 获取项目动态
     **/
    public List<CrmActDynamicVO> queryActDynamic(Long actId) {
        JPAQuery<CrmActDynamicVO> jpaQuery = getJpaQuerySelectActDynamic();
        jpaQuery.where(qdoDyn.actId.eq(actId));
        jpaQuery.where(qdoDyn.deleteFlag.eq(0));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoDyn, null));
        return jpaQuery.fetch();
    }

    /**
     * @param actIds 活动主键
     * @return
     * @Description 获取项目动态
     **/
    public List<CrmActDynamicVO> queryActDynamicByPrjIds(List<Long> actIds) {
        JPAQuery<CrmActDynamicVO> jpaQuery = getJpaQuerySelectActDynamic();
        jpaQuery.where(qdoDyn.actId.in(actIds));
        jpaQuery.where(qdoDyn.deleteFlag.eq(0));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoDyn, null));
        return jpaQuery.fetch();
    }

    /**
     * @param key 主键
     * @return
     * @Description 跟进动态详情查询
     **/
    public CrmActDynamicVO queryActDynamicDetail(Long key) {
        JPAQuery<CrmActDynamicVO> jpaQuery = getJpaQuerySelectActDynamic();
        jpaQuery.where(qdoDyn.id.eq(key));
        jpaQuery.where(qdoDyn.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param userIds 用户ids
     * @return
     * @Description 获取项目成员
     **/
    public List<PrdOrgEmployeeVO> queryEmployee(List<Long> userIds) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQuerySelectEmployee();
        jpaQuery.where(qdoEmployee.userId.in(userIds));
        jpaQuery.where(qdoEmployee.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQuerySelectEmployee() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeVO.class,
                qdoEmployee.id,
                qdoEmployee.userId,
                qdoEmployee.personId,
                qdoEmployee.employeeName
        )).from(qdoEmployee);
    }

    /**
     * 修改流程状态
     *
     * @param key 主键
     * @return
     */
    public long updateStatus(Long key, String projectStatus, String procInstId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoProject)
                .set(qdoProject.projectStatus, projectStatus);
        if (!procInstId.equals("")) {
            update.set(qdoProject.procInstId, procInstId);
        }
        update.where(qdoProject.id.eq(key));
        return update.execute();
    }


    public Long queryByReportId(Long key) {
        CrmActReportDO crmActReportDO = repoReport.findById(key).orElse(null);
        if (crmActReportDO != null) {
            return crmActReportDO.getActId();
        } else {
            return -1L;
        }
    }


    public List<Long> queryByLeadsIds(List<Long> leadIds) {
        return repo.queryByLeadsIds(leadIds);
    }

    public List<Long> queryByIds(List<Long> activiyProjIds) {
        return repo.queryByIds(activiyProjIds);
    }

//    public List<Long> queryByOppoIds(List<Long> oppoIds) {
//        return repo.queryByOppoIds(oppoIds);
//    }
}
