package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerDataVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Map;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class CrmCustomerDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmCustomerRepo repo;
    private final QCrmCustomerDO qdo = QCrmCustomerDO.crmCustomerDO;
    private final QPrdAbDO qdoAb = QPrdAbDO.prdAbDO;
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    private final QCrmLeadsDO qdoLeads1 = new QCrmLeadsDO("qdoLeads1");
    private final QCrmOpportunityDO qdoOpportunity = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmCustomerVO> getJpaQuerySelect() {
        JPAQuery<CrmCustomerVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustomerVO.class,
                qdo.id,
                qdo.bookId,
                qdo.customerStatus,
                qdo.customerName,
                qdo.customerGrade,
                qdo.customerSource,
                qdo.serviceUserId,
                qdo.businessUserId,
                qdo.careUserId,
                qdo.operationUserId,
                qdoCompany.companyIndustry,
                qdoCompany.companyPhone,
                qdoCompany.companyEmail,
                qdoCompany.companyFax,
                qdoCompany.province,
                qdoCompany.provinceName,
                qdoCompany.city,
                qdoCompany.cityName,
                qdoCompany.district,
                qdoCompany.districtName,
                qdoCompany.companyAddress,
                qdoCompany.companyWebsite,
                qdoCompany.companyScale,
                qdoCompany.taxNo,
                qdoCompany.currency,
                qdoCompany.language,
                qdoCompany.companyNature,
                qdoCompany.taxNo,
                qdoCompany.longitudeLatitude,
                qdoAb.bookNo,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime
        )).from(qdo).leftJoin(qdoAb).on(qdoAb.id.longValue().eq(qdo.bookId.longValue())).leftJoin(qdoCompany).on(qdoAb.id.longValue().eq(qdoCompany.bookId.longValue()))
                .leftJoin(qdoLeads).on(qdoLeads.formalCustomerId.longValue().eq(qdo.id.longValue()))
                .leftJoin(qdoOpportunity).on(qdoOpportunity.formalCustomerId.longValue().eq(qdo.id.longValue()));
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmCustomerVO> getJpaQueryWhere(CrmCustomerQuery query) {
        JPAQuery<CrmCustomerVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getCustomerStatus())) {
            jpaQuery.where(qdo.customerStatus.eq(query.getCustomerStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerName())) {
            jpaQuery.where(qdo.customerName.like(SqlUtil.toSqlLikeString(query.getCustomerName())));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerSource())) {
            jpaQuery.where(qdo.customerSource.eq(query.getCustomerSource()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerGrade())) {
            jpaQuery.where(qdo.customerGrade.eq(query.getCustomerGrade()));
        }
        if (!ObjectUtils.isEmpty(query.getCompanyIndustry())) {
            jpaQuery.where(qdoCompany.companyIndustry.eq(query.getCompanyIndustry()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserIds())) {
            jpaQuery.where(qdo.createUserId.in(query.getCreateUserIds()));
        }
//        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
//            jpaQuery.where(qdo.createUserId.eq(query.getCreateUserId()));
//        }
        if (!ObjectUtils.isEmpty(query.getCustomerIds())) {
            jpaQuery.where(qdo.id.in(query.getCustomerIds()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerGrades())) {
//            jpaQuery.where(qdo.customerGrade.in(query.getCustomerGrades()).or(qdo.customerGrade.isNull()));
            jpaQuery.where(qdo.customerGrade.in(query.getCustomerGrades()));
        }
        if (!ObjectUtils.isEmpty(query.getFilterType())) {
            if (query.getFilterType().equals("sales")) {
                jpaQuery.where(qdoOpportunity.leadsId.isNull().or(qdoLeads.sourceType.eq("personal")).or(qdo.createUserId.eq(query.getCreateUserId())));
            } else if (query.getFilterType().equals("market")) {
                jpaQuery.where(qdoLeads.sourceType.eq("market").or(qdoOpportunity.sourceType.eq("EXTERNAL")).or(qdo.createUserId.eq(query.getCreateUserId())));
//                jpaQuery.where(qdoLeads.sourceType.eq("market").or(qdoLeads1.sourceType.eq("market")));
            }
        } else {
            if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
                jpaQuery.where(qdo.createUserId.eq(query.getCreateUserId()));
            }
        }
        // 常用基础查询条件拼装
//        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.distinct();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmCustomerVO> queryPaging(CrmCustomerQuery query) {
        JPAQuery<CrmCustomerVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<CrmCustomerVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<CrmCustomerVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<CrmCustomerVO> queryList(CrmCustomerQuery query) {
        JPAQuery<CrmCustomerVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 列表查询
     *
     * @return 结果
     */
    public List<CrmCustomerDataVO> queryList() {
        JPAQuery<CrmCustomerDataVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustomerDataVO.class, qdo.id, qdo.bookId, qdo.customerName, qdoCompany.companyIndustry))
            .from(qdo)
            .leftJoin(qdoCompany).on(qdoCompany.bookId.longValue().eq(qdo.bookId.longValue()))
                .where(qdo.deleteFlag.eq(0)).where(qdoCompany.deleteFlag.eq(0));
//                .where(qdo.customerStatus.eq(WorkFlowStatusEnum.APPROVED_WORK.getCode()));
        return jpaQuery.fetch();

    }

    /**
     * 详细查询
     *
     * @param key 主键
     * @return 结果
     */
    public CrmCustomerVO queryDetail(Long key) {
        JPAQuery<CrmCustomerVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdoAb.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();

    }

    /**
     * 通过地址薄主键详细查询
     *
     * @param bookId 地址薄主键
     * @return 结果
     */
    public CrmCustomerVO queryDetailByBookId(Long bookId) {
        JPAQuery<CrmCustomerVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdoAb.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();

    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmCustomerDO save(CrmCustomerDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmCustomerDO> saveAll(List<CrmCustomerDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * @param key
     * @return
     * @Description
     **/
    public PrdAbVO queryAbVOBykey(Long key) {
        JPAQuery<PrdAbVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdAbVO.class,
                qdoAb.id,
                qdoAb.bookIdV4,
                qdoAb.bookName,
                qdoAb.bookNo,
                qdoAb.bookType
        )).from(qdoAb).leftJoin(qdo).on(qdoAb.id.longValue().eq(qdo.bookId.longValue()));
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdoAb.deleteFlag.eq(0));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param bookId 地址簿
     * @return
     * @Description
     **/
    public Long queryCompany(Long bookId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoCompany.id).from(qdoCompany);
        jpaQuery.where(qdoCompany.bookId.eq(bookId));
        jpaQuery.where(qdoCompany.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @return
     * @Description
     **/
    public List<PrdOrgCompanyVO> queryCompanys() {
        JPAQuery<PrdOrgCompanyVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgCompanyVO.class,
                qdoCompany.id,
                qdoCompany.companyAddress

        )).from(qdoCompany);
        jpaQuery.where(qdoCompany.deleteFlag.eq(0)).where(qdoCompany.companyAddress.isNotNull().and(qdoCompany.companyAddress.isNotEmpty()));
        jpaQuery.where(qdoCompany.longitudeLatitude.isNull().or(qdoCompany.longitudeLatitude.isEmpty()));
        return jpaQuery.fetch();
    }

    /**
     * 修改公司经纬度
     *
     * @param key 主键
     * @return
     */
    public long updateCompany(Long key, String longitudeLatitude) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoCompany)
                .where(qdoCompany.id.eq(key));
        update.set(qdoCompany.longitudeLatitude, longitudeLatitude);
        return update.execute();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(CrmCustomerPayload payload) {
        boolean isUp = false;
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getCustomerStatus() != null) {
            isUp = true;
            update.set(qdo.customerStatus, payload.getCustomerStatus());
        }
        if (payload.getCustomerName() != null) {
            isUp = true;
            update.set(qdo.customerName, payload.getCustomerName());
        }
        if (payload.getCustomerGrade() != null) {
            isUp = true;
            update.set(qdo.customerGrade, payload.getCustomerGrade());
        }
        if (payload.getCustomerSource() != null) {
            isUp = true;
            update.set(qdo.customerSource, payload.getCustomerSource());
        }
        if (payload.getServiceUserId() != null) {
            isUp = true;
            update.set(qdo.serviceUserId, payload.getServiceUserId());
        }
        if (payload.getBusinessUserId() != null) {
            isUp = true;
            update.set(qdo.businessUserId, payload.getBusinessUserId());
        }
        if (payload.getCareUserId() != null) {
            isUp = true;
            update.set(qdo.careUserId, payload.getCareUserId());
        }
        if (payload.getOperationUserId() != null) {
            isUp = true;
            update.set(qdo.operationUserId, payload.getOperationUserId());
        }
        if (payload.getRemark() != null) {
            isUp = true;
            update.set(qdo.remark, payload.getRemark());
        }
        if (!isUp) {
            return 0L;
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 修改状态
     *
     * @param key    主键
     * @param status 状态
     * @return
     */
    public long updateStatus(Long key, String status) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(key));
        update.set(qdo.customerStatus, status);
        return update.execute();
    }

    /**
     * 修改跟进级别
     *
     * @param key   主键
     * @param grade 状态
     * @return
     */
    public long updateCustomerGrade(Long key, String grade) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(key));
        update.set(qdo.customerGrade, grade);
        return update.execute();
    }

    /**
     * 获取员工数据
     *
     * @param userIds
     * @return
     */
    public List<Map<String, Object>> queryEmployees(List<Long> userIds) {
        return repo.queryEmployees(userIds);
    }

    /**
     * 查询当前客户是否存在
     *
     * @param customerName
     * @return
     */
    public int countByName(String customerName) {
        return repo.countByCustomerNameAndDeleteFlag(customerName, 0);
    }

    public List<CrmCustomerDO> findByName(String customerName) {
        return repo.findByCustomerNameAndDeleteFlag(customerName, 0);
    }

    public Long queryIdByBookId(Long bookId) {
        return repo.findIdByBookId(bookId);
    }
}
