package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsVO;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsCustomerRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsRepo;
import com.elitesland.tw.tw5.server.prd.prj.convert.PrjProjectConvert;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.persistence.criteria.*;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class CrmLeadsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmLeadsRepo repo;
    private final QCrmLeadsDO qdo = QCrmLeadsDO.crmLeadsDO;
    private final CrmLeadsCustomerRepo customerRepo;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmLeadsDO save(CrmLeadsDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmLeadsDO> saveAll(List<CrmLeadsDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结果
     */
    public CrmLeadsVO queryByKey(Long id){
        JPAQuery<CrmLeadsVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        return jpaQuery.fetchFirst();
    }




    /**
     * 拼装查询字段
     * @return  jpaQuery对象
     */
    private JPAQuery<CrmLeadsVO> getJpaQuerySelect() {
        JPAQuery<CrmLeadsVO> jpaQuery=jpaQueryFactory.select(Projections.bean(CrmLeadsVO.class,
                qdo.id,
//                qdo.offshoreId,
                qdo.leadsNo,
                qdo.leadsName,
                qdo.leadsStatus,
                qdo.leadsStage,
                qdo.sourceType,
//                qdo.marketId,
                qdo.channel,
                qdo.saleUserId,
                qdo.bonusDistributeType,
//                qdo.bonusDistributeTo,
                qdo.closeReason,
                qdo.backReason,
                qdo.withdrawReason
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmLeadsVO> getJpaQueryWhere(CrmLeadsQuery query) {
        JPAQuery<CrmLeadsVO> jpaQuery = getJpaQuerySelect();
//        if (!ObjectUtils.isEmpty(query.getOffshoreId())) {
//            jpaQuery.where(qdo.offshoreId.eq(query.getOffshoreId()));
//        }
        if (!ObjectUtils.isEmpty(query.getLeadsNo())) {
            jpaQuery.where(qdo.leadsNo.like(SqlUtil.toSqlLikeString(query.getLeadsNo())));
        }
        if (!ObjectUtils.isEmpty(query.getLeadsName())) {
            jpaQuery.where(qdo.leadsName.like(SqlUtil.toSqlLikeString(query.getLeadsName())));
        }
        if (!ObjectUtils.isEmpty(query.getLeadsStatus())) {
            jpaQuery.where(qdo.leadsStatus.eq(query.getLeadsStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getLeadsStage())) {
            jpaQuery.where(qdo.leadsStage.eq(query.getLeadsStage()));
        }
        if (!ObjectUtils.isEmpty(query.getSourceType())) {
            jpaQuery.where(qdo.sourceType.eq(query.getSourceType()));
        }
        if (!ObjectUtils.isEmpty(query.getMarketId())) {
//            jpaQuery.where(qdo.marketId.eq(query.getMarketId()));
        }
        if (!ObjectUtils.isEmpty(query.getChannel())) {
            jpaQuery.where(qdo.channel.like(SqlUtil.toSqlLikeString(query.getChannel())));
        }
        if (!ObjectUtils.isEmpty(query.getSaleUserId())) {
//            jpaQuery.where(qdo.saleUserId.eq(query.getSaleUserId()));
        }
//        if (!ObjectUtils.isEmpty(query.getBonusDistributeTo())) {
//            jpaQuery.where(qdo.bonusDistributeTo.eq(query.getBonusDistributeTo()));
//        }
        if (!ObjectUtils.isEmpty(query.getBonusDistributeType())) {
            jpaQuery.where(qdo.bonusDistributeType.eq(query.getBonusDistributeType()));
        }
        if (!ObjectUtils.isEmpty(query.getCloseReason())) {
            jpaQuery.where(qdo.closeReason.like(SqlUtil.toSqlLikeString(query.getCloseReason())));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery,qdo._super,query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    public Specification<CrmLeadsDO> getSpec(CrmLeadsQuery query) {
        Specification<CrmLeadsDO> querySpecifi = (root, criteriaQuery, cb) -> {
            List<Predicate> predicates = new ArrayList<>();
            // 使用左连接查询
//            Join<CrmLeadsDO, CrmOffshoreDO> offshoreJoin = root.join("offshores", JoinType.LEFT);
            //近海查询
//            if (!ObjectUtils.isEmpty(query.getOffshoreIds())) {
//                Path<Object> path = offshoreJoin.get("id");
//                CriteriaBuilder.In<Object> in = cb.in(path);
//                for (Long offshoreId:query.getOffshoreIds()){
//                    in.value(offshoreId);
//                }
//                predicates.add(cb.and(in));
//            }
            if(!ObjectUtils.isEmpty(query.getOffshoreId())){
                predicates.add(cb.equal(root.get("offshoreId").as(String.class), query.getOffshoreId()));
            }
            if(!ObjectUtils.isEmpty(query.getCreateUserId())){
                predicates.add(cb.equal(root.get("createUserId").as(String.class), query.getCreateUserId()));
            }
            if (!ObjectUtils.isEmpty(query.getSaleOrCreateUserId())){
                Predicate pred1 = cb.equal(root.get("saleUserId"), query.getSaleOrCreateUserId());
                Predicate pred2 = cb.equal(root.get("createUserId"), query.getSaleOrCreateUserId());
                predicates.add(cb.or(pred1, pred2));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsIdsForFollow())) {
                Path<Long> ids = root.get("id");
                CriteriaBuilder.In<Long> in = cb.in(ids);
                for (Long id : query.getLeadsIdsForFollow()) {
                    in.value(id);
                }
                predicates.add(cb.and(in));
            }
            if (!ObjectUtils.isEmpty(query.getSaleUserId())){
                Predicate pred2 = cb.equal(root.get("saleUserId"), query.getSaleUserId());
                if (!CollectionUtils.isEmpty(query.getIds())) {
                    Path<Long> ids = root.get("id");
                    CriteriaBuilder.In<Long> in = cb.in(ids);
                    for (Long id : query.getIds()) {
                        in.value(id);
                    }
                    Predicate pred1 = (Predicate) in;
                    predicates.add(cb.or(pred1, pred2));
                } else {
                    predicates.add(pred2);
                }


            }
            if (!ObjectUtils.isEmpty(query.getLeadsStageNotEqual())) {
                predicates.add(cb.notEqual(root.get("leadsStage").as(String.class), query.getLeadsStageNotEqual()));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsStatusNotIn())) {
                List<String> leadsStatusNotIn = query.getLeadsStatusNotIn();
                for (String s : leadsStatusNotIn) {
                    predicates.add(cb.notEqual(root.get("leadsStatus").as(String.class), s));
                }
            }
            if (!ObjectUtils.isEmpty(query.getLeadsStageNotIn())) {
                List<String> leadsStageNotIn = query.getLeadsStageNotIn();
                for (String s : leadsStageNotIn) {
                    predicates.add(cb.notEqual(root.get("leadsStage").as(String.class), s));
                }
            }
            if (!ObjectUtils.isEmpty(query.getLeadsStageIn())) {
                Path<String> ids = root.get("leadsStage");
                CriteriaBuilder.In<String> in = cb.in(ids);
                for (String id : query.getLeadsStageIn()) {
                    in.value(id);
                }
                predicates.add(cb.and(in));
            }
            if (!ObjectUtils.isEmpty(query.getNotFollowLeadsRemindTimeNotNull()) && query.getNotFollowLeadsRemindTimeNotNull()==true) {
                predicates.add(cb.isNotNull(root.get("notFollowLeadsRemindTime")));
            }
            if (!StringUtils.isEmpty(query.getLeadsNo())) {
                predicates.add(cb.like(root.get("leadNo").as(String.class), SqlUtil.toSqlLikeString(query.getLeadsNo())));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsName())) {
                predicates.add(cb.like(root.get("leadsName").as(String.class), SqlUtil.toSqlLikeString(query.getLeadsName())));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsStatus())) {
                predicates.add(cb.equal(root.get("leadsStatus").as(String.class), query.getLeadsStatus()));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsStage())) {
                predicates.add(cb.equal(root.get("leadsStage").as(String.class), query.getLeadsStage()));
            }
            if (!ObjectUtils.isEmpty(query.getSourceType())) {
                predicates.add(cb.equal(root.get("sourceType").as(String.class), query.getSourceType()));
            }
            if (!ObjectUtils.isEmpty(query.getFormalCustomerId())) {
                predicates.add(cb.equal(root.get("formalCustomerId").as(Long.class), query.getFormalCustomerId()));
            }
            Join<CrmLeadsDO, PrjProjectDO> marketJoin = root.join("market", JoinType.LEFT);
            if (!ObjectUtils.isEmpty(query.getMarketId())) {
                predicates.add(cb.equal(marketJoin.get("id").as(Long.class), query.getMarketId()));
            }
            if (!ObjectUtils.isEmpty(query.getCreateTimeStart())) {
                //大于或等于开始时间
                predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), query.getCreateTimeStart()));
            }
            if (!ObjectUtils.isEmpty(query.getCreateTimeEnd())) {
                //小于或等于结束时间
                predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), query.getCreateTimeEnd()));
            }
            // 使用左连接查询
            Join<CrmLeadsDO, CrmLeadsCustomerDO> customerJoin = root.join("customer", JoinType.LEFT);
            if (!ObjectUtils.isEmpty(query.getCustomerName())) {
                predicates.add(cb.like(customerJoin.get("customerName").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerName())));
            }
            if (!ObjectUtils.isEmpty(query.getCustomerIndustry())) {
                predicates.add(cb.equal(customerJoin.get("customerIndustry").as(String.class), query.getCustomerIndustry()));
            }
            if (!ObjectUtils.isEmpty(query.getCustomerGrade())) {
                predicates.add(cb.equal(customerJoin.get("customerGrade").as(String.class), query.getCustomerGrade()));
            }
            if (!ObjectUtils.isEmpty(query.getCustRegion())) {
                predicates.add(cb.equal(customerJoin.get("custRegion").as(String.class), query.getCustRegion()));
            }
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };

        return querySpecifi;
    }



    /**
     * 动态查询集合(不分页查询)
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CrmLeadsVO> queryListDynamic(CrmLeadsQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.asc("createTime");
        query.setOrders(Arrays.asList(orderItem));
        JPAQuery<CrmLeadsVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }



    /**
     * 分页查询
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmLeadsVO> queryPaging(CrmLeadsQuery query){
        JPAQuery<CrmLeadsVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<CrmLeadsVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.<CrmLeadsVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(CrmLeadsPayload payload) {
        //查询出当前的do
        CrmLeadsDO crmLeadsDO = repo.findById(payload.getId()).orElse(null);
        if(crmLeadsDO!=null){

//            //不级联操作market表
//            if (payload.getOffshores() != null) {
//                //TODO:重新写
//                List<CrmOffshoreDO> offshoreDOS = payload.getOffshores().stream().map(e -> CrmOffshoreConvert.INSTANCE.toDo(e)).collect(Collectors.toList());
//                offshoreDOS = offshoreDOS.stream().filter(e -> {
//                    if(e.getDeleteFlag() == 0){
//                        return true;
//                    }else{
//                        crmLeadsDO.getOffshores().remove(e);
//                        return false;
//                    }
//                }).collect(Collectors.toList());
//                crmLeadsDO.setOffshores(offshoreDOS);
//            }
            if(payload.getRemark() != null){
                crmLeadsDO.setRemark(payload.getRemark());
            }
            if(payload.getOffshoreId() != null){
                crmLeadsDO.setOffshoreId(payload.getOffshoreId());
            }
            if (payload.getLeadsNo() != null) {
                crmLeadsDO.setLeadsNo(payload.getLeadsNo());
            }
            if (payload.getLeadsName() != null) {
                crmLeadsDO.setLeadsName(payload.getLeadsName());
            }
            if (payload.getAnnualTurnover()!=null){
                crmLeadsDO.setAnnualTurnover(payload.getAnnualTurnover());
            }
            if (payload.getArea()!=null){
                crmLeadsDO.setArea(payload.getArea());
            }
            if (payload.getLeadsStatus() != null) {
                crmLeadsDO.setLeadsStatus(payload.getLeadsStatus());
            }
            if (payload.getLeadsStage() != null) {
                crmLeadsDO.setLeadsStage(payload.getLeadsStage());
            }
            if (payload.getSourceType() != null) {
                crmLeadsDO.setSourceType(payload.getSourceType());
            }
            //不级联操作market表，只有可能更改id
            if (payload.getMarket() != null) {
                crmLeadsDO.setMarket(PrjProjectConvert.INSTANCE.toDo(payload.getMarket()));
            }
            if (payload.getChannel() != null) {
                crmLeadsDO.setChannel(payload.getChannel());
            }
            //不级联操作员工表，只有可能更改id
            if (payload.getSaleUserId() != null) {
                crmLeadsDO.setSaleUserId(payload.getSaleUserId());
            }
            if (payload.getPreSaleUserId() != null) {
                crmLeadsDO.setPreSaleUserId(payload.getPreSaleUserId());
            }
            if (payload.getBonusDistributeType() != null) {
                crmLeadsDO.setBonusDistributeType(payload.getBonusDistributeType());
            }
            if (payload.getBonusDistributeTo() != null) {
                crmLeadsDO.setBonusDistributeTo(payload.getBonusDistributeTo());
            }
            if (payload.getDistributeDate() != null) {
                crmLeadsDO.setDistributeDate(payload.getDistributeDate());
            }
            if (payload.getCloseReason() != null) {
                crmLeadsDO.setCloseReason(payload.getCloseReason());
            }
            if (payload.getWithdrawReason() != null) {
                crmLeadsDO.setWithdrawReason(payload.getWithdrawReason());
            }
            if (payload.getBackReason() != null) {
                crmLeadsDO.setBackReason(payload.getBackReason());
            }
            if (payload.getNotFollowLeadsRemindTime()!=null){
                crmLeadsDO.setNotFollowLeadsRemindTime(payload.getNotFollowLeadsRemindTime());
            }
            if (payload.getLeadsTagIds() != null){
                crmLeadsDO.setLeadsTagIds(payload.getLeadsTagIds());
            }
            if (payload.getExtString1() != null){
                crmLeadsDO.setExtString1(payload.getExtString1());
            }
            if (payload.getExtString2() != null){
                crmLeadsDO.setExtString2(payload.getExtString2());
            }
            if (payload.getExtString3() != null){
                crmLeadsDO.setExtString3(payload.getExtString3());
            }
            if (payload.getExtString4() != null){
                crmLeadsDO.setExtString4(payload.getExtString4());
            }
            if (payload.getExtString5() != null){
                crmLeadsDO.setExtString5(payload.getExtString5());
            }
            if (payload.getMarketChannel() != null){
                crmLeadsDO.setMarketChannel(payload.getMarketChannel());
            }
            if (payload.getFormalCustomerId() != null){
                crmLeadsDO.setFormalCustomerId(payload.getFormalCustomerId());
            }
            if (payload.getDemandProduct() != null){
                crmLeadsDO.setDemandProduct(payload.getDemandProduct());
            }
            if (payload.getDemandProductOrg() != null){
                crmLeadsDO.setDemandProductOrg(payload.getDemandProductOrg());
            }
            if (payload.getLeadsIdV4() != null){
                crmLeadsDO.setLeadsIdV4(payload.getLeadsIdV4());
            }
            //涉及级联操作
            if (payload.getCustomer() != null) {
                CrmLeadsCustomerDO customerDO = crmLeadsDO.getCustomer();

                CrmLeadsCustomerPayload customer = payload.getCustomer();
                if(customer.getCustomerName() !=null){
                    customerDO.setCustomerName(customer.getCustomerName());
                }
                if(customer.getCustomerIndustry() !=null){
                    customerDO.setCustomerIndustry(customer.getCustomerIndustry());
                }
                if(customer.getCustomerGrade() !=null){
                    customerDO.setCustomerGrade(customer.getCustomerGrade());
                }
                if(customer.getCustomerContacts() !=null){
                    customerDO.setCustomerContacts(customer.getCustomerContacts());
                }
                if(customer.getContactsDepartment() !=null){
                    customerDO.setContactsDepartment(customer.getContactsDepartment());
                }
                if(customer.getContactsPosition() !=null){
                    customerDO.setContactsPosition(customer.getContactsPosition());
                }
                if(customer.getContactsPhone() !=null){
                    customerDO.setContactsPhone(customer.getContactsPhone());
                }
                if(customer.getContactsEmail() !=null){
                    customerDO.setContactsEmail(customer.getContactsEmail());
                }
                if(customer.getCustRegion() !=null){
                    customerDO.setCustRegion(customer.getCustRegion());
                }
                if(customer.getSaleProduct() !=null){
                    customerDO.setSaleProduct(customer.getSaleProduct());
                }
                crmLeadsDO.setCustomer(customerDO);
            }
            // 处理要设置成空的字段
            List<String> nullFields = payload.getNullFields();
            if (nullFields != null && nullFields.size() > 0) {
                if (nullFields.contains("market")) {
                    crmLeadsDO.setMarket(null);
                }
                if (nullFields.contains("channel")) {
                    crmLeadsDO.setChannel(null);
                }
                if (nullFields.contains("saleUserId")) {
                    crmLeadsDO.setSaleUserId(null);
                }
                if (nullFields.contains("bonusDistributeType")) {
                    crmLeadsDO.setBonusDistributeType(null);
                }
                if (nullFields.contains("bonusDistributeTo")) {
                    crmLeadsDO.setBonusDistributeTo(null);
                }
                if (nullFields.contains("closeReason")) {
                    crmLeadsDO.setCloseReason(null);
                }
                if (nullFields.contains("distributeDate")) {
                    crmLeadsDO.setDistributeDate(null);
                }
                if (nullFields.contains("notFollowLeadsRemindTime")) {
                    crmLeadsDO.setNotFollowLeadsRemindTime(null);
                }
            }
            repo.save(crmLeadsDO);
            return 1;
        }
        return 0;
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public Page<CrmLeadsDO> findAll(Specification<CrmLeadsDO> spec, Pageable pageable) {
        pageable= PageUtil.defaultSort(pageable);
        return repo.findAll(spec, pageable);
    }

    public List<CrmLeadsDO> findAll(Specification<CrmLeadsDO> spec) {
        return repo.findAll(spec);
    }

    public CrmLeadsDO queryById(Long id) {
        return repo.findById(id).orElse(null);
    }

    public List<Long> queryByFormalCustomerId(Long customerId) {
        return repo.queryByFormalCustomerId(customerId);
    }

    public List<Long> findNotBindLeads() {
        return repo.findNotBindLeads();
    }

    public void updateCustomerGrade(List<Long> leadsIds,String grade) {
        repo.updateCustomerGrade(leadsIds,grade);
    }

    public CrmLeadsDO findByPotentialCustomerId(Long id) {
        List<CrmLeadsDO> leadsDOS = repo.findByPotentialCustomerIdOrderByCreateTimeDesc(id);
        if(leadsDOS!=null && !leadsDOS.isEmpty()){
            return leadsDOS.get(0);
        }else{
            return null;
        }
    }

    public List<Long> queryNotBindLeads() {
        return repo.queryNotBindLeads();
    }


//    public List<CrmLeadsDO> queryOffshoreLeadsList(Long offshoreId) {
//        return repo.queryOffshoreLeadsList(offshoreId);
//    }

}
