package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreRulePayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreRuleRegainPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreVO;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreMembersConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreRuleAttrExcludeConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreRuleRegainTriggerConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.*;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsOffshoreRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOffshoreRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import javax.persistence.criteria.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class CrmOffshoreDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOffshoreRepo repo;
    private final CrmLeadsOffshoreRepo leadsOffshoreRepo;
    private final QCrmOffshoreDO qdo = QCrmOffshoreDO.crmOffshoreDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOffshoreDO save(CrmOffshoreDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmOffshoreDO> saveAll(List<CrmOffshoreDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结果
     */
    public CrmOffshoreVO queryByKey(Long id){
        JPAQuery<CrmOffshoreVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        return jpaQuery.fetchFirst();
    }




    /**
     * 拼装查询字段
     * @return  jpaQuery对象
     */
    private JPAQuery<CrmOffshoreVO> getJpaQuerySelect() {
        JPAQuery<CrmOffshoreVO> jpaQuery=jpaQueryFactory.select(Projections.bean(CrmOffshoreVO.class,
                qdo.id,
                qdo.offshoreName
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOffshoreVO> getJpaQueryWhere(CrmOffshoreQuery query) {
        JPAQuery<CrmOffshoreVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getOffshoreName())) {
            jpaQuery.where(qdo.offshoreName.eq(query.getOffshoreName()));
        }
//        if (!ObjectUtils.isEmpty(query.getOffshoreAdmin())) {
//            jpaQuery.where(qdo.offshoreAdmin.eq(query.getOffshoreAdmin()));
//        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery,qdo._super,query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 动态查询集合(不分页查询)
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CrmOffshoreVO> queryListDynamic(CrmOffshoreQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.asc("createTime");
        query.setOrders(Arrays.asList(orderItem));
        JPAQuery<CrmOffshoreVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }



    /**
     * 分页查询
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmOffshoreVO> queryPaging(CrmOffshoreQuery query){
        JPAQuery<CrmOffshoreVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<CrmOffshoreVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.<CrmOffshoreVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(CrmOffshorePayload payload) {
        //查询出当前的do
        CrmOffshoreDO offshoreDO = repo.findById(payload.getId()).orElse(null);
        if(offshoreDO!=null){
            if (payload.getOffshoreName() != null) {
                offshoreDO.setOffshoreName(payload.getOffshoreName());
            }
            if (payload.getLeadsNum() != null){
                offshoreDO.setLeadsNum(payload.getLeadsNum());
            }
            //涉及删除
            if (payload.getOffshoreMembers() != null) {
                List<CrmOffshoreMembersDO> offshoreMembers = payload.getOffshoreMembers().stream().map(e -> CrmOffshoreMembersConvert.INSTANCE.toDo(e)).collect(Collectors.toList());
                offshoreMembers = offshoreMembers.stream().filter(e -> {
                    if(e.getDeleteFlag() == 0){
                        return true;
                    }else{
                        offshoreDO.getOffshoreMembers().remove(e);
                        return false;
                    }
                }).collect(Collectors.toList());
                offshoreDO.setOffshoreMembers(offshoreMembers);
            }
            if(payload.getDeleteFlag()!=null){
                offshoreDO.setDeleteFlag(payload.getDeleteFlag());
            }
            if(payload.getOffshoreRule()!=null){
                CrmOffshoreRuleDO offshoreRuleDO = offshoreDO.getOffshoreRule();
                CrmOffshoreRulePayload offshoreRulePayload = payload.getOffshoreRule();
                if(offshoreRulePayload.getDistributeReceiveRule()!=null){
                    offshoreRuleDO.setDistributeReceiveRule(offshoreRulePayload.getDistributeReceiveRule());
                }
                if(offshoreRulePayload.getNewLeadsRemind()!=null){
                    offshoreRuleDO.setNewLeadsRemind(offshoreRulePayload.getNewLeadsRemind());
                }
                if(offshoreRulePayload.getReceiveLeadsLimit()!=null){
                    offshoreRuleDO.setReceiveLeadsLimit(offshoreRulePayload.getReceiveLeadsLimit());
                }
                if(offshoreRulePayload.getReceiveLeadsLimitDays()!=null){
                    offshoreRuleDO.setReceiveLeadsLimitDays(offshoreRulePayload.getReceiveLeadsLimitDays());
                }
                if(offshoreRulePayload.getReceiveLeadsRemind()!=null){
                    offshoreRuleDO.setReceiveLeadsRemind(offshoreRulePayload.getReceiveLeadsRemind());
                }
                if(offshoreRulePayload.getDistributeLeadsRemindTime()!=null){
                    offshoreRuleDO.setDistributeLeadsRemindTime(offshoreRulePayload.getDistributeLeadsRemindTime());
                }
                if(offshoreRulePayload.getFollowLeadsRemindTime()!=null){
                    offshoreRuleDO.setFollowLeadsRemindTime(offshoreRulePayload.getFollowLeadsRemindTime());
                }
                if(offshoreRulePayload.getShowFollowBeforeReceive()!=null){
                    offshoreRuleDO.setShowFollowBeforeReceive(offshoreRulePayload.getShowFollowBeforeReceive());
                }

                if (offshoreRulePayload.getOffshoreRuleAttrExcludes() != null) {
                    List<CrmOffshoreRuleAttrExcludeDO> attrExcludeDOS = offshoreRulePayload.getOffshoreRuleAttrExcludes().stream().map(e -> CrmOffshoreRuleAttrExcludeConvert.INSTANCE.toDo(e)).collect(Collectors.toList());
                    attrExcludeDOS = attrExcludeDOS.stream().filter(e -> {
                        if(e.getDeleteFlag() == 0){
                            return true;
                        }else{
                            offshoreRuleDO.getOffshoreRuleAttrExcludes().remove(e);
                            return false;
                        }
                    }).collect(Collectors.toList());
                    offshoreRuleDO.setOffshoreRuleAttrExcludes(attrExcludeDOS);
                }
                if(offshoreRulePayload.getRegainRule()!=null){
                    CrmOffshoreRuleRegainPayload regainRule = offshoreRulePayload.getRegainRule();
                    CrmOffshoreRuleRegainDO regainRuleDo = offshoreRuleDO.getRegainRule();
                    if(regainRule.getRegainRemindTime() !=null){
                        regainRuleDo.setRegainRemindTime(regainRule.getRegainRemindTime());
                    }
                    if(regainRule.getToThisOffshore() !=null){
                        regainRuleDo.setToThisOffshore(regainRule.getToThisOffshore());
                    }
                    if(regainRule.getTargetOffshore() !=null){
                        regainRuleDo.setTargetOffshore(regainRule.getTargetOffshore());
                    }
                    if(regainRule.getTriggerRules()!=null){
                        List<CrmOffshoreRuleRegainTriggerDO> triggerDOS = regainRule.getTriggerRules().stream().map(e -> CrmOffshoreRuleRegainTriggerConvert.INSTANCE.toDo(e)).collect(Collectors.toList());
                        triggerDOS = triggerDOS.stream().filter(e -> {
                            if(e.getDeleteFlag() == 0){
                                return true;
                            }else{
                                regainRuleDo.getTriggerRules().remove(e);
                                return false;
                            }
                        }).collect(Collectors.toList());
                        regainRuleDo.setTriggerRules(triggerDOS);
                    }
                }
                offshoreDO.setOffshoreRule(offshoreRuleDO);
            }
            repo.save(offshoreDO);
            return 1;
        }
        return 0;
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public Specification<CrmOffshoreDO> getSpec(CrmOffshoreQuery query) {
        Specification<CrmOffshoreDO> querySpecifi = (root, criteriaQuery, cb) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (!ObjectUtils.isEmpty(query.getId())) {
                predicates.add(cb.equal(root.get("id").as(Long.class), query.getId()));
            }
            if (!StringUtils.isEmpty(query.getOffshoreName())) {
                predicates.add(cb.like(root.get("offshoreName").as(String.class), SqlUtil.toSqlLikeString(query.getOffshoreName())));
            }
            if (!StringUtils.isEmpty(query.getOffshoreNameNotEqual())) {
                predicates.add(cb.notEqual(root.get("offshoreName").as(String.class), query.getOffshoreNameNotEqual()));
            }
            Join<CrmOffshoreDO, CrmOffshoreAdminDO> adminJoin = root.join("offshoreAdmins", JoinType.LEFT);
            if (!ObjectUtils.isEmpty(query.getOffshoreAdminId())) {
                predicates.add(cb.equal(adminJoin.get("userId").as(Long.class), query.getOffshoreAdminId()));
            }
            Join<CrmOffshoreDO, CrmOffshoreMembersDO> memberJoin = root.join("offshoreMembers", JoinType.LEFT);
            if (!ObjectUtils.isEmpty(query.getMemberId())){
                predicates.add(cb.equal(memberJoin.get("userId").as(Long.class),query.getMemberId()));
            }
            Join<CrmOffshoreDO, CrmOffshoreRuleDO> ruleJoin = root.join("offshoreRule", JoinType.LEFT);
            if(!ObjectUtils.isEmpty(query.getDistributeReceiveRule())){
                predicates.add(cb.equal(ruleJoin.get("distributeReceiveRule").as(String.class),query.getDistributeReceiveRule()));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };

        return querySpecifi;
    }

    public List<CrmOffshoreDO> findAll(Specification<CrmOffshoreDO> spec) {
        return repo.findAll(spec);
    }

    public Page<CrmOffshoreDO> findAll(Specification<CrmOffshoreDO> spec, Pageable pageable) {
        pageable= PageUtil.defaultSort(pageable);
        return repo.findAll(spec, pageable);
    }

    public CrmOffshoreDO queryById(Long id) {
        return repo.findById(id).orElse(null);
    }

    public int countByOffshoreAdmin(Long userId) {
        CrmOffshoreQuery query=new CrmOffshoreQuery();
        query.setOffshoreAdminId(userId);
        Specification<CrmOffshoreDO> spec = getSpec(query);
        long count = repo.count(spec);
        return Integer.parseInt(String.valueOf(count));
    }

//    public List<CrmOffshoreDO> queryByOffshoreAdminId(Long userId) {
//        CrmOffshoreQuery offshoreQuery=new CrmOffshoreQuery();
//        offshoreQuery.setOffshoreAdminId(userId);
//        //return repo.findByOffshoreAdminId(userId);
//    }

    public CrmOffshoreDO queryByOffshoreName(String offshoreName) {
        return repo.findByOffshoreName(offshoreName);
    }

    public int countLeads(Long offshoreId) {
        return leadsOffshoreRepo.countByOffshore_Id(offshoreId);
    }

    public List<CrmLeadsOffshoreDO> queryOffshoreLeads(Long offshoreId) {
        return leadsOffshoreRepo.findByOffshore_Id(offshoreId);
    }

    public List<Long> queryOffshoreIdsByName(List<String> toList) {
        return repo.queryOffshoreIdsByName(toList);
    }
}
