package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunitySimpleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.*;
import com.elitesland.tw.tw5.server.prd.crm.repo.*;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectMemberDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityRepo repo;
    private final CrmOpportunitySalesRepo repoSales;
    private final CrmOpportunityStakeholderRepo repoStakeholder;
    private final CrmOpportunityPartnerRepo repoPartner;
    private final CrmOpportunityCompetitorRepo repoCompetitor;
    private final CrmOpportunityAnalyzeRepo repoAnalyze;

    private final QCrmOpportunityDO qdo = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrjProjectDO qdoProject = QPrjProjectDO.prjProjectDO;
    private final QPrjProjectDO qdoProject1 = new QPrjProjectDO("qdoProject1");
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    private final QPrjProjectMemberDO qdoMember = QPrjProjectMemberDO.prjProjectMemberDO;
    private final QCrmActActivityDO qdoActivity = QCrmActActivityDO.crmActActivityDO;

    private final QCrmOpportunitySalesDO qdoSales = QCrmOpportunitySalesDO.crmOpportunitySalesDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOpportunityDO save(CrmOpportunityDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActProjectVO> getJpaQuerySelectProject() {
        JPAQuery<CrmActProjectVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActProjectVO.class,
                qdoProject.id,
                qdoProject.projectName,
                qdoProject.projectNo,
                qdoProject.manageUserId,
                qdoProject.projectStatus,
                qdoProject.closeReason,
                qdoEmployee.employeeName.as("manageUserName"),
                qdo.codeliUserId,
                qdo.oppoIdV4,
                qdo.deliUserId,
                qdo.preSaleUserId,
                qdo.coUserId,
                qdoProject.createUserId,
                qdoProject.creator,
                qdoProject.createTime
        )).from(qdo).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue())).leftJoin(qdoEmployee).on(qdoEmployee.userId.longValue().eq(qdoProject.manageUserId.longValue()));
        return jpaQuery;
    }

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public CrmActProjectVO queryProjectBykey(Long key) {
        JPAQuery<CrmActProjectVO> jpaQuery = getJpaQuerySelectProject();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public List<CrmActProjectVO> queryListByCustomId(Long customId) {
        JPAQuery<CrmActProjectVO> jpaQuery = getJpaQuerySelectProject();
        jpaQuery.where(qdo.custBookId.eq(customId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象项目
     * @return 修改的行数
     */
    public long updateProjectByKeyDynamic(CrmOpportunityPayload payload, Long projectId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoProject)
                .where(qdoProject.id.eq(projectId));
        if (payload.getProjectName() != null) {
            update.set(qdoProject.projectName, payload.getProjectName());
        }
        if (payload.getManageUserId() != null) {
            update.set(qdoProject.manageUserId, payload.getManageUserId());
        }
        if (payload.getOrgId() != null) {
            update.set(qdoProject.orgId, payload.getOrgId());
        }
        if (payload.getCompanyId() != null) {
            update.set(qdoProject.companyId, payload.getCompanyId());
        }
        if (payload.getFileCodes() != null) {
            update.set(qdoProject.fileCodes, payload.getFileCodes());
        }
        if (payload.getLoseReason() != null) {
            update.set(qdoProject.loseReason, payload.getLoseReason());
        }
        if (payload.getCloseReason() != null) {
            update.set(qdoProject.closeReason, payload.getCloseReason());
        }
        if (payload.getClsoeRemark() != null) {
            update.set(qdoProject.clsoeRemark, payload.getClsoeRemark());
        }
        if (payload.getProjectStatus() != null) {
            update.set(qdoProject.projectStatus, payload.getProjectStatus());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("closeReason")) {
                update.setNull(qdoProject.closeReason);
            }
        }
        // 执行修改
        return update.execute();
    }


    @Transactional
    public long updateByKeyDynamic(CrmOpportunityPayload opportunityPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(opportunityPayload.getId()));
        if (opportunityPayload.getFormalCustomerId() != null) {
            update.set(qdo.formalCustomerId, opportunityPayload.getFormalCustomerId());
        }
        if (opportunityPayload.getItemId() != null) {
            update.set(qdo.itemId, opportunityPayload.getItemId());
        }
        return update.execute();
    }


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunitySimpleVO> getJpaQuerySelectSimple() {
        JPAQuery<CrmOpportunitySimpleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmOpportunitySimpleVO.class,
                qdo.id,
                qdo.projectId,
                qdo.actId,
                qdoProject1.projectName.as("actName"),
                qdo.itemId,
                qdoProject.projectName,
                qdoProject.projectNo
//                qdoProject.orgId,
//                qdoProject.manageUserId,
//                qdoProject.companyId,
//                qdoProject.fileCodes,
//                qdoProject.projectStatus,
//                qdoProject.closeReason,
//                qdoProject.loseReason,
//                qdoProject.clsoeRemark,
//                qdo.leadsId,
//                qdoLeads.leadsName,
//                qdo.saleProduct,
//                qdo.custRegion,
//                qdo.isOldCust,
//                qdo.custBookId,
//                qdo.custBookName,
//                qdo.custProject,
//                qdo.contactName,
//                qdo.contactPhone,
//                qdo.contactDept,
//                qdo.contactPosition,
//                qdo.contactWebsite,
//                qdo.custProp,
//                qdo.custIdst,
//                qdo.forecastWinDate,
//                qdo.forecastAmount,
//                qdo.probability,
//                qdo.currCode,
//                qdo.salePhase,
//                qdo.deliveryAddress,
//                qdo.oppoLevel,
//                qdo.isNeedPartner,
//                qdo.coopBookId,
//                qdo.coopBookName,
//                qdo.partnerDesc,
//
//                qdo.preSaleOrgId,
//                qdo.preSaleUserId,
//                qdo.projectDifficult,
//                qdo.projectImportance,
//                qdo.deliOrgId,
//                qdo.deliUserId,
//                qdo.solutionDifficulty,
//                qdo.solutionImportance,
//                qdo.coOrgId,
//                qdo.coUserId,
//                qdo.codeliOrgId,
//                qdo.codeliUserId,
//                qdo.sourceType,
//                qdo.internalOrgId,
//                qdo.internalUserId,
//                qdo.externalIden,
//                qdo.externalName,
//                qdo.externalPhone,
//                qdo.profitDesc,
//                qdo.extString1,
//                qdo.extString2,
//                qdo.extString3,
//                qdo.extString4,
//                qdo.extString5,
//                qdo.remark,
//                qdo.oppoIdV4,
//                qdo.checkStatus,
//                qdoProject.createUserId,
//                qdoProject.creator,
//                qdoProject.createTime
            )).from(qdo).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue()))
            .leftJoin(qdoLeads).on(qdoLeads.id.longValue().eq(qdo.leadsId.longValue()))
            .leftJoin(qdoProject1).on(qdoProject1.id.longValue().eq(qdo.actId.longValue()))
            .leftJoin(qdoMember).on(qdoMember.projectId.longValue().eq(qdoProject.id.longValue()));
        return jpaQuery;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityVO> getJpaQuerySelect() {
        JPAQuery<CrmOpportunityVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmOpportunityVO.class,
                qdo.id,
                qdo.projectId,
                qdo.actId,
                qdoProject1.projectName.as("actName"),
                qdo.itemId,
                qdoProject.projectName,
                qdoProject.projectNo,
                qdoProject.orgId,
                qdoProject.manageUserId,
                qdoProject.companyId,
                qdoProject.fileCodes,
                qdoProject.projectStatus,
                qdoProject.closeReason,
                qdoProject.loseReason,
                qdoProject.clsoeRemark,
                qdo.leadsId,
                qdoLeads.leadsName,
                qdo.saleProduct,
                qdo.custRegion,
                qdo.isOldCust,
                qdo.custBookId,
                qdo.custBookName,
                qdo.custProject,
                qdo.contactName,
                qdo.contactPhone,
                qdo.contactDept,
                qdo.contactPosition,
                qdo.contactWebsite,
                qdo.custProp,
                qdo.custIdst,
                qdo.forecastWinDate,
                qdo.forecastAmount,
                qdo.probability,
                qdo.currCode,
                qdo.salePhase,
                qdo.deliveryAddress,
                qdo.oppoLevel,
                qdo.isNeedPartner,
                qdo.coopBookId,
                qdo.coopBookName,
                qdo.partnerDesc,

                qdo.preSaleOrgId,
                qdo.preSaleUserId,
                qdo.projectDifficult,
                qdo.projectImportance,
                qdo.deliOrgId,
                qdo.deliUserId,
                qdo.solutionDifficulty,
                qdo.solutionImportance,
                qdo.coOrgId,
                qdo.coUserId,
                qdo.codeliOrgId,
                qdo.codeliUserId,
                qdo.sourceType,
                qdo.internalOrgId,
                qdo.internalUserId,
                qdo.externalIden,
                qdo.externalName,
                qdo.externalPhone,
                qdo.profitDesc,
                qdo.extString1,
                qdo.extString2,
                qdo.extString3,
                qdo.extString4,
                qdo.extString5,
                qdo.remark,
                qdo.oppoIdV4,
                qdo.checkStatus,
                qdoProject.createUserId,
                qdoProject.creator,
                qdoProject.createTime
        )).from(qdo).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue()))
                .leftJoin(qdoLeads).on(qdoLeads.id.longValue().eq(qdo.leadsId.longValue()))
                .leftJoin(qdoProject1).on(qdoProject1.id.longValue().eq(qdo.actId.longValue()))
                .leftJoin(qdoMember).on(qdoMember.projectId.longValue().eq(qdoProject.id.longValue()));
        return jpaQuery;
    }

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public CrmOpportunityVO queryByKey(Long key) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public CrmOpportunityDO queryByKeySimple(Long key) {
        CrmOpportunityDO entity = repo.findById(key).orElseGet(CrmOpportunityDO::new);
        return entity;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunitySimpleVO> getJpaQueryWhereSimple(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunitySimpleVO> jpaQuery = getJpaQuerySelectSimple();
        whereCommon(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList, jpaQuery);
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityVO> getJpaQueryWhere(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQuerySelect();
        whereCommon(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList, jpaQuery);
        return jpaQuery;
    }

    private void whereCommon(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList, JPAQuery jpaQuery) {
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoProject.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getManageUserId())) {
            jpaQuery.where(qdoProject.manageUserId.eq(query.getManageUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qdoProject.createUserId.eq(query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectNameOrNo())) {
            jpaQuery.where(qdoProject.projectName.like(SqlUtil.toSqlLikeString(query.getProjectNameOrNo())).or(qdoProject.projectNo.like(SqlUtil.toSqlLikeString(query.getProjectNameOrNo()))));
        }
        if (!ObjectUtils.isEmpty(query.getForecastWinDateRange())) {
            LocalDate startDate = null;
            LocalDate endDate = null;
            if ("0".equals(query.getForecastWinDateRange())) {
                endDate = LocalDate.now().plusMonths(3);
            }
            if ("1".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(3);
            }
            if ("2".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(6);
            }
            if (startDate != null) {
                jpaQuery.where(qdo.forecastWinDate.goe(startDate));
            }
            if (endDate != null) {
                jpaQuery.where(qdo.forecastWinDate.loe(endDate));
            }
        }
        if (!ObjectUtils.isEmpty(query.getPreSaleOrgId())) {
            jpaQuery.where(qdo.preSaleOrgId.eq(query.getPreSaleOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getPreSaleUserId())) {
            jpaQuery.where(qdo.preSaleUserId.eq(query.getPreSaleUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getDeliOrgId())) {
            jpaQuery.where(qdo.deliOrgId.eq(query.getDeliOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            jpaQuery.where(qdo.deliUserId.eq(query.getDeliUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getCustRegion())) {
            jpaQuery.where(qdo.custRegion.eq(query.getCustRegion()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectStatus())) {
            if ("0".equals(query.getProjectStatusType())) {
                jpaQuery.where(qdoProject.projectStatus.eq(query.getProjectStatus()));
            } else {
                jpaQuery.where(qdoProject.projectStatus.ne(query.getProjectStatus()));
            }
        }
        if (!ObjectUtils.isEmpty(query.getCustBookName())) {
            jpaQuery.where(qdo.custBookName.like(SqlUtil.toSqlLikeString(query.getCustBookName())));
        }
        if (!ObjectUtils.isEmpty(query.getOppoLevel())) {
            jpaQuery.where(qdo.oppoLevel.eq(query.getOppoLevel()));
        }
        if (!ObjectUtils.isEmpty(query.getLeadsId())) {
            jpaQuery.where(qdo.leadsId.eq(query.getLeadsId()));
        }
        if (!ObjectUtils.isEmpty(query.getCoopBookId())) {
            jpaQuery.where(qdo.coopBookId.eq(query.getCoopBookId()));
        }

        if (!ObjectUtils.isEmpty(query.getCoopBookName())) {
            jpaQuery.where(qdo.coopBookName.like(SqlUtil.toSqlLikeString(query.getCoopBookName())));
        }
        if (!ObjectUtils.isEmpty(query.getCoOrgId())) {
            jpaQuery.where(qdo.coOrgId.eq(query.getCoOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getCodeliOrgId())) {
            jpaQuery.where(qdo.codeliOrgId.eq(query.getCodeliOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getInternalOrgId())) {
            jpaQuery.where(qdo.internalOrgId.eq(query.getInternalOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getInternalUserId())) {
            jpaQuery.where(qdo.internalUserId.eq(query.getInternalUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getCustIdst())) {
            jpaQuery.where(qdo.custIdst.eq(query.getCustIdst()));
        }
        if (!ObjectUtils.isEmpty(query.getFormalCustomerId())) {
            jpaQuery.where(qdo.formalCustomerId.eq(query.getFormalCustomerId()));
        }
        if (oppoUserIds != null && !oppoUserIds.isEmpty()) {
            Predicate temp = qdoMember.userId.in(oppoUserIds).or(qdoProject.manageUserId.in(oppoUserIds)).or(qdoProject.orgId.in(orgManageIds)).or(qdo.preSaleOrgId.in(orgManageIds))
                    .or(qdo.deliOrgId.in(orgManageIds)).or(qdo.coOrgId.in(orgManageIds)).or(qdo.codeliOrgId.in(orgManageIds)).or(qdo.internalOrgId.in(orgManageIds));
            if (CollectionUtils.isNotEmpty(sapPermissionOrgIdList)){
                temp = ExpressionUtils.or(temp, qdo.preSaleOrgId.in(sapPermissionOrgIdList).or(qdo.deliOrgId.in(sapPermissionOrgIdList)));
            }
            jpaQuery.where(temp);
            jpaQuery.where(qdoMember.deleteFlag.eq(0));
        }

        if (!ObjectUtils.isEmpty(query.getOppoIds())) {
            jpaQuery.where(qdo.id.in(query.getOppoIds()));
//            jpaQuery.where(qdo.id.eq(1020l));
        }
        if (!ObjectUtils.isEmpty(query.getOppoIdsV4())) {
            jpaQuery.where(qdo.oppoIdV4.in(query.getOppoIdsV4()));
//            jpaQuery.where(qdo.id.eq(1020l));
        }
        if (!ObjectUtils.isEmpty(query.getSourceType())) {
            jpaQuery.where(qdo.sourceType.eq(query.getSourceType()));
        }
        if (StringUtils.isNotBlank(query.getCheckStatus())){
            jpaQuery.where(qdo.checkStatus.eq(query.getCheckStatus()));
        }
        jpaQuery.groupBy(qdoProject.id);
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmOpportunityVO> queryPaging(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQueryWhere(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        QueryResults<CrmOpportunityVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<CrmOpportunityVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public List<CrmOpportunitySimpleVO> queryListSimple(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunitySimpleVO> jpaQuery = getJpaQueryWhereSimple(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        return jpaQuery.fetch();
    }

//    /**
//     * sap部门 单独查询逻辑
//     * @param query 前端查询参数
//     * @param sapPermissionOrgIdList sap部门权限 orgId
//     * @param userId 登录用户id
//     * @return
//     */
//    @Deprecated
//    public PagingVO<CrmOpportunityVO> queryPagingForSap(CrmOpportunityQuery query, List<Long> sapPermissionOrgIdList, long userId) {
//        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQueryWhere(query, null, null);
//        if (CollectionUtils.isNotEmpty(sapPermissionOrgIdList)){
//            jpaQuery.where(qdo.preSaleOrgId.in(sapPermissionOrgIdList).or(qdo.deliOrgId.in(sapPermissionOrgIdList)));
//        } else {
//            jpaQuery.where(qdo.preSaleUserId.eq(userId));
//        }
//        QueryResults<CrmOpportunityVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
//        System.out.println(result.getTotal());
//        return PagingVO.<CrmOpportunityVO>builder().records(result.getResults()).total(result.getTotal()).build();
//    }

    public List<CrmOpportunityVO> queryList(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQueryWhere(query, oppoUserIds, orgManageIds, null);
        return jpaQuery.fetch();
    }

    /**
     * 修改流程状态
     *
     * @param key 主键
     * @return
     */
    public long updateStatus(Long key, String projectStatus) {

        JPAUpdateClause update = jpaQueryFactory.update(qdoProject)
                .set(qdoProject.projectStatus, projectStatus);
        update.where(qdoProject.id.eq(key));
        return update.execute();
    }

    /**
     * 获取员工数据
     *
     * @param userIds
     * @return
     */
    public List<Map<String, Object>> queryEmployees(Set<Long> userIds) {
        return repo.queryEmployees(userIds);
    }

    /**
     * 获取组织数据
     *
     * @param orgIds
     * @return
     */
    public List<Map<String, Object>> queryOrgs(Set<Long> orgIds) {
        return repo.queryOrgs(orgIds);
    }

    /**
     * 获取地址簿数据
     *
     * @param bookIds
     * @return
     */
    public List<Map<String, Object>> queryBooks(Set<Long> bookIds) {
        return repo.queryBooks(bookIds);
    }


    public List<Long> queryByFormalCustomerId(Long customerId) {
        return repo.queryByFormalCustomerId(customerId);
    }

    public List<Long> findNotBindOppos() {
        return repo.findNotBindOppos();
    }

    public Long getIdByV4(Long oppoIdV4) {
        return repo.getIdByV4(oppoIdV4) == null ? null : repo.getIdByV4(oppoIdV4).get(0);
    }


    public void deleteSoft(Long id) {
        repo.deleteSoft(id);
    }

    public List<Map<String, Object>> getV4AndV5OppoIds() {
        return repo.getV4AndV5OppoIds();
    }
}
