package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.*;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Set;

/**
 * 人脉
 *
 * @author carl
 * @date 2022/11/21
 */
@Repository
@RequiredArgsConstructor
public class CrmPeopleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmPeopleRepo repo;
    private final QCrmPeopleDO qdo = QCrmPeopleDO.crmPeopleDO;
    private final QCrmCustomerOperationDO qdoOperation = QCrmCustomerOperationDO.crmCustomerOperationDO;
    private final QCrmCustomerDO qdoCustomer = QCrmCustomerDO.crmCustomerDO;
    private final QCrmCustomerOperationMemberDO qdoOperationMember = QCrmCustomerOperationMemberDO.crmCustomerOperationMemberDO;
    private final QCrmOperationPlanDetailDO qdoOperationPlanDetail = QCrmOperationPlanDetailDO.crmOperationPlanDetailDO;
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    private final QCrmOpportunityDO qdoOpportunity = QCrmOpportunityDO.crmOpportunityDO;

    /**
     * 查询权限允许的客户经营ids
     *
     * @return
     */
    public List<Long> queryOperationIds(Long userId, Set<Long> empRefUserIdList, Set<Long> orgIdList) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoOperation.id).from(qdoOperation).leftJoin(qdoOperationMember).on(qdoOperationMember.operId.eq(qdoOperation.id).and(qdoOperationMember.deleteFlag.eq(0))).leftJoin(qdoOperationPlanDetail).on(qdoOperationPlanDetail.operId.eq(qdoOperation.id).and(qdoOperationPlanDetail.deleteFlag.eq(0)));
        BooleanExpression jpaQueryOr = qdoOperationMember.userId.eq(userId).or(qdoOperationPlanDetail.performerId.eq(userId)).or(qdoOperation.createUserId.eq(userId))
                .or(qdoOperation.saleOperManagerId.eq(userId)).or(qdoOperation.custOperManagerId.eq(userId)).or(qdoOperation.channelUserId.eq(userId))
                .or(qdoOperation.productUserId.eq(userId)).or(qdoOperation.serviceUserId.eq(userId)).or(qdoOperation.businessUserId.eq(userId))
                .or(qdoOperation.careUserId.eq(userId)).or(qdoOperation.operationUserId.eq(userId));
        if (!CollectionUtils.isEmpty(empRefUserIdList)) {
            jpaQueryOr = jpaQueryOr.or(qdoOperation.serviceUserId.in(empRefUserIdList)).or(qdoOperation.businessUserId.in(empRefUserIdList)).or(qdoOperation.careUserId.in(empRefUserIdList)).or(qdoOperation.operationUserId.in(empRefUserIdList));

        }
        if (!CollectionUtils.isEmpty(orgIdList)) {
            jpaQueryOr = jpaQueryOr.or(qdoOperation.custOperBu.in(orgIdList)).or(qdoOperation.saleOperBu.in(orgIdList));
        }

        jpaQuery.where(jpaQueryOr).where(qdoOperation.deleteFlag.eq(0));

        return jpaQuery.distinct().fetch();

    }

    /**
     * 查询权限允许的客户ids
     *
     * @return 对象
     */
    public List<Long> queryCustomerIds(CrmCustomerQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoCustomer.id).from(qdoCustomer).leftJoin(qdoLeads).on(qdoLeads.formalCustomerId.longValue().eq(qdoCustomer.id.longValue()))
                .leftJoin(qdoOpportunity).on(qdoOpportunity.formalCustomerId.longValue().eq(qdoCustomer.id.longValue()));
        if (!ObjectUtils.isEmpty(query.getCreateUserIds())) {
            jpaQuery.where(qdoCustomer.createUserId.in(query.getCreateUserIds()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qdoCustomer.createUserId.eq(query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerGrades())) {
            jpaQuery.where(qdoCustomer.customerGrade.in(query.getCustomerGrades()).or(qdoCustomer.customerGrade.isNull()));
        }
        if (!ObjectUtils.isEmpty(query.getFilterType())) {
            if (query.getFilterType().equals("sales")) {
                jpaQuery.where(qdoOpportunity.leadsId.isNull().or(qdoLeads.sourceType.eq("personal")).or(qdoOpportunity.sourceType.eq("INTERNAL")));
            } else if (query.getFilterType().equals("market")) {
                jpaQuery.where(qdoLeads.sourceType.eq("market").or(qdoOpportunity.sourceType.eq("EXTERNAL")));
//                jpaQuery.where(qdoLeads.sourceType.eq("market").or(qdoLeads1.sourceType.eq("market")));
            }
        }

        return jpaQuery.distinct().fetch();
    }

    private JPAQuery<CrmPeopleVO> getJpaQuerySelect() {
        JPAQuery<CrmPeopleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmPeopleVO.class,
                qdo.id,
                qdo.operId,
                qdo.customerId,
                qdo.peopleName,
                qdo.jobs,
                qdo.birthday,
                qdo.companyName,
                qdoOperation.custType,
                qdoOperation.custName.as("operationName"),
                qdoCustomer.customerName,
                qdo.sex,
                qdo.email,
                qdo.loveLevel,
                qdo.mobile,
                qdo.tags,
                qdo.locationDetail,
                qdo.remark,
                qdo.weChat,
                qdo.jobDetail,
                qdo.industry,
                qdo.industryInfluence,
                qdo.birthplace,
                qdo.bu,
                qdo.socialIdentity,
                qdo.marital,
                qdo.spouseJobs,
                qdo.childAge,
                qdo.parentHealth,
                qdo.parentHabitation,
                qdo.peopleStatus,

                qdo.createUserId,
                qdo.creator,
                qdo.createTime
        )).from(qdo).leftJoin(qdoOperation).on(qdo.operId.eq(qdoOperation.id)).leftJoin(qdoCustomer).on(qdo.customerId.eq(qdoCustomer.id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery;
    }

    /**
     * 主键查询
     *
     * @param id
     * @return
     */
    public CrmPeopleVO queryByKey(Long id) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0)).where(qdo.id.eq(id));
        return jpaQuerySelect.fetchFirst();
    }

    /**
     * 主键查询
     *
     * @param ids
     * @return
     */
    public List<CrmPeopleVO> queryListByKeys(List<Long> ids) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0)).where(qdo.id.in(ids));
        return jpaQuerySelect.fetch();
    }

    /**
     * 主键查询
     *
     * @param id
     * @return
     */
    public CrmPeopleDO findByIdAndDeleteFlag(Long id) {
        return jpaQueryFactory.select(qdo).from(qdo).where(qdo.deleteFlag.eq(0)).where(qdo.id.eq(id)).fetchFirst();

    }


    /**
     * 列表查询
     *
     * @return
     */
    public List<CrmPeopleVO> queryList(Long operId, Long customerId) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0));
        if (!ObjectUtils.isEmpty(customerId)) {
            jpaQuerySelect.where(qdo.customerId.eq(customerId));
        } else {
            jpaQuerySelect.where(qdo.operId.eq(operId));
        }
        return jpaQuerySelect.fetch();
    }

    /**
     * 列表查询
     *
     * @return
     */
    public List<CrmPeopleVO> queryListByOperIds(List<Long> operIds) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0));
        jpaQuerySelect.where(qdo.operId.in(operIds));
        return jpaQuerySelect.fetch();
    }

    /**
     * 列表查询
     *
     * @return
     */
    public PagingVO<CrmPeopleVO> paging(CrmPeopleQuery query) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0));
        if (StringUtils.hasText(query.getPeopleName())) {
            jpaQuerySelect.where(qdo.peopleName.like(SqlUtil.toSqlLikeString(query.getPeopleName())));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerId()) && !ObjectUtils.isEmpty(query.getOperId())) {
            jpaQuerySelect.where(qdo.customerId.eq(query.getCustomerId()).or(qdo.operId.eq(query.getOperId())));
        } else if (!ObjectUtils.isEmpty(query.getCustomerId())) {
            jpaQuerySelect.where(qdo.customerId.eq(query.getCustomerId()));
        } else if (!ObjectUtils.isEmpty(query.getOperId())) {
            jpaQuerySelect.where(qdo.operId.eq(query.getOperId()));
        }
//        else {
//            if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
//                //表示不是管理员，需要验证权限
//                if (!ObjectUtils.isEmpty(query.getOperIds()) && !ObjectUtils.isEmpty(query.getCustomerIds())) {
//                    jpaQuerySelect.where(qdo.operId.in(query.getOperIds()).or(qdo.customerId.in(query.getCustomerIds())).or(qdo.createUserId.eq(query.getCreateUserId())));
//                } else {
//                    if (!ObjectUtils.isEmpty(query.getOperIds())) {
//                        jpaQuerySelect.where(qdo.operId.in(query.getOperIds()).or(qdo.createUserId.eq(query.getCreateUserId())));
//                    } else if (!ObjectUtils.isEmpty(query.getCustomerIds())) {
//                        jpaQuerySelect.where(qdo.customerId.in(query.getCustomerIds()).or(qdo.createUserId.eq(query.getCreateUserId())));
//                    } else {
//                        jpaQuerySelect.where(qdo.createUserId.eq(query.getCreateUserId()));
//                    }
//                }
//            }
//        }
        if (!query.getNoPermissionFlag()) {
            //需要权限
            BooleanExpression jpaQueryOr = qdo.createUserId.eq(query.getCreateUserId());
            if (!ObjectUtils.isEmpty(query.getOperIds())) {
                jpaQueryOr = jpaQueryOr.or(qdo.operId.in(query.getOperIds()));
            }
            if (!ObjectUtils.isEmpty(query.getCustomerIds())) {
                jpaQueryOr = jpaQueryOr.or(qdo.customerId.in(query.getCustomerIds()));
            }
            jpaQuerySelect.where(jpaQueryOr);
        }
        if (StringUtils.hasText(query.getCustomerName())) {
            jpaQuerySelect.where(qdoOperation.custName.like(SqlUtil.toSqlLikeString(query.getPeopleName())).or(qdoCustomer.customerName.like(SqlUtil.toSqlLikeString(query.getPeopleName()))));
        }
        if (StringUtils.hasText(query.getPeopleStatus())) {
            jpaQuerySelect.where(qdo.peopleStatus.eq(query.getPeopleStatus()));
        }
        if (StringUtils.hasText(query.getBu())) {
            jpaQuerySelect.where(qdo.bu.like(SqlUtil.toSqlLikeString(query.getBu())));
        }
        if (StringUtils.hasText(query.getJobs())) {
            jpaQuerySelect.where(qdo.jobs.like(SqlUtil.toSqlLikeString(query.getJobs())));
        }
        if (StringUtils.hasText(query.getIndustry())) {
            jpaQuerySelect.where(qdo.industry.eq(query.getIndustry()));
        }
        if (StringUtils.hasText(query.getWeChat())) {
            jpaQuerySelect.where(qdo.weChat.like(SqlUtil.toSqlLikeString(query.getWeChat())));
        }
        if (StringUtils.hasText(query.getEmail())) {
            jpaQuerySelect.where(qdo.email.like(SqlUtil.toSqlLikeString(query.getEmail())));
        }
        if (StringUtils.hasText(query.getMobile())) {
            jpaQuerySelect.where(qdo.mobile.like(SqlUtil.toSqlLikeString(query.getMobile())));
        }
        if (StringUtils.hasText(query.getLocationDetail())) {
            jpaQuerySelect.where(qdo.locationDetail.like(SqlUtil.toSqlLikeString(query.getLocationDetail())));
        }
//        // 常用基础查询条件拼装
//        SqlUtil.handleCommonJpaQuery(jpaQuerySelect, qdo._super, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        QueryResults<CrmPeopleVO> result = jpaQuerySelect.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<CrmPeopleVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 逻辑删除
     *
     * @param keys
     */
    public void deleteByIdIn(List<Long> keys) {
        JPAUpdateClause where = jpaQueryFactory.update(qdo).set(qdo.deleteFlag, 1).where(qdo.id.in(keys));
        where.execute();
    }

    /**
     * 关联客户
     *
     * @param ids        主键
     * @param customerId
     */
    public void relationCustomer(List<Long> ids, Long customerId) {
        JPAUpdateClause where = jpaQueryFactory.update(qdo).set(qdo.customerId, customerId).where(qdo.id.in(ids));
        where.execute();
    }

    /**
     * 查询客户经营下的所有人脉
     *
     * @param operId 客户经营id
     * @return
     */
    public List<Long> findByOperIdAndDeleteFlag(Long operId) {
        return jpaQueryFactory.select(qdo.id).from(qdo).where(qdo.deleteFlag.eq(0)).where(qdo.operId.eq(operId)).fetch();

    }

    /**
     * 移除所有关系
     *
     * @param keys
     */
    public void removeAllByIdIn(List<Long> keys) {
        JPAUpdateClause where = jpaQueryFactory.update(qdo).setNull(qdo.customerId).setNull(qdo.companyName).setNull(qdo.operId).where(qdo.id.in(keys));
        where.execute();
    }

    /**
     * 移除客户经营关系
     *
     * @param keys
     */
    public void removeOperByIdIn(List<Long> keys) {
        JPAUpdateClause where = jpaQueryFactory.update(qdo).setNull(qdo.companyName).setNull(qdo.operId).where(qdo.id.in(keys));
        where.execute();
    }

    /**
     * 更新爱心等级
     *
     * @param key
     * @param level
     */
    public long updateLoveLevel(Long key, Integer level) {
        JPAUpdateClause where = jpaQueryFactory.update(qdo).set(qdo.loveLevel, level).where(qdo.id.eq(key));
        return where.execute();
    }

    /**
     * 同行人脉
     *
     * @return
     */
    public List<CrmPeopleVO> queryPeopleVOType1(Long id, String industry, String searchStr) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0)).where(qdo.industry.eq(industry)).where(qdo.id.ne(id));
        if (StringUtils.hasText(searchStr)) {
            jpaQuerySelect.where(qdo.jobs.like(SqlUtil.toSqlLikeString(searchStr)).or(qdo.peopleName.like(SqlUtil.toSqlLikeString(searchStr))).or(qdo.companyName.like(SqlUtil.toSqlLikeString(searchStr))).or(qdoOperation.custName.like(SqlUtil.toSqlLikeString(searchStr))).or(qdoCustomer.customerName.like(SqlUtil.toSqlLikeString(searchStr))));
        }
        return jpaQuerySelect.fetch();
    }


    /**
     * 现在同事
     *
     * @return
     */
    public List<CrmPeopleVO> queryPeopleVOType2(Long id, Long operId, Long customerId, String companyName, String searchStr) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0)).where(qdo.id.ne(id));
        if (operId != null && customerId != null) {
            jpaQuerySelect.where(qdo.operId.eq(operId).or(qdo.customerId.eq(customerId)));
        } else {
            if (operId != null) {
                jpaQuerySelect.where(qdo.operId.eq(operId));
            } else if (customerId != null) {
                jpaQuerySelect.where(qdo.customerId.eq(customerId));
            } else {
                jpaQuerySelect.where(qdo.companyName.eq(companyName));
            }
        }
        if (StringUtils.hasText(searchStr)) {
            jpaQuerySelect.where(qdo.jobs.like(SqlUtil.toSqlLikeString(searchStr)).or(qdo.peopleName.like(SqlUtil.toSqlLikeString(searchStr))).or(qdo.companyName.like(SqlUtil.toSqlLikeString(searchStr))).or(qdoOperation.custName.like(SqlUtil.toSqlLikeString(searchStr))).or(qdoCustomer.customerName.like(SqlUtil.toSqlLikeString(searchStr))));
        }
        return jpaQuerySelect.fetch();
    }


    /**
     * 过往同事
     *
     * @return
     */
    public List<CrmPeopleVO> queryPeopleVOType3(Long id, List<Long> customerIds, List<String> companyNames, String searchStr) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0)).where(qdo.id.ne(id));
        if (!ObjectUtils.isEmpty(customerIds) && !ObjectUtils.isEmpty(companyNames)) {
            jpaQuerySelect.where(qdo.customerId.in(customerIds).or(qdo.companyName.in(companyNames)));
        } else {
            if (!ObjectUtils.isEmpty(customerIds)) {
                jpaQuerySelect.where(qdo.customerId.in(customerIds));
            } else if (!ObjectUtils.isEmpty(companyNames)) {
                jpaQuerySelect.where(qdo.companyName.in(companyNames));
            }
        }
        if (StringUtils.hasText(searchStr)) {
            jpaQuerySelect.where(qdo.jobs.like(SqlUtil.toSqlLikeString(searchStr)).or(qdo.peopleName.like(SqlUtil.toSqlLikeString(searchStr))).or(qdo.companyName.like(SqlUtil.toSqlLikeString(searchStr))).or(qdoOperation.custName.like(SqlUtil.toSqlLikeString(searchStr))).or(qdoCustomer.customerName.like(SqlUtil.toSqlLikeString(searchStr))));
        }
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询职位相同和现在同事人脉id
     *
     * @param id
     * @param operId
     * @param customerId
     * @param companyName
     * @param industry    行业
     * @return
     */
    public List<Long> queryPeopleIds1(Long id, Long operId, Long customerId, String companyName, String industry) {
        JPAQuery<Long> jpaQuerySelect = jpaQueryFactory.select(qdo.id).from(qdo).where(qdo.deleteFlag.eq(0)).where(qdo.id.ne(id));

        BooleanExpression jpaQueryOr = null;

        if (operId != null && customerId != null) {
            jpaQueryOr = qdo.operId.eq(operId).or(qdo.customerId.eq(customerId));
            //  jpaQuerySelect.where(qdo.operId.eq(operId).or(qdo.customerId.eq(customerId)).or(qdo.industry.eq(industry)));
        } else {
            if (operId != null) {
                jpaQueryOr = qdo.operId.eq(operId);
                //  jpaQuerySelect.where(qdo.operId.eq(operId).or(qdo.industry.eq(industry)));
            } else if (customerId != null) {
                jpaQueryOr = qdo.customerId.eq(customerId);
                //jpaQuerySelect.where(qdo.customerId.eq(customerId).or(qdo.industry.eq(industry)));
            } else if (StringUtils.hasText(companyName)) {
                jpaQueryOr = qdo.companyName.eq(companyName);
                // jpaQuerySelect.where(qdo.companyName.eq(companyName).or(qdo.industry.eq(industry)));
            }
//            else {
//                jpaQuerySelect.where(qdo.industry.eq(industry));
//            }
        }
        if (StringUtils.hasText(industry)) {
            if (jpaQueryOr == null) {
                jpaQueryOr = qdo.industry.eq(industry);
            } else {
                jpaQueryOr = jpaQueryOr.or(qdo.industry.eq(industry));
            }
        }
        jpaQuerySelect.where(jpaQueryOr);
        return jpaQuerySelect.fetch();

    }

    /**
     * 查询过往同事人脉id
     *
     * @return
     */
    public List<Long> queryPeopleIds2(Long id, List<Long> customerIds, List<String> companyNames) {
        JPAQuery<Long> jpaQuerySelect = jpaQueryFactory.select(qdo.id).from(qdo).where(qdo.deleteFlag.eq(0)).where(qdo.id.ne(id));
        if (!ObjectUtils.isEmpty(customerIds) && !ObjectUtils.isEmpty(companyNames)) {
            jpaQuerySelect.where(qdo.customerId.in(customerIds).or(qdo.companyName.in(companyNames)));
        } else {
            if (!ObjectUtils.isEmpty(customerIds)) {
                jpaQuerySelect.where(qdo.customerId.in(customerIds));
            } else if (!ObjectUtils.isEmpty(companyNames)) {
                jpaQuerySelect.where(qdo.companyName.in(companyNames));
            }
        }
        return jpaQuerySelect.fetch();

    }
}
