package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleWorkQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleWorkVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmPeopleWorkDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleWorkRepo;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 人脉-工作经历
 *
 * @author carl
 * @date 2022/12/07
 */
@Repository
@RequiredArgsConstructor
public class CrmPeopleWorkDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmPeopleWorkRepo repo;
    private final QCrmPeopleWorkDO qdo = QCrmPeopleWorkDO.crmPeopleWorkDO;
    private final QCrmCustomerDO qdoCustomer = QCrmCustomerDO.crmCustomerDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmPeopleWorkVO> getJpaQuerySelect() {
        JPAQuery<CrmPeopleWorkVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmPeopleWorkVO.class,
                qdo.id,
                qdo.peopleId,
                qdo.customerId,
                qdoCustomer.customerName,
                qdo.companyName,
                qdo.custType,
                qdo.jobs,
                qdo.workStatus,
                qdo.startDate,
                qdo.endDate,
                qdo.createUserId,
                qdo.modifyTime,
                qdo.createTime,
                qdo.remark
        )).from(qdo).leftJoin(qdoCustomer).on(qdo.customerId.eq(qdoCustomer.id));
        return jpaQuery;
    }

    /**
     * 列表查询
     *
     * @param query
     * @return
     */
    public List<CrmPeopleWorkVO> queryList(CrmPeopleWorkQuery query) {
        JPAQuery<CrmPeopleWorkVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getPeopleId())) {
            jpaQuery.where(qdo.peopleId.eq(query.getPeopleId()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerId())) {
            jpaQuery.where(qdo.customerId.eq(query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty(query.getCompanyName())) {
            jpaQuery.where(qdo.companyName.eq(query.getCompanyName()));
        }
        if (!ObjectUtils.isEmpty(query.getWorkStatus())) {
            jpaQuery.where(qdo.workStatus.eq(query.getWorkStatus()));
        }

        if (!ObjectUtils.isEmpty(query.getId())) {
            jpaQuery.where(qdo.id.ne(query.getId()));
        }
        jpaQuery.where(qdo.deleteFlag.eq(0));
        List<OrderItem> orders = new ArrayList<>();
        orders.add(OrderItem.desc("startDate"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orders));
        return jpaQuery.fetch();
    }

    /**
     * 主键查询
     *
     * @param key
     * @return
     */
    public CrmPeopleWorkVO queryByKey(Long key) {
        JPAQuery<CrmPeopleWorkVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(key)).where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }


    /**
     * 更改人脉在职工作状态
     *
     * @param peopleIds 主键
     * @return 删除的行数
     */
    public long updateWorkStatusByPeopleIds(List<Long> peopleIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.workStatus, "0")
                .set(qdo.endDate, LocalDate.now())
                .where(qdo.peopleId.in(peopleIds)).where(qdo.workStatus.eq("1"));
        return update.execute();
    }

    /**
     * 更改人脉在职工作所属公司
     *
     * @param peopleIds 人脉主键
     * @return
     */
    public long updateCustomerIdByPeopleIds(List<Long> peopleIds, Long customerId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.customerId, customerId)
                .where(qdo.peopleId.in(peopleIds)).where(qdo.workStatus.eq("1"));
        return update.execute();
    }
}
