package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPotentialCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPotentialCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmPotentialCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPotentialCustomerRepo;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.persistence.EntityManager;
import javax.persistence.criteria.*;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class CrmPotentialCustomerDAO {
    private final CrmPotentialCustomerRepo repo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QCrmPotentialCustomerDO qdo = QCrmPotentialCustomerDO.crmPotentialCustomerDO;
    private final EntityManager em;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmPotentialCustomerDO save(CrmPotentialCustomerDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmPotentialCustomerDO> saveAll(List<CrmPotentialCustomerDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 批量插入
     *
     * @param dos dos
     */
    @Transactional(rollbackFor = Exception.class)
    public void batchInsert(List<CrmPotentialCustomerDO> dos) {
        for (CrmPotentialCustomerDO entity : dos) {
            //insert插入操作
            em.persist(entity);
            //entityManager.merge(entity);//update更新操作
        }
        em.flush();
        em.clear();
    }

    /**
     * 批量更新
     *
     * @param dos dos
     */
    @Transactional(rollbackFor = Exception.class)
    public void batchUpdate(List<CrmPotentialCustomerDO> dos) {
        for (CrmPotentialCustomerDO entity : dos) {
            //update更新操作
            em.merge(entity);
        }
        em.flush();
        em.clear();
    }


    public Specification<CrmPotentialCustomerDO> getSpec(CrmPotentialCustomerQuery query) {
        Specification<CrmPotentialCustomerDO> querySpecifi = (root, criteriaQuery, cb) -> {
            List<Predicate> predicates = new ArrayList<>();
            Join<CrmPotentialCustomerDO, CrmOpenseaDO> openseaJoin = root.join("opensea", JoinType.LEFT);
            if (!ObjectUtils.isEmpty(query.getOpenseaId())) {
                if(query.getOpenseaId()!=0){
                    predicates.add(cb.equal(openseaJoin.get("id").as(String.class), query.getOpenseaId()));
                }
            }
            if (!StringUtils.isEmpty(query.getOpenseaIds())) {
                String[] split = query.getOpenseaIds().split(",");
                //in查询
                Path<Object> path = openseaJoin.get("id");
                CriteriaBuilder.In<Object> in = cb.in(path);
                for (int i = 0; i < split.length; i++) {
                    in.value(Long.valueOf(split[i]));
                }
                predicates.add(cb.and(in));
            }
            if (!StringUtils.isEmpty(query.getTagIds())) {
                String[] split = query.getTagIds().split(",");
                Predicate[] predicatesArray = new Predicate[split.length];
                for (int i = 0; i < split.length; i++) {
                    predicatesArray[i] = cb.like(root.get("tagIds").as(String.class), SqlUtil.toSqlLikeString(split[i]));
                }
                predicates.add(cb.or(predicatesArray));
            }
            if (!StringUtils.isEmpty(query.getCustomerName())) {
                predicates.add(cb.like(root.get("customerName").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerName())));
            }
            if (!StringUtils.isEmpty(query.getCustomerNameEqual())) {
                predicates.add(cb.equal(root.get("customerName").as(String.class), query.getCustomerNameEqual()));
            }
            if (!StringUtils.isEmpty(query.getDemandProduct())) {
                predicates.add(cb.equal(root.get("demandProduct").as(String.class), query.getDemandProduct()));
            }
            if (!StringUtils.isEmpty(query.getCustomerContacts())) {
                predicates.add(cb.like(root.get("customerContacts").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerContacts())));
            }
            if (!StringUtils.isEmpty(query.getCustomerGrade())) {
                predicates.add(cb.equal(root.get("customerGrade").as(String.class), query.getCustomerGrade()));
            }
            if (!StringUtils.isEmpty(query.getCustomerIndustry())) {
                predicates.add(cb.equal(root.get("customerIndustry").as(String.class), query.getCustomerIndustry()));
            }
            Join<CrmPotentialCustomerDO, PrjProjectDO> marketJoin = root.join("market", JoinType.LEFT);
            if (!ObjectUtils.isEmpty(query.getMarketId())) {
                predicates.add(cb.equal(marketJoin.get("id").as(String.class), query.getMarketId()));
            }
            if (!StringUtils.isEmpty(query.getCustomerPhone())) {
                predicates.add(cb.like(root.get("customerPhone").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerPhone())));
            }
            if (!StringUtils.isEmpty(query.getCustomerStatus())) {
                predicates.add(cb.equal(root.get("customerStatus").as(String.class), query.getCustomerStatus()));
            }
            if (!ObjectUtils.isEmpty(query.getCreateTimeStart())) {
                //大于或等于开始时间
                predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), query.getCreateTimeStart()));
            }
            if (!ObjectUtils.isEmpty(query.getCreateTimeEnd())) {
                //小于或等于结束时间
                predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), query.getCreateTimeEnd()));
            }
            if (!StringUtils.isEmpty(query.getCustomerLocationCityName())) {
                predicates.add(cb.like(root.get("customerLocationCityName").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerLocationCityName())));
            }
            if (!StringUtils.isEmpty(query.getArea())) {
                predicates.add(cb.like(root.get("customerLocationCityName").as(String.class), SqlUtil.toSqlLikeString(query.getArea())));
            }
            if (!StringUtils.isEmpty(query.getMarketChannel())) {
                predicates.add(cb.equal(root.get("marketChannel").as(String.class), query.getMarketChannel()));
            }
            if (!StringUtils.isEmpty(query.getCustomerEmail())) {
                predicates.add(cb.like(root.get("customerEmail").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerEmail())));
            }
            if (!StringUtils.isEmpty(query.getCustRegion())) {
                predicates.add(cb.equal(root.get("custRegion").as(String.class),query.getCustRegion()));
            }
            if (!ObjectUtils.isEmpty(query.getPotentialCustomerIds())) {
                //in查询
                Path<Object> path = root.get("id");
                CriteriaBuilder.In<Object> in = cb.in(path);
                for (Long id : query.getPotentialCustomerIds()) {
                    in.value(id);
                }
                predicates.add(cb.and(in));
            }
            if (!ObjectUtils.isEmpty(query.getPotentialCustomerIdsForFollow())) {
                //in查询
                Path<Object> path = root.get("id");
                CriteriaBuilder.In<Object> in = cb.in(path);
                for (Long id : query.getPotentialCustomerIdsForFollow()) {
                    in.value(id);
                }
                predicates.add(cb.and(in));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        return querySpecifi;
    }

    public List<CrmPotentialCustomerDO> findAll(Specification<CrmPotentialCustomerDO> spec) {
        return repo.findAll(spec);
    }

    public Page<CrmPotentialCustomerDO> findAll(Specification<CrmPotentialCustomerDO> spec, Pageable pageable) {
        pageable = PageUtil.defaultSort(pageable);
        return repo.findAll(spec, pageable);
    }

    public long countAll(Specification<CrmPotentialCustomerDO> spec) {
        return repo.count(spec);
    }

    public CrmPotentialCustomerDO queryById(Long id) {
        return repo.findById(id).orElse(null);
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateProvinceCityDistrict(CrmPotentialCustomerPayload payload){
        jpaQueryFactory.update(qdo)
                .set(qdo.customerLocationProvince, payload.getCustomerLocationProvince())
                .set(qdo.customerLocationProvinceName, payload.getCustomerLocationProvinceName())
                .set(qdo.customerLocationCity, payload.getCustomerLocationCity())
                .set(qdo.customerLocationCityName, payload.getCustomerLocationCityName())
                .set(qdo.customerLocationDistrict, payload.getCustomerLocationDistrict())
                .set(qdo.customerLocationDistrictName, payload.getCustomerLocationDistrictName())
                .where(qdo.id.eq(payload.getId()))
                .execute();
    }
    public void updateByKeyDynamic(CrmPotentialCustomerPayload payload) {
        //查询出当前的do
        CrmPotentialCustomerDO pCustomer = repo.findById(payload.getId()).orElse(null);
        if (pCustomer != null) {
            if (payload.getCustomerStatus() != null) {
                pCustomer.setCustomerStatus(payload.getCustomerStatus());
            }
            if (payload.getTransferReason() != null) {
                pCustomer.setTransferReason(payload.getTransferReason());
            }
            if (payload.getRemark() != null) {
                pCustomer.setRemark(payload.getRemark());
            }
            if (payload.getCustomerName() != null) {
                pCustomer.setCustomerName(payload.getCustomerName());
            }
            if (payload.getCustomerGrade() != null) {
                pCustomer.setCustomerGrade(payload.getCustomerGrade());
            }

            if (payload.getCustomerIndustry() != null) {
                pCustomer.setCustomerIndustry(payload.getCustomerIndustry());
            }
            if (payload.getCustomerContacts() != null) {
                pCustomer.setCustomerContacts(payload.getCustomerContacts());
            }
            if (payload.getCustomerPhone() != null) {
                pCustomer.setCustomerPhone(payload.getCustomerPhone());
            }
            if (payload.getCustomerEmail() != null) {
                pCustomer.setCustomerEmail(payload.getCustomerEmail());
            }

            if (payload.getCustomerLocationProvince() != null) {
                pCustomer.setCustomerLocationProvince(payload.getCustomerLocationProvince());
            }
//            else{
//                pCustomer.setCustomerLocationProvince(null);
//                pCustomer.setCustomerLocationProvinceName(null);
//            }
            if (payload.getCustomerLocationCity() != null) {
                pCustomer.setCustomerLocationCity(payload.getCustomerLocationCity());
                pCustomer.setCustomerLocationProvinceName(null);
            }
//            else{
//                pCustomer.setCustomerLocationCity(null);
//                pCustomer.setCustomerLocationCityName(null);
//            }
            if (payload.getCustomerLocationDistrict() != null) {
                pCustomer.setCustomerLocationDistrict(payload.getCustomerLocationDistrict());
            }
//            else{
//                pCustomer.setCustomerLocationDistrict(null);
//                pCustomer.setCustomerLocationDistrictName(null);
//            }

            if (payload.getCustomerLocationDetail() != null) {
                pCustomer.setCustomerLocationDetail(payload.getCustomerLocationDetail());
            }
            if (payload.getCustomerLocationProvinceName() != null) {
                pCustomer.setCustomerLocationProvinceName(payload.getCustomerLocationProvinceName());
            }
            if (payload.getCustomerLocationCityName() != null) {
                pCustomer.setCustomerLocationCityName(payload.getCustomerLocationCityName());
            }
            if (payload.getCustomerLocationDistrictName() != null) {
                pCustomer.setCustomerLocationDistrictName(payload.getCustomerLocationDistrictName());
            }
            if (payload.getTagIds() != null) {
                pCustomer.setTagIds(payload.getTagIds());
            }
            if (payload.getDemandProduct() != null){
                pCustomer.setDemandProduct(payload.getDemandProduct());
            }

            if (payload.getMarketId() != null) {
                PrjProjectDO market = new PrjProjectDO();
                market.setId(payload.getMarketId());
                pCustomer.setMarket(market);
            }

            if (payload.getOpenseaId() != null) {
                CrmOpenseaDO opensea = new CrmOpenseaDO();
                opensea.setId(payload.getOpenseaId());
                pCustomer.setOpensea(opensea);
            }

            if (payload.getCustRegion() != null) {
                pCustomer.setCustRegion(payload.getCustRegion());
            }

            if (payload.getMarketChannel() != null) {
                pCustomer.setMarketChannel(payload.getMarketChannel());
            }

            if (payload.getContactsDepartment() != null) {
                pCustomer.setContactsDepartment(payload.getContactsDepartment());
            }

            if (payload.getContactsPosition() != null) {
                pCustomer.setContactsPosition(payload.getContactsPosition());
            }

            // 处理要设置成空的字段
            List<String> nullFields = payload.getNullFields();
            if (nullFields != null && nullFields.size() > 0) {
//                customerGrade;
//                customerIndustry;
//                customerContacts;
//                customerPhone;
//                customerEmail;
//                customerLocationProvince;
//                customerLocationCity;
//                customerLocationDistrict;
//                customerLocationDetail;
            }
            repo.save(pCustomer);
        }
    }


    public List<CrmPotentialCustomerDO> queryByOpenseaId(Long openseaId) {
        return repo.findByOpensea_Id(openseaId);
    }

    public long deleteSoft(Long[] keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public void updateCustomerGrade(List<Long> potentialCustomerIds, String grade) {
        repo.updateCustomerGrade(potentialCustomerIds,grade);
    }

    public CrmPotentialCustomerDO findById(Long id) {
        return repo.findById(id).orElse(null);
    }
}
