package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 市场计划表
 * @Date
 **/
@Entity
@Table(name = "crm_act_plan", indexes = {
        @Index(name = "org_index", columnList = "org_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_act_plan", comment = "市场计划表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmActPlanDO extends BaseModel {

    @Comment("编号")
    @Column()
    private String planNo;

    @Comment("名称")
    @Column()
    private String planName;

    @Comment("bu（组织）")
    @Column(name = "org_id")
    private Long orgId;

    @Comment("预算年度")
    @Column()
    private String planYear;

    @Comment("预算总金额")
    @Column()
    private BigDecimal budgetMoney;

    @Comment("产出总线索")
    @Column()
    private Integer leadNum;

    @Comment("产出预估总数")
    @Column()
    private BigDecimal pipeline;

    @Comment("状态")
    @Column()
    private String planStatus;

    @Comment("关闭或重新打开原因")
    @Column()
    private String operateReason;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

}
