package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 客户经营-信息化系统
 *
 * @author haobo.chang
 * @date 2022/12/26
 */
@Entity
@Table(name = "crm_cust_oper_info_sys", indexes = {
        @Index(name = "oper_index", columnList = "operId"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_cust_oper_info_sys", comment = "客户经营-信息化系统")
@Data
@Getter
@Setter
@Where(clause = "delete_flag=0")
public class CrmCustOperInfoSysDO extends BaseModel implements Serializable {


    @Serial
    private static final long serialVersionUID = -4257420882681643188L;

    @Comment("客户经营主键crm_customer_operation.id")
    @Column(nullable = false)
    private Long operId;

    @Comment("系统类型")
    @Column
    private String sysType;

    @Comment("系统名称")
    @Column
    private String sysName;

    @Comment("系统所属公司")
    @Column
    private String belongCompany;

    @Comment("实施范围")
    @Column
    private String implScope;

    @Comment("系统功能")
    @Column
    private String sysFunc;

    @Comment("系统上线时间")
    @Column
    private LocalDateTime onlineTime;

    @Comment("系统版本")
    @Column(length = 64)
    private String sysVersion;
}
