package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/14 - 23:34
 */
@Entity
@Table(name = "crm_customer", indexes = {
        @Index(name = "book_index", columnList = "book_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer", comment = "客户表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmCustomerDO extends BaseModel {
    @Comment("地址簿id")
    @Column(name = "book_id")
    private Long bookId;


    @Comment("客户状态(激活，暂挂)")
    @Column()
    private String customerStatus;

    @Comment("客户名称")
    @Column()
    private String customerName;

    @Comment("客户级别")
    @Column()
    private String customerGrade;

    @Comment("客户来源")
    @Column()
    private String customerSource;

    @Comment("服务负责人")
    @Column()
    private Long serviceUserId;

    @Comment("商务负责人")
    @Column()
    private Long businessUserId;

    @Comment("关怀负责人")
    @Column()
    private Long careUserId;

    @Comment("运维售后负责人")
    @Column()
    private Long operationUserId;
}
