package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;

/**
 * 人脉经营-经营机会点
 *
 * @author carl
 * @date 2022/11/21
 */
@Entity
@Table(name = "crm_customer_operation_chance", indexes = {@Index(name = "oper_index", columnList = "oper_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_chance", comment = " 人脉经营-经营机会点")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmCustomerOperationChanceDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = 7655285261129870145L;

    @Comment("人脉经营主键 crm_customer_operation.id")
    @Column(name = "oper_id")
    private Long operId;

    @FieldUpdateLog(fieldName = "标题")
    @Comment("标题")
    @Column()
    private String title;

    @FieldUpdateLog(fieldName = "跟踪人", selectionKey = "USER")
    @Comment("跟踪人")
    @Column()
    private Long trackerUserId;


    @Comment("标签")
    @Column()
    private String tags;

    @FieldUpdateLog(fieldName = "标签")
    @Comment("标签值")
    @Column()
    private String tagsName;

    @Comment("是否已读")
    @Column()
    private Integer isRead;
    /**
     * 参与人
     */
    @Comment("参与人")
    @Column()
    private String involvedUserIds;
    /**
     * 知会人
     */
    @Comment("知会人")
    @Column()
    private String informUserIds;

    @FieldUpdateLog(fieldName = "知会人")
    @Comment("知会人名称")
    @Column()
    private String informUserNames;
    /**
     * 预计时间年份
     */
    @Comment("预计时间年份")
    @Column()
    private Integer expectYear;
    /**
     * 预计时间季度
     */
    @Comment("预计时间季度")
    @Column()
    private Integer expectQuarter;
    /**
     * 详细描述
     */
    @FieldUpdateLog(fieldName = "详情描述")
    @Comment("详细描述")
    @Column()
    private String chanceContent;

    /**
     * 预计时间
     */
    @FieldUpdateLog(fieldName = "预计时间")
    @Comment("预计时间")
    @Column()
    private String expectTime;

    public CrmCustomerOperationChanceDO() {
    }

    public void copy(CrmCustomerOperationChanceDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
