package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
* 客户经营-企业工商主要人员
*
* @author duwh
* @date 2022-12-06
*/
@Entity
@Table(name = "crm_customer_operation_employees", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_employees", comment = "客户经营-企业工商主要人员")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmCustomerOperationEmployeesDO extends BaseModel  {
    /** 客户经营主键 */
    @Comment("客户经营主键")
    @Column()
    private Long operId;
    /** 主要人员姓名 */
    @Comment("主要人员姓名")
    @Column()
    private String name;
    /** 主要人员职位 */
    @Comment("主要人员职位")
    @Column()
    private String title;
    /** 是否历史，是否历史；0：否1：是 */
    @Comment("是否历史，是否历史；0：否1：是")
    @Column()
    private Integer isHistory;

    public void copy(CrmCustomerOperationEmployeesDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
