package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
* 客户经营-工商股东（含历史）
*
* @author duwh
* @date 2022-12-06
*/
@Entity
@Table(name = "crm_customer_operation_partners", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_partners", comment = "客户经营-工商股东（含历史）")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmCustomerOperationPartnersDO extends BaseModel  {
    /** 客户经营主键 */
    @Comment("客户经营主键")
    @Column()
    private Long operId;
    /** 总实缴 */
    @Comment("总实缴")
    @Column()
    private String totalRealCapi;
    /** 出资时间 */
    @Comment("出资时间")
    @Column()
    private String date;
    /** 历史股东 */
    @Comment("历史股东")
    @Column()
    private String isHstory;
    /** 股东类型 */
    @Comment("股东类型")
    @Column()
    private String stockType;
    /** 股东姓名 */
    @Comment("股东姓名")
    @Column()
    private String name;
    /** 人员id（股东为自然人显示pid） */
    @Comment("人员id（股东为自然人显示pid）")
    @Column()
    private String pid;
    /** 总认缴 */
    @Comment("总认缴")
    @Column()
    private String totalShouldCapi;
    /** 企业id（股东为企业显示eid） */
    @Comment("企业id（股东为企业显示eid）")
    @Column()
    private String eid;
    /** 类型 */
    @Comment("类型")
    @Column()
    private String identifyType;
    /** 认缴出资额 */
    @Comment("认缴出资额")
    @Column()
    private String capi;
    /** 股东ID */
    @Comment("股东ID")
    @Column()
    private String identifyNo;
    /** 实缴出资列表 */
    @Comment("实缴出资列表")
    @Column()
    private String realCapiItems;
    /** 出资方式 */
    @Comment("出资方式")
    @Column()
    private String type;
    /** 认缴出资列表 */
    @Comment("认缴出资列表")
    @Column()
    private String shouldCapiItems;
    /** 股比 */
    @Comment("股比")
    @Column()
    private String stockPercent;

    public void copy(CrmCustomerOperationPartnersDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
