package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * @author zoey
 * @Description:线索近海双向关联中间表
 * @date 2022/5/31 - 23:53
 */
@Entity
@Table(name = "crm_leads_offshore",uniqueConstraints = {
        @UniqueConstraint(columnNames = {"leadsId","offshoreId"})})
@org.hibernate.annotations.Table(appliesTo = "crm_leads_offshore", comment = "线索表近海关联表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
@NamedEntityGraphs({
        @NamedEntityGraph(name = "leadsoffshore.list", attributeNodes = {
                @NamedAttributeNode(value = "offshore",subgraph = "offshoreDetail"),
                @NamedAttributeNode(value = "leads",subgraph = "leadsDetail")
        },subgraphs = {
                @NamedSubgraph(name="offshoreDetail",attributeNodes = {
                        @NamedAttributeNode("offshoreMembers"),
                        @NamedAttributeNode("offshoreAdmins")
                }),
                @NamedSubgraph(name="leadsDetail",attributeNodes = {
                        @NamedAttributeNode(value = "market"),
                        @NamedAttributeNode(value = "customer")
                })
        }),
})

public class CrmLeadsOffshoreDO extends BaseModel {

    @FieldUpdateLog(fieldName = "近海",selectionKey = "OFFSHORE",changeAction = "转移到")
    @FieldCreateLog(fieldName = "近海",selectionKey = "OFFSHORE")
    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name="offshoreId",referencedColumnName="id", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private CrmOffshoreDO offshore;

    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name="leadsId",referencedColumnName="id", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private CrmLeadsDO leads;

    @Comment("未分配提醒时间")
    private LocalDateTime notDistributeLeadsRemindTime;

    /**
     * 排序
     */
//    @Comment("线索编号")
//    @Column(name = "leads_offshores_order")
//    private Integer leadsOffshoresOrder;

}
