package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.util.List;

/**
 * @author zoey
 * @Description:近海表
 * @date 2022/5/17 - 11:33
 */
@Entity
@Table(name = "crm_offshore")
@org.hibernate.annotations.Table(appliesTo = "crm_offshore", comment = "近海表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
@NamedEntityGraphs(
        {
        @NamedEntityGraph(name = "offshore.rule.list", attributeNodes = {
//                @NamedAttributeNode(value = "offshoreRule")
                @NamedAttributeNode("offshoreAdmins"),
                @NamedAttributeNode("offshoreMembers")
        }),
        @NamedEntityGraph(name = "offshore.rule.detail", attributeNodes = {
                @NamedAttributeNode(value = "offshoreRule",subgraph = "ruleDetail"),
                @NamedAttributeNode("offshoreAdmins"),
                @NamedAttributeNode("offshoreMembers")
        },
        subgraphs = {
                @NamedSubgraph(name="ruleDetail",attributeNodes = {
                        @NamedAttributeNode("offshoreRuleAttrExcludes"),
                        @NamedAttributeNode(value = "regainRule",subgraph = "triggerRules")
                }),
                @NamedSubgraph(name="triggerRules",attributeNodes = {
                })
        })}
)
public class CrmOffshoreDO extends BaseModel {
    @Comment("近海名称")
    @Column(name = "offshore_name",unique = true)
    private String offshoreName;

//    @Comment("管理员")
//    @OneToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
//    @JoinColumn(name="offshore_admin_id",referencedColumnName="id")
//    private PrdOrgEmployeeDO offshoreAdmin;

//    @Comment("管理员")
//    @Column(name = "offshore_admin_id")
//    private Long offshoreAdminId;

    @Comment("线索总数")
    @Column(name = "leads_num")
    private Integer leadsNum;

    @Comment("近海成员列表")
    @OrderColumn
    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name="offshoreId", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private List<CrmOffshoreMembersDO> offshoreMembers;


    @Comment("近海管理员列表")
    @OrderColumn
    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name="offshoreId", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private List<CrmOffshoreAdminDO> offshoreAdmins;

    @OneToOne(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name="ruleId",referencedColumnName="id",foreignKey = @ForeignKey(ConstraintMode.NO_CONSTRAINT))
    private CrmOffshoreRuleDO offshoreRule;


//    @Comment("线索列表")
//    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
//    @OrderColumn
//    @JsonIgnoreProperties(value = { "offshores" })
//    private List<CrmLeadsDO> leads;

}
