package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.util.List;

/**
 * @author zoey
 * @Description:近海规则表
 * @date 2022/5/17 - 11:34
 */
@Entity
@Table(name = "crm_offshore_rule")
@org.hibernate.annotations.Table(appliesTo = "crm_offshore_rule", comment = "近海规则表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOffshoreRuleDO extends BaseModel {
    @Comment("近海表")
    @OneToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name="offshoreId",referencedColumnName="id")
    private CrmOffshoreDO offshore;


    @Comment("分配领取规则")
    @Column(name = "distribute_receive_rule")
    private String distributeReceiveRule;

    @Comment("新线索提醒:1:提醒；0：不提醒")
    @Column(name = "new_leads_remind")
    private Integer newLeadsRemind;

    @Comment("线索领取上限")
    @Column(name = "receive_leads_limit")
    private Integer receiveLeadsLimit;

    @Comment("线索连续领取天数上限")
    @Column(name = "receive_leads_limit_days")
    private Integer receiveLeadsLimitDays;

    @Comment("领取线索提醒:1:提醒；0：不提醒")
    @Column(name = "receive_leads_remind")
    private Integer receiveLeadsRemind;

    @Comment("超时未分配提醒时间")
    @Column(name = "distribute_leads_remind_time")
    private Long distributeLeadsRemindTime;

    @Comment("超时未跟进提醒时间")
    @Column(name = "follow_leads_remind_time")
    private Long followLeadsRemindTime;

    @Comment("查看未领取线索跟进动态:1:是；0：否")
    @Column(name = "show_follow_before_receive")
    private Integer showFollowBeforeReceive;

    @Comment("排除字段列表")
    @OrderColumn
    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name="ruleId", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private List<CrmOffshoreRuleAttrExcludeDO> offshoreRuleAttrExcludes;

    @Comment("是否设置自动收回:1:是；0：否")
    @Column(name = "auto_regain")
    private Integer autoRegain;

    @Comment("收回规则表")
    @OneToOne(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name="ruleId",referencedColumnName="id")
    private CrmOffshoreRuleRegainDO regainRule;

}
