package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.util.List;

/**
 * @author zoey
 * @Description:公海表
 * @date 2022/6/14 - 14:53
 */
@Entity
@Table(name = "crm_opensea")
@org.hibernate.annotations.Table(appliesTo = "crm_opensea", comment = "公海表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
//@Inheritance(strategy = InheritanceType.JOINED)
@NamedEntityGraphs(
        {
                @NamedEntityGraph(name = "opensea.rule.list", attributeNodes = {
                        @NamedAttributeNode("openseaAdmins"),
                        @NamedAttributeNode("openseaMembers")
                }),
                @NamedEntityGraph(name = "opensea.rule.detail", attributeNodes = {
                        @NamedAttributeNode("openseaAdmins"),
                        @NamedAttributeNode("openseaMembers")
                }),
        }
)
public class CrmOpenseaDO extends BaseModel {

    @Comment("公海名称")
    @Column(name = "opensea_name", unique = true)
    private String openseaName;

    @Comment("潜在客户总数")
    @Column(name = "customer_num")
    private Integer customerNum;

    @Comment("转移原因")
    @Column(name = "transfer_reason")
    private String transferReason;

    @Comment("公海成员列表")
    @OrderColumn
    @OneToMany(fetch = FetchType.EAGER, cascade = CascadeType.ALL)
    @JoinColumn(name = "openseaId", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private List<CrmOpenseaMembersDO> openseaMembers;


    @Comment("公海管理员列表")
    @OrderColumn
    @OneToMany(fetch = FetchType.EAGER, cascade = CascadeType.ALL)
    @JoinColumn(name = "openseaId", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private List<CrmOpenseaAdminDO> openseaAdmins;


}
